/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.deployment;

import io.quarkiverse.mcp.server.AudioContent;
import io.quarkiverse.mcp.server.BlobResourceContents;
import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.DefaultValueConverter;
import io.quarkiverse.mcp.server.EmbeddedResource;
import io.quarkiverse.mcp.server.ExecutionModel;
import io.quarkiverse.mcp.server.GlobalInputSchemaGenerator;
import io.quarkiverse.mcp.server.GlobalOutputSchemaGenerator;
import io.quarkiverse.mcp.server.ImageContent;
import io.quarkiverse.mcp.server.InitialCheck;
import io.quarkiverse.mcp.server.MetaField;
import io.quarkiverse.mcp.server.MetaKey;
import io.quarkiverse.mcp.server.ModelHint;
import io.quarkiverse.mcp.server.ModelPreferences;
import io.quarkiverse.mcp.server.PromptFilter;
import io.quarkiverse.mcp.server.PromptMessage;
import io.quarkiverse.mcp.server.PromptResponse;
import io.quarkiverse.mcp.server.ResourceContents;
import io.quarkiverse.mcp.server.ResourceFilter;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.ResourceTemplateFilter;
import io.quarkiverse.mcp.server.Role;
import io.quarkiverse.mcp.server.SamplingMessage;
import io.quarkiverse.mcp.server.SamplingRequest;
import io.quarkiverse.mcp.server.TextContent;
import io.quarkiverse.mcp.server.TextResourceContents;
import io.quarkiverse.mcp.server.ToolFilter;
import io.quarkiverse.mcp.server.ToolManager;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.WrapBusinessError;
import io.quarkiverse.mcp.server.deployment.DefaultValueConverterBuildItem;
import io.quarkiverse.mcp.server.deployment.DotNames;
import io.quarkiverse.mcp.server.deployment.FeatureAnnotationsBuildItem;
import io.quarkiverse.mcp.server.deployment.FeatureMethodBuildItem;
import io.quarkiverse.mcp.server.deployment.ServerNameBuildItem;
import io.quarkiverse.mcp.server.runtime.BuiltinDefaultValueConverters;
import io.quarkiverse.mcp.server.runtime.DefaultResourceContentsEncoder;
import io.quarkiverse.mcp.server.runtime.DefaultSchemaGenerator;
import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkiverse.mcp.server.runtime.FeatureArgument;
import io.quarkiverse.mcp.server.runtime.FeatureMetadata;
import io.quarkiverse.mcp.server.runtime.FeatureMethodInfo;
import io.quarkiverse.mcp.server.runtime.JsonTextContentEncoder;
import io.quarkiverse.mcp.server.runtime.McpMetadata;
import io.quarkiverse.mcp.server.runtime.McpObjectMapperCustomizer;
import io.quarkiverse.mcp.server.runtime.McpServerRecorder;
import io.quarkiverse.mcp.server.runtime.MicrometerMcpMetrics;
import io.quarkiverse.mcp.server.runtime.NotificationManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.PromptEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.PromptManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceContentsEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.ResourceManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateCompletionManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResourceTemplateManagerImpl;
import io.quarkiverse.mcp.server.runtime.ResponseHandlers;
import io.quarkiverse.mcp.server.runtime.ResultMappers;
import io.quarkiverse.mcp.server.runtime.SamplingRequestImpl;
import io.quarkiverse.mcp.server.runtime.ToolEncoderResultMapper;
import io.quarkiverse.mcp.server.runtime.ToolManagerImpl;
import io.quarkiverse.mcp.server.runtime.ToolStructuredContentResultMapper;
import io.quarkiverse.mcp.server.runtime.WrapBusinessErrorInterceptor;
import io.quarkiverse.mcp.server.runtime.config.McpServerBuildTimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersBuildTimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.InvokerFactoryBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InvokerBuilder;
import io.quarkus.arc.processor.KotlinUtils;
import io.quarkus.arc.processor.Types;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.execannotations.ExecutionModelAnnotationsAllowedBuildItem;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.Gizmo;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.Type;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import jakarta.annotation.Priority;
import jakarta.enterprise.invoke.Invoker;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;
import org.jboss.logging.Logger;

class McpServerProcessor {
    private static final Logger LOG = Logger.getLogger(McpServerProcessor.class);
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final Set<DotName> ARG_ANNOTATIONS = Set.of(DotNames.TOOL_ARG, DotNames.PROMPT_ARG, DotNames.COMPLETE_ARG, DotNames.RESOURCE_TEMPLATE_ARG);
    private static final Set<org.jboss.jandex.Type> PROMPT_TYPES = Set.of(ClassType.create((DotName)DotNames.PROMPT_RESPONSE), ClassType.create((DotName)DotNames.PROMPT_MESSAGE));
    private static final Set<org.jboss.jandex.Type> COMPLETE_TYPES = Set.of(ClassType.create((DotName)DotNames.COMPLETE_RESPONSE), ClassType.create((DotName)DotNames.STRING));
    private static final Set<org.jboss.jandex.Type> TOOL_TYPES = Set.of(ClassType.create((DotName)DotNames.TOOL_RESPONSE), ClassType.create((DotName)DotNames.CONTENT), ClassType.create((DotName)DotNames.TEXT_CONTENT), ClassType.create((DotName)DotNames.IMAGE_CONTENT), ClassType.create((DotName)DotNames.EMBEDDED_RESOURCE), ClassType.create((DotName)DotNames.RESOURCE_LINK), ClassType.create((DotName)DotNames.STRING));
    static final Set<org.jboss.jandex.Type> RESOURCE_TYPES = Set.of(ClassType.create((DotName)DotNames.RESOURCE_RESPONSE), ClassType.create((DotName)DotNames.RESOURCE_CONTENTS), ClassType.create((DotName)DotNames.TEXT_RESOURCE_CONTENTS), ClassType.create((DotName)DotNames.BLOB_RESOURCE_CONTENTS));

    McpServerProcessor() {
    }

    @BuildStep
    FeatureAnnotationsBuildItem featureAnnotations(McpServersBuildTimeConfig config) {
        Map<DotName, Feature> annotationToFeature = config.supportLangchain4jAnnotations() ? Map.of(DotNames.PROMPT, Feature.PROMPT, DotNames.COMPLETE_PROMPT, Feature.PROMPT_COMPLETE, DotNames.RESOURCE, Feature.RESOURCE, DotNames.RESOURCE_TEMPLATE, Feature.RESOURCE_TEMPLATE, DotNames.COMPLETE_RESOURCE_TEMPLATE, Feature.RESOURCE_TEMPLATE_COMPLETE, DotNames.TOOL, Feature.TOOL, DotNames.LANGCHAIN4J_TOOL, Feature.TOOL, DotNames.NOTIFICATION, Feature.NOTIFICATION) : Map.of(DotNames.PROMPT, Feature.PROMPT, DotNames.COMPLETE_PROMPT, Feature.PROMPT_COMPLETE, DotNames.RESOURCE, Feature.RESOURCE, DotNames.RESOURCE_TEMPLATE, Feature.RESOURCE_TEMPLATE, DotNames.COMPLETE_RESOURCE_TEMPLATE, Feature.RESOURCE_TEMPLATE_COMPLETE, DotNames.TOOL, Feature.TOOL, DotNames.NOTIFICATION, Feature.NOTIFICATION);
        return new FeatureAnnotationsBuildItem(annotationToFeature);
    }

    @BuildStep
    void addBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder unremovable = AdditionalBeanBuildItem.builder().setUnremovable();
        unremovable.addBeanClass("io.quarkiverse.mcp.server.runtime.ConnectionManager");
        unremovable.addBeanClass(ResponseHandlers.class);
        unremovable.addBeanClass(DefaultSchemaGenerator.class);
        unremovable.addBeanClass(McpObjectMapperCustomizer.class);
        unremovable.addBeanClasses(new Class[]{PromptManagerImpl.class, ToolManagerImpl.class, ResourceManagerImpl.class, PromptCompletionManagerImpl.class, ResourceTemplateManagerImpl.class, ResourceTemplateCompletionManagerImpl.class, NotificationManagerImpl.class});
        unremovable.addBeanClasses(new Class[]{JsonTextContentEncoder.class, DefaultResourceContentsEncoder.class});
        unremovable.addBeanClasses(new Class[]{ToolEncoderResultMapper.class, ResourceContentsEncoderResultMapper.class, PromptEncoderResultMapper.class, ToolStructuredContentResultMapper.class});
        additionalBeans.produce((BuildItem)unremovable.build());
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{WrapBusinessError.class, WrapBusinessErrorInterceptor.class}));
    }

    @BuildStep
    void autoScopes(BuildProducer<AutoAddScopeBuildItem> autoScopes, FeatureAnnotationsBuildItem featureAnnotations) {
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().containsAnnotations((DotName[])featureAnnotations.annotationToFeature().keySet().toArray(DotName[]::new)).anyMethodMatches(featureAnnotations::isFeatureMethod).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(ToolFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(PromptFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(ResourceFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(ResourceTemplateFilter.class)).defaultScope(BuiltinScope.SINGLETON).build());
        autoScopes.produce((BuildItem)AutoAddScopeBuildItem.builder().implementsInterface(DotName.createSimple(InitialCheck.class)).defaultScope(BuiltinScope.SINGLETON).build());
    }

    @BuildStep
    ExecutionModelAnnotationsAllowedBuildItem executionModelAnnotations(FeatureAnnotationsBuildItem featureAnnotations, final TransformedAnnotationsBuildItem transformedAnnotations) {
        final Set<DotName> annotations = featureAnnotations.annotationToFeature().keySet();
        return new ExecutionModelAnnotationsAllowedBuildItem((Predicate)new Predicate<MethodInfo>(){

            @Override
            public boolean test(MethodInfo method) {
                return Annotations.containsAny((Collection)transformedAnnotations.getAnnotations((AnnotationTarget)method), (Iterable)annotations);
            }
        });
    }

    @BuildStep
    void collectFeatureMethods(McpServersBuildTimeConfig config, BeanDiscoveryFinishedBuildItem beanDiscovery, InvokerFactoryBuildItem invokerFactory, List<DefaultValueConverterBuildItem> defaultValueConverters, CombinedIndexBuildItem combinedIndex, TransformedAnnotationsBuildItem transformedAnnotations, FeatureAnnotationsBuildItem featureAnnotations, BuildProducer<FeatureMethodBuildItem> features, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        List list2;
        List resourceTemplates;
        String message;
        List<Throwable> wrongUsages = this.findWrongAnnotationUsage(combinedIndex, featureAnnotations, errors);
        if (!wrongUsages.isEmpty()) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(wrongUsages));
        }
        HashMap<Feature, List> found = new HashMap<Feature, List>();
        for (BeanInfo bean : beanDiscovery.beanStream().classBeans().filter(featureAnnotations::hasFeatureMethod)) {
            ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
            for (MethodInfo methodInfo : beanClass.methods()) {
                OptionalInt nameMaxLength;
                AnnotationValue value;
                AnnotationInstance guardrails;
                AnnotationInstance metaField;
                AnnotationValue descValue;
                AnnotationValue value2;
                AnnotationValue nameValue;
                AnnotationInstance featureAnnotation = featureAnnotations.getFeatureAnnotation(methodInfo);
                if (featureAnnotation == null) continue;
                Feature feature = featureAnnotations.getFeature(featureAnnotation);
                this.validateFeatureMethod(methodInfo, feature, featureAnnotation, defaultValueConverters, combinedIndex.getComputingIndex());
                String name = feature == Feature.PROMPT_COMPLETE || feature == Feature.RESOURCE_TEMPLATE_COMPLETE ? featureAnnotation.value().asString() : ((nameValue = featureAnnotation.value("name")) != null ? nameValue.asString() : methodInfo.name());
                String title = null;
                AnnotationValue titleValue = featureAnnotation.value("title");
                if (titleValue != null) {
                    title = titleValue.asString();
                }
                String description = feature == Feature.TOOL && methodInfo.hasDeclaredAnnotation(DotNames.LANGCHAIN4J_TOOL) ? ((value2 = featureAnnotation.value()) != null ? Arrays.stream(value2.asStringArray()).collect(Collectors.joining()) : "") : (feature == Feature.NOTIFICATION ? featureAnnotation.value().asEnum() : ((descValue = featureAnnotation.value("description")) != null ? descValue.asString() : ""));
                InvokerBuilder invokerBuilder = invokerFactory.createInvoker(bean, methodInfo).withInstanceLookup();
                String uri = null;
                String mimeType = null;
                int size = -1;
                boolean structuredContent = false;
                Object outputSchemaFrom = null;
                Object outputSchemaGenerator = null;
                Object inputSchemaGenerator = null;
                ToolManager.ToolAnnotations toolAnnotations = null;
                Content.Annotations resourceAnnotations = null;
                HashMap<String, String> metadata = new HashMap<String, String>();
                if (feature == Feature.RESOURCE) {
                    AnnotationValue sizeValue;
                    uriValue = featureAnnotation.value("uri");
                    if (uriValue != null) {
                        uri = uriValue.asString();
                    }
                    if ((mimeTypeValue = featureAnnotation.value("mimeType")) != null) {
                        mimeType = mimeTypeValue.asString();
                    }
                    if ((sizeValue = featureAnnotation.value("size")) != null) {
                        size = sizeValue.asInt();
                    }
                    resourceAnnotations = this.parseResourceAnnotations(featureAnnotation);
                } else if (feature == Feature.RESOURCE_TEMPLATE) {
                    uriValue = featureAnnotation.value("uriTemplate");
                    if (uriValue != null) {
                        uri = uriValue.asString();
                    }
                    if ((mimeTypeValue = featureAnnotation.value("mimeType")) != null) {
                        mimeType = mimeTypeValue.asString();
                    }
                    resourceAnnotations = this.parseResourceAnnotations(featureAnnotation);
                } else if (feature == Feature.TOOL) {
                    AnnotationValue outputSchemaValue;
                    AnnotationValue structuredContentValue;
                    AnnotationValue annotations = featureAnnotation.value("annotations");
                    if (annotations != null) {
                        AnnotationInstance annotationsAnnotation = annotations.asNested();
                        AnnotationValue annoTitleValue = annotationsAnnotation.value("title");
                        AnnotationValue readOnlyHintValue = annotationsAnnotation.value("readOnlyHint");
                        AnnotationValue destructiveHintValue = annotationsAnnotation.value("destructiveHint");
                        AnnotationValue idempotentHintValue = annotationsAnnotation.value("idempotentHint");
                        AnnotationValue openWorldHintValue = annotationsAnnotation.value("openWorldHint");
                        toolAnnotations = new ToolManager.ToolAnnotations(annoTitleValue != null ? annoTitleValue.asString() : null, readOnlyHintValue != null ? readOnlyHintValue.asBoolean() : false, destructiveHintValue != null ? destructiveHintValue.asBoolean() : true, idempotentHintValue != null ? idempotentHintValue.asBoolean() : false, openWorldHintValue != null ? openWorldHintValue.asBoolean() : true);
                    }
                    if ((structuredContentValue = featureAnnotation.value("structuredContent")) != null) {
                        structuredContent = structuredContentValue.asBoolean();
                    }
                    if ((outputSchemaValue = featureAnnotation.value("outputSchema")) != null) {
                        AnnotationValue outputSchemaFromValue = outputSchemaValue.asNested().value("from");
                        outputSchemaFrom = outputSchemaFromValue != null ? outputSchemaFromValue.asClass() : this.outputSchemaFromReturnType(methodInfo.returnType());
                        AnnotationValue outputSchemaGeneratorValue = outputSchemaValue.asNested().value("generator");
                        outputSchemaGenerator = outputSchemaGeneratorValue != null ? outputSchemaGeneratorValue.asClass() : ClassType.create(GlobalOutputSchemaGenerator.class);
                    } else if (structuredContent) {
                        outputSchemaFrom = this.outputSchemaFromReturnType(methodInfo.returnType());
                        outputSchemaGenerator = ClassType.create(GlobalOutputSchemaGenerator.class);
                    }
                    AnnotationValue inputSchemaValue = featureAnnotation.value("inputSchema");
                    if (inputSchemaValue != null) {
                        AnnotationValue inputSchemaValueGeneratorValue = inputSchemaValue.asNested().value("generator");
                        inputSchemaGenerator = inputSchemaValueGeneratorValue != null ? inputSchemaValueGeneratorValue.asClass() : ClassType.create(GlobalInputSchemaGenerator.class);
                    }
                }
                String server = "<default>";
                AnnotationInstance serverAnotation = methodInfo.declaredAnnotation(DotNames.MCP_SERVER);
                if (serverAnotation == null) {
                    serverAnotation = methodInfo.declaringClass().declaredAnnotation(DotNames.MCP_SERVER);
                }
                if (serverAnotation != null) {
                    server = serverAnotation.value().asString();
                }
                if ((metaField = methodInfo.declaredAnnotation(DotNames.META_FIELD)) != null) {
                    this.addMetaField(metadata, metaField);
                } else {
                    AnnotationInstance metaFields = methodInfo.declaredAnnotation(DotNames.META_FIELDS);
                    if (metaFields != null) {
                        for (org.jboss.jandex.Type[] entry : metaFields.value().asNestedArray()) {
                            this.addMetaField(metadata, (AnnotationInstance)entry);
                        }
                    }
                }
                List<DotName> inputGuardrails = List.of();
                List<DotName> outputGuardrails = List.of();
                if (feature == Feature.TOOL && (guardrails = methodInfo.declaredAnnotation(DotNames.TOOL_GUARDRAILS)) != null) {
                    AnnotationValue output;
                    int n;
                    AnnotationValue input = guardrails.value("input");
                    if (input != null) {
                        org.jboss.jandex.Type[] entry;
                        inputGuardrails = new ArrayList();
                        entry = input.asClassArray();
                        int n2 = entry.length;
                        for (n = 0; n < n2; ++n) {
                            org.jboss.jandex.Type clazz = entry[n];
                            inputGuardrails.add(clazz.name());
                        }
                    }
                    if ((output = guardrails.value("output")) != null) {
                        outputGuardrails = new ArrayList();
                        org.jboss.jandex.Type[] typeArray = output.asClassArray();
                        n = typeArray.length;
                        for (int i = 0; i < n; ++i) {
                            org.jboss.jandex.Type clazz = typeArray[i];
                            outputGuardrails.add(clazz.name());
                        }
                    }
                }
                DotName iconsProvider = null;
                AnnotationInstance icons = methodInfo.declaredAnnotation(DotNames.ICONS);
                if (icons != null && (value = icons.value()) != null) {
                    iconsProvider = value.asClass().name();
                }
                OptionalInt optionalInt = nameMaxLength = feature == Feature.TOOL ? ((McpServerBuildTimeConfig)config.servers().get(server)).tools().nameMaxLength() : OptionalInt.empty();
                if (nameMaxLength.isPresent() && name.length() > nameMaxLength.getAsInt()) {
                    String message2 = "Tool name [%s] exceeds the maximum length of %s characters".formatted(name, nameMaxLength.getAsInt());
                    errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message2)}));
                    continue;
                }
                FeatureMethodBuildItem fm = new FeatureMethodBuildItem(bean, methodInfo, invokerBuilder.build(), name, title, description, uri, mimeType, size, feature, toolAnnotations, server, structuredContent, (org.jboss.jandex.Type)outputSchemaFrom, (org.jboss.jandex.Type)outputSchemaGenerator, (org.jboss.jandex.Type)inputSchemaGenerator, resourceAnnotations, (Map<String, String>)metadata, inputGuardrails, outputGuardrails, McpServerProcessor.executionModel(methodInfo, transformedAnnotations), iconsProvider);
                features.produce((BuildItem)fm);
                found.compute(feature, (f, list) -> {
                    if (list == null) {
                        list = new ArrayList<FeatureMethodBuildItem>();
                    }
                    list.add(fm);
                    return list;
                });
            }
        }
        for (List featureMethods : found.values()) {
            Map<String, List> byName = featureMethods.stream().collect(Collectors.toMap(this::getDuplicateValidationName, List::of, (v1, v2) -> {
                ArrayList list = new ArrayList();
                list.addAll(v1);
                list.addAll(v2);
                return list;
            }));
            for (Map.Entry<String, List> entry : byName.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                message = "Duplicate feature method found for %s:\n\t%s".formatted(entry.getKey(), entry.getValue().stream().map(Object::toString).collect(Collectors.joining("\n\t")));
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message)}));
            }
        }
        List resources = (List)found.get(Feature.RESOURCE);
        if (resources != null) {
            Map<String, List> byUri = resources.stream().collect(Collectors.toMap(FeatureMethodBuildItem::getUri, List::of, (v1, v2) -> {
                ArrayList list = new ArrayList();
                list.addAll(v1);
                list.addAll(v2);
                return list;
            }));
            for (List list3 : byUri.values()) {
                if (list3.size() <= 1) continue;
                String string = "Duplicate resource uri found:\n\t%s".formatted(list3.stream().map(Object::toString).collect(Collectors.joining("\n\t")));
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(string)}));
            }
        }
        if ((resourceTemplates = (List)found.get(Feature.RESOURCE_TEMPLATE)) != null) {
            Map<String, List> byUri = resourceTemplates.stream().collect(Collectors.toMap(FeatureMethodBuildItem::getUri, List::of, (v1, v2) -> {
                ArrayList list = new ArrayList();
                list.addAll(v1);
                list.addAll(v2);
                return list;
            }));
            for (List list4 : byUri.values()) {
                if (list4.size() <= 1) continue;
                message = "Duplicate resource template uri found:\n\t%s".formatted(list4.stream().map(Object::toString).collect(Collectors.joining("\n\t")));
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message)}));
            }
        }
        List prompts = (List)found.get(Feature.PROMPT);
        List list5 = (List)found.get(Feature.PROMPT_COMPLETE);
        if (list5 != null) {
            for (FeatureMethodBuildItem completion : list5) {
                if (prompts != null && !prompts.stream().noneMatch(p -> p.getName().equals(completion.getName()))) continue;
                String message4 = "Prompt %s does not exist for completion: %s".formatted(new Object[]{completion.getName(), completion});
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message4)}));
            }
        }
        if ((list2 = (List)found.get(Feature.RESOURCE_TEMPLATE_COMPLETE)) != null) {
            for (FeatureMethodBuildItem completion : list2) {
                if (resourceTemplates != null && !resourceTemplates.stream().noneMatch(p -> p.getName().equals(completion.getName()))) continue;
                String message5 = "Resource template %s does not exist for completion: %s".formatted(new Object[]{completion.getName(), completion});
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message5)}));
            }
        }
    }

    @BuildStep
    void validateGuardrails(BeanArchiveIndexBuildItem beanArchiveIndex, List<FeatureMethodBuildItem> featureMethods, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (FeatureMethodBuildItem featureMethod : featureMethods) {
            if (!featureMethod.isTool()) continue;
            for (DotName inputGuardRail : featureMethod.getInputGuardrails()) {
                this.validateGuardrail(beanArchiveIndex.getIndex(), featureMethod, inputGuardRail, validationPhase.getContext(), validationErrors, reflectiveClasses);
            }
            for (DotName outputGuardRail : featureMethod.getOutputGuardrails()) {
                this.validateGuardrail(beanArchiveIndex.getIndex(), featureMethod, outputGuardRail, validationPhase.getContext(), validationErrors, reflectiveClasses);
            }
        }
    }

    @BuildStep
    void addMetricsSupport(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        if (metricsCapability.map(m -> m.metricsSupported("micrometer")).orElse(false).booleanValue()) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(MicrometerMcpMetrics.class));
        }
    }

    private void validateGuardrail(IndexView index, FeatureMethodBuildItem featureMethod, DotName guardrailClazzName, BeanDeploymentValidator.ValidationContext validationContext, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        ClassInfo clazz = index.getClassByName(guardrailClazzName);
        List beans = validationContext.beans().withBeanType(guardrailClazzName).collect();
        if (beans.size() > 1) {
            String message = String.format("There must be exactly one bean that matches the guardrail: \"%s\" declared on: %s; beans: %s", guardrailClazzName, String.valueOf(featureMethod.getMethod().declaringClass().name()) + "#" + featureMethod.getMethod().name() + "()", beans);
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException(message)}));
        } else if (beans.isEmpty() && clazz != null) {
            MethodInfo noArgsConstructor = clazz.method("<init>", new org.jboss.jandex.Type[0]);
            if (noArgsConstructor == null || !Modifier.isPublic(noArgsConstructor.flags())) {
                errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("Guardrail implementations must be CDI beans, or declare a public no-args constructor: " + String.valueOf(clazz))}));
            } else {
                reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{guardrailClazzName.toString()}).constructors().build());
            }
        }
        AnnotationInstance supportedExecutionModels = clazz.declaredAnnotation(DotNames.SUPPORTED_EXEC_MODELS);
        if (supportedExecutionModels != null) {
            for (String supportedModel : supportedExecutionModels.value().asEnumArray()) {
                if (!supportedModel.equals(featureMethod.getExecutionModel().toString())) continue;
                return;
            }
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(new Throwable[]{new IllegalStateException("Guardrail %s does not support the execution model %s of %s#%s()".formatted(guardrailClazzName, featureMethod.getExecutionModel(), featureMethod.getMethod().declaringClass(), featureMethod.getMethod().name()))}));
        }
    }

    private void addMetaField(Map<String, String> metadata, AnnotationInstance metaEntry) {
        AnnotationValue prefixValue = metaEntry.value("prefix");
        String name = metaEntry.value("name").asString();
        MetaKey key = new MetaKey(prefixValue != null ? prefixValue.asString() : null, name);
        String value = metaEntry.value("value").asString();
        AnnotationValue typeValue = metaEntry.value("type");
        MetaField.Type type = typeValue != null ? MetaField.Type.valueOf((String)typeValue.asEnum()) : MetaField.Type.STRING;
        String jsonValue = switch (type) {
            case MetaField.Type.STRING -> {
                String var10_9;
                yield var10_9 = Json.encode((Object)value);
            }
            case MetaField.Type.BOOLEAN, MetaField.Type.INT -> {
                String var10_9;
                yield var10_9 = value;
            }
            case MetaField.Type.JSON -> {
                String var10_9;
                try {
                    Json.decodeValue((String)value);
                }
                catch (DecodeException e) {
                    throw new IllegalArgumentException("Invalid JSON value: " + value);
                }
                yield var10_9 = value;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(type));
        };
        metadata.put(key.toString(), jsonValue);
    }

    private ClassType outputSchemaFromReturnType(org.jboss.jandex.Type returnType) {
        if (returnType.name().equals((Object)DotNames.UNI)) {
            return ClassType.create((DotName)((org.jboss.jandex.Type)returnType.asParameterizedType().arguments().get(0)).name());
        }
        return ClassType.create((DotName)returnType.name());
    }

    private Content.Annotations parseResourceAnnotations(AnnotationInstance featureAnnotation) {
        AnnotationValue annotationsValue = featureAnnotation.value("annotations");
        if (annotationsValue != null) {
            AnnotationInstance annotationsAnnotation = annotationsValue.asNested();
            AnnotationValue audienceValue = annotationsAnnotation.value("audience");
            AnnotationValue lastModifiedValue = annotationsAnnotation.value("lastModified");
            AnnotationValue priorityValue = annotationsAnnotation.value("priority");
            return new Content.Annotations(audienceValue != null ? Role.valueOf((String)audienceValue.asEnum()) : null, lastModifiedValue != null ? lastModifiedValue.asString() : null, priorityValue != null ? Double.valueOf(priorityValue.asDouble()) : null);
        }
        return null;
    }

    private List<Throwable> findWrongAnnotationUsage(CombinedIndexBuildItem combinedIndex, FeatureAnnotationsBuildItem featureAnnotations, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<Throwable> wrongUsages = new ArrayList<Throwable>();
        for (Map.Entry<DotName, Feature> e : featureAnnotations.annotationToFeature().entrySet()) {
            this.findWrongMethods(combinedIndex.getIndex(), e.getKey(), e.getValue(), wrongUsages);
        }
        return wrongUsages;
    }

    private void findWrongMethods(IndexView index, DotName annotationName, Feature feature, List<Throwable> wrongUsages) {
        for (AnnotationInstance annotation : index.getAnnotations(annotationName)) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            if (Modifier.isStatic(annotation.target().asMethod().flags())) {
                wrongUsages.add(new IllegalStateException(String.valueOf(feature) + " method must not be static: " + McpServerProcessor.methodDesc(annotation.target().asMethod())));
                continue;
            }
            if (!annotation.target().asMethod().declaringClass().isInterface()) continue;
            wrongUsages.add(new IllegalStateException(String.valueOf(feature) + " method must not be declared on an interface: " + McpServerProcessor.methodDesc(annotation.target().asMethod())));
        }
    }

    private String getDuplicateValidationName(FeatureMethodBuildItem featureMethod) {
        if (featureMethod.getFeature() == Feature.PROMPT_COMPLETE || featureMethod.getFeature() == Feature.RESOURCE_TEMPLATE_COMPLETE) {
            AnnotationValue value;
            MethodParameterInfo argument = featureMethod.getMethod().parameters().stream().filter(p -> this.providerFrom(p.type()) == FeatureArgument.Provider.PARAMS).findFirst().orElseThrow();
            String argumentName = argument.name();
            AnnotationInstance completeArg = argument.declaredAnnotation(DotNames.COMPLETE_ARG);
            if (completeArg != null && (value = completeArg.value()) != null) {
                argumentName = value.asString();
            }
            return featureMethod.getName() + argumentName;
        }
        return featureMethod.getName();
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void generateMetadata(McpServerRecorder recorder, RecorderContext recorderContext, BeanDiscoveryFinishedBuildItem beanDiscovery, List<FeatureMethodBuildItem> featureMethods, List<DefaultValueConverterBuildItem> defaultValueConverters, List<ServerNameBuildItem> serverNames, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        String metadataClassName = "io.quarkiverse.mcp.server.runtime.McpMetadata_Impl";
        ClassCreator metadataCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(metadataClassName).interfaces(new Class[]{McpMetadata.class}).build();
        boolean isResourceManagerUsed = false;
        boolean isResourceTemplateManagerUsed = false;
        boolean isPromptManagerUsed = false;
        boolean isToolManagerUsed = false;
        for (InjectionPointInfo ip : beanDiscovery.getInjectionPoints()) {
            if (ip.getRequiredType().name().equals((Object)DotNames.RESOURCE_MANAGER)) {
                isResourceManagerUsed = true;
                continue;
            }
            if (ip.getRequiredType().name().equals((Object)DotNames.RESOURCE_TEMPLATE_MANAGER)) {
                isResourceTemplateManagerUsed = true;
                continue;
            }
            if (ip.getRequiredType().name().equals((Object)DotNames.PROMPT_MANAGER)) {
                isPromptManagerUsed = true;
                continue;
            }
            if (!ip.getRequiredType().name().equals((Object)DotNames.TOOL_MANAGER)) continue;
            isToolManagerUsed = true;
        }
        MethodCreator isResourceManagerUsedMethod = metadataCreator.getMethodCreator("isResourceManagerUsed", Boolean.TYPE, new Class[0]);
        isResourceManagerUsedMethod.returnValue(isResourceManagerUsedMethod.load(isResourceManagerUsed));
        MethodCreator isResourceTemplateManagerUsedMethod = metadataCreator.getMethodCreator("isResourceTemplateManagerUsed", Boolean.TYPE, new Class[0]);
        isResourceTemplateManagerUsedMethod.returnValue(isResourceTemplateManagerUsedMethod.load(isResourceTemplateManagerUsed));
        MethodCreator isPromptManagerUsedMethod = metadataCreator.getMethodCreator("isPromptManagerUsed", Boolean.TYPE, new Class[0]);
        isPromptManagerUsedMethod.returnValue(isPromptManagerUsedMethod.load(isPromptManagerUsed));
        MethodCreator isToolManagerUsedMethod = metadataCreator.getMethodCreator("isToolManagerUsed", Boolean.TYPE, new Class[0]);
        isToolManagerUsedMethod.returnValue(isToolManagerUsedMethod.load(isToolManagerUsed));
        AtomicInteger counter = new AtomicInteger();
        MethodCreator promptsMethod = metadataCreator.getMethodCreator("prompts", List.class, new Class[0]);
        ResultHandle retPrompts = Gizmo.newArrayList((BytecodeCreator)promptsMethod);
        for (FeatureMethodBuildItem prompt : featureMethods.stream().filter(FeatureMethodBuildItem::isPrompt).toList()) {
            this.processFeatureMethod(counter, metadataCreator, promptsMethod, prompt, retPrompts, DotNames.PROMPT_ARG);
        }
        promptsMethod.returnValue(retPrompts);
        MethodCreator promptCompletionsMethod = metadataCreator.getMethodCreator("promptCompletions", List.class, new Class[0]);
        ResultHandle retPromptCompletions = Gizmo.newArrayList((BytecodeCreator)promptCompletionsMethod);
        for (FeatureMethodBuildItem promptCompletion : featureMethods.stream().filter(FeatureMethodBuildItem::isPromptComplete).toList()) {
            this.processFeatureMethod(counter, metadataCreator, promptCompletionsMethod, promptCompletion, retPromptCompletions, DotNames.COMPLETE_ARG);
        }
        promptCompletionsMethod.returnValue(retPromptCompletions);
        MethodCreator toolsMethod = metadataCreator.getMethodCreator("tools", List.class, new Class[0]);
        ResultHandle retTools = Gizmo.newArrayList((BytecodeCreator)toolsMethod);
        for (FeatureMethodBuildItem tool : featureMethods.stream().filter(FeatureMethodBuildItem::isTool).toList()) {
            this.processFeatureMethod(counter, metadataCreator, toolsMethod, tool, retTools, tool.getMethod().hasDeclaredAnnotation(DotNames.LANGCHAIN4J_TOOL) ? DotNames.LANGCHAIN4J_P : DotNames.TOOL_ARG);
        }
        toolsMethod.returnValue(retTools);
        MethodCreator resourcesMethod = metadataCreator.getMethodCreator("resources", List.class, new Class[0]);
        ResultHandle retResources = Gizmo.newArrayList((BytecodeCreator)resourcesMethod);
        for (FeatureMethodBuildItem resource : featureMethods.stream().filter(FeatureMethodBuildItem::isResource).toList()) {
            this.processFeatureMethod(counter, metadataCreator, resourcesMethod, resource, retResources, null);
        }
        resourcesMethod.returnValue(retResources);
        MethodCreator resourceTemplatesMethod = metadataCreator.getMethodCreator("resourceTemplates", List.class, new Class[0]);
        ResultHandle retResourceTemplates = Gizmo.newArrayList((BytecodeCreator)resourceTemplatesMethod);
        for (FeatureMethodBuildItem resourceTemplate : featureMethods.stream().filter(FeatureMethodBuildItem::isResourceTemplate).toList()) {
            this.processFeatureMethod(counter, metadataCreator, resourceTemplatesMethod, resourceTemplate, retResourceTemplates, DotNames.RESOURCE_TEMPLATE_ARG);
        }
        resourceTemplatesMethod.returnValue(retResourceTemplates);
        MethodCreator resourceTemplateCompletionsMethod = metadataCreator.getMethodCreator("resourceTemplateCompletions", List.class, new Class[0]);
        ResultHandle retResourceTemplateCompletions = Gizmo.newArrayList((BytecodeCreator)resourceTemplateCompletionsMethod);
        for (FeatureMethodBuildItem resourceTemplateCompletion : featureMethods.stream().filter(FeatureMethodBuildItem::isResourceTemplateComplete).toList()) {
            this.processFeatureMethod(counter, metadataCreator, resourceTemplateCompletionsMethod, resourceTemplateCompletion, retResourceTemplateCompletions, DotNames.COMPLETE_ARG);
        }
        resourceTemplateCompletionsMethod.returnValue(retResourceTemplateCompletions);
        MethodCreator notificationsMethod = metadataCreator.getMethodCreator("notifications", List.class, new Class[0]);
        ResultHandle retNotifications = Gizmo.newArrayList((BytecodeCreator)notificationsMethod);
        for (FeatureMethodBuildItem notification : featureMethods.stream().filter(FeatureMethodBuildItem::isNotification).toList()) {
            this.processFeatureMethod(counter, metadataCreator, notificationsMethod, notification, retNotifications, null);
        }
        notificationsMethod.returnValue(retNotifications);
        MethodCreator convertersMethod = metadataCreator.getMethodCreator("defaultValueConverters", Map.class, new Class[0]);
        ResultHandle retConverters = Gizmo.newHashMap((BytecodeCreator)convertersMethod);
        for (DefaultValueConverterBuildItem converter : defaultValueConverters) {
            ResultHandle converterType = Types.getTypeHandle((BytecodeCreator)convertersMethod, (org.jboss.jandex.Type)converter.getArgumentType());
            ResultHandle converterInstance = convertersMethod.newInstance(MethodDescriptor.ofConstructor((String)converter.getClassName(), (String[])new String[0]), new ResultHandle[0]);
            Gizmo.mapOperations((BytecodeCreator)convertersMethod).on(retConverters).put(converterType, converterInstance);
        }
        convertersMethod.returnValue(retConverters);
        MethodCreator serverNamesMethod = metadataCreator.getMethodCreator("serverNames", Set.class, new Class[0]);
        ResultHandle set = Gizmo.newHashSet((BytecodeCreator)serverNamesMethod);
        for (ServerNameBuildItem serverName : serverNames) {
            Gizmo.setOperations((BytecodeCreator)serverNamesMethod).on(set).add(serverNamesMethod.load(serverName.getName()));
        }
        serverNamesMethod.returnValue(set);
        MethodCreator toolArgumentHolders = metadataCreator.getMethodCreator("toolArgumentHolders", Map.class, new Class[0]);
        ResultHandle holders = Gizmo.newHashMap((BytecodeCreator)toolArgumentHolders);
        for (FeatureMethodBuildItem tool : featureMethods.stream().filter(FeatureMethodBuildItem::isTool).toList()) {
            this.generateToolArgsHolder(toolArgumentHolders, holders, tool, (ClassOutput)classOutput, reflectiveClasses);
        }
        toolArgumentHolders.returnValue(holders);
        metadataCreator.close();
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(McpMetadata.class).scope(Singleton.class)).setRuntimeInit().runtimeValue(recorderContext.newInstance(metadataClassName)).done());
    }

    private void generateToolArgsHolder(MethodCreator toolArgumentHolders, ResultHandle holders, FeatureMethodBuildItem tool, ClassOutput classOutput, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        boolean generateHolder = false;
        ArrayList<MethodParameterInfo> serializedArguments = new ArrayList<MethodParameterInfo>();
        for (MethodParameterInfo param : tool.getMethod().parameters()) {
            if (this.providerFrom(param.type()) != FeatureArgument.Provider.PARAMS) continue;
            serializedArguments.add(param);
            List annotations = param.declaredAnnotations();
            if (annotations.isEmpty() || !annotations.stream().anyMatch(a -> !a.name().equals((Object)DotNames.TOOL_ARG) && !a.name().equals((Object)DotNames.LANGCHAIN4J_P))) continue;
            generateHolder = true;
        }
        if (generateHolder) {
            String className = tool.getMethod().declaringClass().name().toString() + "_" + tool.getName();
            LOG.debugf("Generate tool arguments holder: %s", (Object)className);
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{className}).fields().build());
            ClassCreator argumentsHolder = ClassCreator.builder().classOutput(classOutput).className(className).build();
            for (MethodParameterInfo param : serializedArguments) {
                FieldCreator paramField = argumentsHolder.getFieldCreator(param.name(), param.type().name().toString());
                paramField.setModifiers(1);
                this.setSignature(paramField, param.type());
                param.declaredAnnotations().forEach(arg_0 -> ((FieldCreator)paramField).addAnnotation(arg_0));
            }
            argumentsHolder.close();
            Gizmo.mapOperations((BytecodeCreator)toolArgumentHolders).on(holders).put(toolArgumentHolders.load(tool.getName()), toolArgumentHolders.loadClass(argumentsHolder.getClassName()));
        }
    }

    private void setSignature(FieldCreator field, org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            field.setSignature(SignatureBuilder.forField().setType(this.gizmoType(type)).build());
        }
    }

    private io.quarkus.gizmo.Type gizmoType(org.jboss.jandex.Type type) {
        if (type.kind() == Type.Kind.CLASS) {
            return io.quarkus.gizmo.Type.classType((DotName)type.name());
        }
        if (type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            ParameterizedType parameterizedType = type.asParameterizedType();
            return io.quarkus.gizmo.Type.parameterizedType((Type.ClassType)io.quarkus.gizmo.Type.classType((DotName)type.name()), (io.quarkus.gizmo.Type[])((io.quarkus.gizmo.Type[])parameterizedType.arguments().stream().map(this::gizmoType).toArray(io.quarkus.gizmo.Type[]::new)));
        }
        if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            WildcardType wildcardType = type.asWildcardType();
            return wildcardType.superBound() != null ? io.quarkus.gizmo.Type.wildcardTypeWithLowerBound((io.quarkus.gizmo.Type)this.gizmoType(wildcardType.superBound())) : io.quarkus.gizmo.Type.wildcardTypeWithUpperBound((io.quarkus.gizmo.Type)this.gizmoType(wildcardType.extendsBound()));
        }
        throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type));
    }

    @BuildStep
    void registerForReflection(List<FeatureMethodBuildItem> featureMethods, List<DefaultValueConverterBuildItem> defaultValueConverters, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        for (FeatureMethodBuildItem m : featureMethods) {
            org.jboss.jandex.Type returnType = m.getMethod().returnType();
            if (DotNames.UNI.equals((Object)returnType.name()) && returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                returnType = (org.jboss.jandex.Type)returnType.asParameterizedType().arguments().get(0);
            }
            if (DotNames.LIST.equals((Object)returnType.name()) && returnType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                returnType = (org.jboss.jandex.Type)returnType.asParameterizedType().arguments().get(0);
            }
            if (McpServerProcessor.isReturnTypeReflectionNeeded(returnType.name())) {
                reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((org.jboss.jandex.Type)m.getMethod().returnType()).build());
            }
            for (org.jboss.jandex.Type paramType : m.getMethod().parameterTypes()) {
                if (!McpServerProcessor.isParamTypeReflectionNeeded(paramType)) continue;
                reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((org.jboss.jandex.Type)paramType).build());
            }
        }
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])((String[])defaultValueConverters.stream().map(DefaultValueConverterBuildItem::getClassName).toList().toArray(String[]::new))).constructors().build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{Content.class, TextContent.class, ImageContent.class, EmbeddedResource.class, AudioContent.class, PromptResponse.class, PromptMessage.class, ToolResponse.class, FeatureMethodInfo.class, FeatureArgument.class, ResourceResponse.class, ResourceContents.class, TextResourceContents.class, BlobResourceContents.class, Role.class, SamplingMessage.class, ModelPreferences.class, ModelHint.class, SamplingRequest.IncludeContext.class, SamplingRequestImpl.class}).methods().build());
        reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(List.class).build());
        reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder(Map.class).build());
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem indexBuiltinDefaultValueConverters() {
        return new AdditionalIndexedClassesBuildItem(new String[]{BuiltinDefaultValueConverters.class.getName(), BuiltinDefaultValueConverters.BooleanConverter.class.getName(), BuiltinDefaultValueConverters.ByteConverter.class.getName(), BuiltinDefaultValueConverters.ShortConverter.class.getName(), BuiltinDefaultValueConverters.IntegerConverter.class.getName(), BuiltinDefaultValueConverters.LongConverter.class.getName(), BuiltinDefaultValueConverters.FloatConverter.class.getName(), BuiltinDefaultValueConverters.DoubleConverter.class.getName(), BuiltinDefaultValueConverters.CharacterConverter.class.getName()});
    }

    @BuildStep
    public void collectDefaultValueConverters(CombinedIndexBuildItem combinedIndex, BuildProducer<DefaultValueConverterBuildItem> converters) {
        HashMap<org.jboss.jandex.Type, List> found = new HashMap<org.jboss.jandex.Type, List>();
        for (ClassInfo converter : combinedIndex.getIndex().getAllKnownImplementations(DefaultValueConverter.class)) {
            if (converter.isAbstract()) continue;
            if (!Modifier.isPublic(converter.flags())) {
                LOG.warnf("Non-public default value converter ignored: %s", (Object)converter);
                continue;
            }
            if (!converter.hasNoArgsConstructor()) {
                LOG.warnf("Default value converter that does not declare a no-args constructor ignored: %s", (Object)converter);
                continue;
            }
            AnnotationInstance priorityAnnotation = converter.annotation(Priority.class);
            int priority = priorityAnnotation != null ? priorityAnnotation.value().asInt() : 0;
            List typeParams = JandexUtil.resolveTypeParameters((DotName)converter.name(), (DotName)DotNames.DEFAULT_VALUE_CONVERTER, (IndexView)combinedIndex.getComputingIndex());
            org.jboss.jandex.Type argumentType = (org.jboss.jandex.Type)typeParams.get(0);
            found.compute(argumentType, (k, v) -> {
                if (v == null) {
                    v = new ArrayList<DefaultValueConverterBuildItem>();
                }
                v.add(new DefaultValueConverterBuildItem(priority, converter.name().toString(), argumentType));
                return v;
            });
        }
        for (List list : found.values()) {
            list.sort(Comparator.comparingInt(DefaultValueConverterBuildItem::getPriority).reversed());
            converters.produce((BuildItem)((DefaultValueConverterBuildItem)((Object)list.get(0))));
        }
    }

    private void validateFeatureMethod(MethodInfo method, Feature feature, AnnotationInstance featureAnnotation, List<DefaultValueConverterBuildItem> defaultValueConverters, IndexView index) {
        if (Modifier.isStatic(method.flags())) {
            throw new IllegalStateException(String.valueOf(feature) + " method must not be static: " + McpServerProcessor.methodDesc(method));
        }
        if (Modifier.isPrivate(method.flags())) {
            throw new IllegalStateException(String.valueOf(feature) + " method must not be private: " + McpServerProcessor.methodDesc(method));
        }
        if (method.returnType().kind() == Type.Kind.VOID && feature != Feature.NOTIFICATION) {
            throw new IllegalStateException(String.valueOf(feature) + " method may not return void: " + McpServerProcessor.methodDesc(method));
        }
        for (MethodParameterInfo param : method.parameters()) {
            DotName argAnnotation = switch (feature) {
                case Feature.TOOL -> DotNames.TOOL_ARG;
                case Feature.PROMPT -> DotNames.PROMPT_ARG;
                case Feature.RESOURCE_TEMPLATE -> DotNames.RESOURCE_TEMPLATE_ARG;
                case Feature.PROMPT_COMPLETE, Feature.RESOURCE_TEMPLATE_COMPLETE -> DotNames.COMPLETE_ARG;
                default -> null;
            };
            HashSet<DotName> invalidAnnotations = new HashSet<DotName>(ARG_ANNOTATIONS);
            if (argAnnotation != null) {
                invalidAnnotations.remove(argAnnotation);
            }
            for (DotName invalidAnnotation : invalidAnnotations) {
                if (!param.hasDeclaredAnnotation(invalidAnnotation)) continue;
                throw new IllegalStateException("Parameter of a %s method may not be annotated with @%s: %s".formatted(feature, invalidAnnotation.withoutPackagePrefix(), McpServerProcessor.methodDesc(method)));
            }
        }
        switch (feature) {
            case PROMPT: {
                this.validatePromptMethod(method);
                break;
            }
            case PROMPT_COMPLETE: {
                this.validatePromptCompleteMethod(method);
                break;
            }
            case TOOL: {
                this.validateToolMethod(method, defaultValueConverters, index);
                break;
            }
            case RESOURCE: {
                this.validateResourceMethod(method);
                break;
            }
            case RESOURCE_TEMPLATE: {
                this.validateResourceTemplateMethod(method, featureAnnotation);
                break;
            }
            case RESOURCE_TEMPLATE_COMPLETE: {
                this.validateResourceTemplateCompleteMethod(method);
                break;
            }
            case NOTIFICATION: {
                this.validateNotificationMethod(method);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported feature: " + String.valueOf(feature));
            }
        }
    }

    private void validatePromptMethod(MethodInfo method) {
        List<MethodParameterInfo> parameters = this.parameters(method, Feature.PROMPT);
        for (MethodParameterInfo param : parameters) {
            if (param.type().name().equals((Object)DotNames.STRING)) continue;
            throw new IllegalStateException("Prompt method must only consume String parameters: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validatePromptCompleteMethod(MethodInfo method) {
        org.jboss.jandex.Type type = method.returnType();
        if (DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (!COMPLETE_TYPES.contains(type)) {
            throw new IllegalStateException("Unsupported Prompt complete method return type: " + McpServerProcessor.methodDesc(method));
        }
        List<MethodParameterInfo> parameters = this.parameters(method, Feature.PROMPT_COMPLETE);
        if (parameters.size() != 1 || !parameters.get(0).type().name().equals((Object)DotNames.STRING)) {
            throw new IllegalStateException("Prompt complete must consume exactly one String argument: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateResourceTemplateCompleteMethod(MethodInfo method) {
        org.jboss.jandex.Type type = method.returnType();
        if (DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (!COMPLETE_TYPES.contains(type)) {
            throw new IllegalStateException("Unsupported Resource template complete method return type: " + McpServerProcessor.methodDesc(method));
        }
        List<MethodParameterInfo> parameters = this.parameters(method, Feature.RESOURCE_TEMPLATE_COMPLETE);
        if (parameters.size() != 1 || !parameters.get(0).type().name().equals((Object)DotNames.STRING)) {
            throw new IllegalStateException("Resource template complete must consume exactly one String argument: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateToolMethod(MethodInfo method, List<DefaultValueConverterBuildItem> defaultValueConverters, IndexView index) {
        this.parameters(method, Feature.TOOL);
        for (MethodParameterInfo p : method.parameters()) {
            ClassInfo pclazz;
            AnnotationValue defaultValueValue;
            AnnotationInstance toolArg = p.annotation(DotNames.TOOL_ARG);
            if (toolArg == null || (defaultValueValue = toolArg.value(DEFAULT_VALUE)) == null || p.type().name().equals((Object)DotNames.STRING) || p.type().kind() == Type.Kind.CLASS && (pclazz = index.getClassByName(p.type().name())) != null && pclazz.isEnum()) continue;
            Object argType = p.type().kind() == Type.Kind.PRIMITIVE ? PrimitiveType.box((PrimitiveType)p.type().asPrimitiveType()) : p.type();
            if (!defaultValueConverters.stream().noneMatch(arg_0 -> McpServerProcessor.lambda$validateToolMethod$13((org.jboss.jandex.Type)argType, arg_0))) continue;
            throw new IllegalStateException("No matching default value converter found for argument type [" + String.valueOf(p.type()) + "] declared on: " + String.valueOf(p));
        }
    }

    private boolean useEncoder(org.jboss.jandex.Type type, Set<org.jboss.jandex.Type> types) {
        if (DotNames.UNI.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        if (DotNames.LIST.equals((Object)type.name()) && type.kind() == Type.Kind.PARAMETERIZED_TYPE) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
        }
        return !types.contains(type);
    }

    private void validateResourceMethod(MethodInfo method) {
        List<MethodParameterInfo> parameters = this.parameters(method, Feature.RESOURCE);
        if (!parameters.isEmpty()) {
            throw new IllegalStateException("Resource method may only accept built-in parameter types" + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateResourceTemplateMethod(MethodInfo method, AnnotationInstance featureAnnotation) {
        AnnotationValue uriTemplateValue = featureAnnotation.value("uriTemplate");
        if (uriTemplateValue == null) {
            throw new IllegalStateException("URI template not found");
        }
        ResourceTemplateManagerImpl.VariableMatcher variableMatcher = ResourceTemplateManagerImpl.createMatcherFromUriTemplate((String)uriTemplateValue.asString());
        List<MethodParameterInfo> parameters = this.parameters(method, Feature.RESOURCE_TEMPLATE);
        for (MethodParameterInfo param : parameters) {
            if (!param.type().name().equals((Object)DotNames.STRING)) {
                throw new IllegalStateException("Resource template method must only consume String parameters: " + McpServerProcessor.methodDesc(method));
            }
            if (variableMatcher.variables().contains(param.name())) continue;
            throw new IllegalStateException("Parameter [" + param.name() + "] does not match an URI template variable: " + McpServerProcessor.methodDesc(method));
        }
    }

    private void validateNotificationMethod(MethodInfo method) {
        if (!(method.returnType().kind() == Type.Kind.VOID || method.returnType().name().equals((Object)DotNames.UNI) && ((org.jboss.jandex.Type)method.returnType().asParameterizedType().arguments().get(0)).name().equals((Object)DotName.createSimple(Void.class)))) {
            throw new IllegalStateException("Notification method must return void or Uni<Void>");
        }
        List<MethodParameterInfo> params = this.parameters(method, Feature.NOTIFICATION);
        if (!params.isEmpty()) {
            throw new IllegalStateException("Notification method %s may not consume the following parameter types: %s".formatted(McpServerProcessor.methodDesc(method), params.stream().map(MethodParameterInfo::type).toList()));
        }
    }

    private List<MethodParameterInfo> parameters(MethodInfo method, Feature feature) {
        ArrayList<MethodParameterInfo> ret = new ArrayList<MethodParameterInfo>();
        for (MethodParameterInfo param : method.parameters()) {
            FeatureArgument.Provider provider = this.providerFrom(param.type());
            if (!provider.isValidFor(feature)) {
                throw new IllegalStateException("%s feature method %s may not accept parameter of type %s".formatted(feature, McpServerProcessor.methodDesc(method), param.type()));
            }
            if (provider != FeatureArgument.Provider.PARAMS) continue;
            ret.add(param);
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private void processFeatureMethod(AtomicInteger counter, ClassCreator clazz, MethodCreator method, FeatureMethodBuildItem featureMethod, ResultHandle retList, DotName argAnnotationName) {
        void var16_31;
        ResultHandle outputGuardrails;
        ResultHandle inputGuardrails;
        ResultHandle meta;
        ResultHandle resourceAnnotations;
        ResultHandle toolAnnotations;
        String methodName = "meta$" + counter.incrementAndGet();
        MethodCreator metaMethod = clazz.getMethodCreator(methodName, FeatureMetadata.class, new Class[0]);
        ResultHandle args = Gizmo.newArrayList((BytecodeCreator)metaMethod);
        for (MethodParameterInfo param : featureMethod.getMethod().parameters()) {
            void var16_20;
            String name = param.name();
            String title = null;
            String description = "";
            boolean required = true;
            Object var16_21 = null;
            if (argAnnotationName != null) {
                AnnotationInstance annotationInstance = param.declaredAnnotation(argAnnotationName);
                if (annotationInstance != null) {
                    AnnotationValue requiredValue;
                    AnnotationValue descriptionValue;
                    AnnotationValue titleValue;
                    AnnotationValue nameValue = DotNames.LANGCHAIN4J_P.equals((Object)argAnnotationName) ? annotationInstance.value() : annotationInstance.value("name");
                    if (nameValue != null) {
                        name = nameValue.asString();
                    }
                    if ((titleValue = annotationInstance.value("title")) != null) {
                        title = titleValue.asString();
                    }
                    if ((descriptionValue = annotationInstance.value("description")) != null) {
                        description = descriptionValue.asString();
                    }
                    if ((requiredValue = annotationInstance.value("required")) != null) {
                        required = requiredValue.asBoolean();
                    } else if (DotNames.OPTIONAL.equals((Object)param.type().name()) || this.hasDefaultValue(param)) {
                        required = false;
                    }
                    AnnotationValue defaultValueValue = annotationInstance.value(DEFAULT_VALUE);
                    if (defaultValueValue != null) {
                        String string = defaultValueValue.asString();
                    }
                } else if (DotNames.OPTIONAL.equals((Object)param.type().name())) {
                    required = false;
                }
            }
            if (name == null) {
                throw new IllegalStateException("Missing argument name - compile the class %s with -parameters or define the name explicitly with @%s".formatted(featureMethod.getMethod().declaringClass().name(), argAnnotationName.withoutPackagePrefix()));
            }
            ResultHandle resultHandle = Types.getTypeHandle((BytecodeCreator)metaMethod, (org.jboss.jandex.Type)param.type());
            ResultHandle provider = metaMethod.load((Enum)this.providerFrom(param.type()));
            ResultHandle arg = metaMethod.newInstance(MethodDescriptor.ofConstructor(FeatureArgument.class, (Class[])new Class[]{String.class, String.class, String.class, Boolean.TYPE, Type.class, String.class, FeatureArgument.Provider.class}), new ResultHandle[]{metaMethod.load(name), title != null ? metaMethod.load(title) : metaMethod.loadNull(), metaMethod.load(description), metaMethod.load(required), resultHandle, var16_20 != null ? metaMethod.load((String)var16_20) : metaMethod.loadNull(), provider});
            Gizmo.listOperations((BytecodeCreator)metaMethod).on(args).add(arg);
        }
        if (featureMethod.isTool() && featureMethod.getToolAnnotations() != null) {
            ToolManager.ToolAnnotations annotations = featureMethod.getToolAnnotations();
            toolAnnotations = metaMethod.newInstance(MethodDescriptor.ofConstructor(ToolManager.ToolAnnotations.class, (Class[])new Class[]{String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE}), new ResultHandle[]{annotations.title() == null ? metaMethod.loadNull() : metaMethod.load(annotations.title()), metaMethod.load(annotations.readOnlyHint()), metaMethod.load(annotations.destructiveHint()), metaMethod.load(annotations.idempotentHint()), metaMethod.load(annotations.openWorldHint())});
        } else {
            toolAnnotations = metaMethod.loadNull();
        }
        if ((featureMethod.isResource() || featureMethod.isResourceTemplate()) && featureMethod.getResourceAnnotations() != null) {
            Content.Annotations annotations = featureMethod.getResourceAnnotations();
            resourceAnnotations = metaMethod.newInstance(MethodDescriptor.ofConstructor(Content.Annotations.class, (Class[])new Class[]{Role.class, String.class, Double.class}), new ResultHandle[]{annotations.audience() == null ? metaMethod.loadNull() : metaMethod.load((Enum)annotations.audience()), annotations.lastModified() == null ? metaMethod.loadNull() : metaMethod.load(annotations.lastModified()), annotations.priority() == null ? metaMethod.loadNull() : metaMethod.load(annotations.priority().doubleValue())});
        } else {
            resourceAnnotations = metaMethod.loadNull();
        }
        Map<String, String> metaEntries = featureMethod.getMetadata();
        if (metaEntries.isEmpty()) {
            meta = Gizmo.mapOperations((BytecodeCreator)metaMethod).of();
        } else {
            meta = Gizmo.newHashMap((BytecodeCreator)metaMethod);
            Gizmo.JdkMap.JdkMapInstance mapInstance = Gizmo.mapOperations((BytecodeCreator)metaMethod).on(meta);
            for (Map.Entry<String, String> entry : metaEntries.entrySet()) {
                mapInstance.put(metaMethod.load(entry.getKey()), metaMethod.load(entry.getValue()));
            }
        }
        if (featureMethod.getInputGuardrails().isEmpty()) {
            inputGuardrails = Gizmo.listOperations((BytecodeCreator)metaMethod).of();
        } else {
            inputGuardrails = Gizmo.newArrayList((BytecodeCreator)metaMethod);
            Gizmo.JdkList.JdkListInstance list = Gizmo.listOperations((BytecodeCreator)metaMethod).on(inputGuardrails);
            for (DotName dotName : featureMethod.getInputGuardrails()) {
                list.add(metaMethod.loadClass(dotName.toString()));
            }
        }
        if (featureMethod.getOutputGuardrails().isEmpty()) {
            outputGuardrails = Gizmo.listOperations((BytecodeCreator)metaMethod).of();
        } else {
            outputGuardrails = Gizmo.newArrayList((BytecodeCreator)metaMethod);
            Gizmo.JdkList.JdkListInstance jdkListInstance = Gizmo.listOperations((BytecodeCreator)metaMethod).on(outputGuardrails);
            for (DotName clazzName : featureMethod.getOutputGuardrails()) {
                jdkListInstance.add(metaMethod.loadClass(clazzName.toString()));
            }
        }
        if (featureMethod.getIconsProvider() != null) {
            ResultHandle resultHandle = metaMethod.loadClass(featureMethod.getIconsProvider().toString());
        } else {
            ResultHandle resultHandle = metaMethod.loadNull();
        }
        ResultHandle resultHandle = metaMethod.newInstance(MethodDescriptor.ofConstructor(FeatureMethodInfo.class, (Class[])new Class[]{String.class, String.class, String.class, String.class, String.class, Integer.TYPE, List.class, String.class, ToolManager.ToolAnnotations.class, Content.Annotations.class, String.class, Class.class, Class.class, Class.class, Map.class, List.class, List.class, Class.class}), new ResultHandle[]{metaMethod.load(featureMethod.getName()), featureMethod.getTitle() != null ? metaMethod.load(featureMethod.getTitle()) : metaMethod.loadNull(), metaMethod.load(featureMethod.getDescription()), featureMethod.getUri() == null ? metaMethod.loadNull() : metaMethod.load(featureMethod.getUri()), featureMethod.getMimeType() == null ? metaMethod.loadNull() : metaMethod.load(featureMethod.getMimeType()), metaMethod.load(featureMethod.getSize()), args, metaMethod.load(featureMethod.getMethod().declaringClass().name().toString()), toolAnnotations, resourceAnnotations, metaMethod.load(featureMethod.getServer()), featureMethod.getOutputSchemaFrom() == null ? metaMethod.loadNull() : metaMethod.loadClass(featureMethod.getOutputSchemaFrom().name().toString()), featureMethod.getOutputSchemaGenerator() == null ? metaMethod.loadNull() : metaMethod.loadClass(featureMethod.getOutputSchemaGenerator().name().toString()), featureMethod.getInputSchemaGenerator() == null ? metaMethod.loadNull() : metaMethod.loadClass(featureMethod.getInputSchemaGenerator().name().toString()), meta, inputGuardrails, outputGuardrails, var16_31});
        ResultHandle invoker = metaMethod.newInstance(MethodDescriptor.ofConstructor((String)featureMethod.getInvoker().getClassName(), (String[])new String[0]), new ResultHandle[0]);
        ResultHandle executionModel = metaMethod.load((Enum)featureMethod.getExecutionModel());
        ResultHandle resultMapper = this.getMapper((BytecodeCreator)metaMethod, featureMethod);
        ResultHandle metadata = metaMethod.newInstance(MethodDescriptor.ofConstructor(FeatureMetadata.class, (Class[])new Class[]{Feature.class, FeatureMethodInfo.class, Invoker.class, ExecutionModel.class, Function.class}), new ResultHandle[]{metaMethod.load((Enum)featureMethod.getFeature()), resultHandle, invoker, executionModel, resultMapper});
        metaMethod.returnValue(metadata);
        Gizmo.listOperations((BytecodeCreator)method).on(retList).add(method.invokeVirtualMethod(metaMethod.getMethodDescriptor(), method.getThis(), new ResultHandle[0]));
    }

    private boolean hasDefaultValue(MethodParameterInfo param) {
        AnnotationInstance anno = param.annotation(DotNames.TOOL_ARG);
        if (anno == null) {
            anno = param.annotation(DotNames.PROMPT_ARG);
        }
        return anno != null && anno.value(DEFAULT_VALUE) != null;
    }

    private FeatureArgument.Provider providerFrom(org.jboss.jandex.Type type) {
        if (type.name().equals((Object)DotNames.MCP_CONNECTION)) {
            return FeatureArgument.Provider.MCP_CONNECTION;
        }
        if (type.name().equals((Object)DotNames.REQUEST_ID)) {
            return FeatureArgument.Provider.REQUEST_ID;
        }
        if (type.name().equals((Object)DotNames.MCP_LOG)) {
            return FeatureArgument.Provider.MCP_LOG;
        }
        if (type.name().equals((Object)DotNames.REQUEST_URI)) {
            return FeatureArgument.Provider.REQUEST_URI;
        }
        if (type.name().equals((Object)DotNames.PROGRESS)) {
            return FeatureArgument.Provider.PROGRESS;
        }
        if (type.name().equals((Object)DotNames.ROOTS)) {
            return FeatureArgument.Provider.ROOTS;
        }
        if (type.name().equals((Object)DotNames.SAMPLING)) {
            return FeatureArgument.Provider.SAMPLING;
        }
        if (type.name().equals((Object)DotNames.CANCELLATION)) {
            return FeatureArgument.Provider.CANCELLATION;
        }
        if (type.name().equals((Object)DotNames.RAW_MESSAGE)) {
            return FeatureArgument.Provider.RAW_MESSAGE;
        }
        if (type.name().equals((Object)DotNames.COMPLETE_CONTEXT)) {
            return FeatureArgument.Provider.COMPLETE_CONTEXT;
        }
        if (type.name().equals((Object)DotNames.META)) {
            return FeatureArgument.Provider.META;
        }
        if (type.name().equals((Object)DotNames.ELICITATION)) {
            return FeatureArgument.Provider.ELICITATION;
        }
        return FeatureArgument.Provider.PARAMS;
    }

    private ResultHandle getMapper(BytecodeCreator bytecode, FeatureMethodBuildItem featureMethod) {
        org.jboss.jandex.Type returnType = featureMethod.getMethod().returnType();
        return switch (featureMethod.getFeature()) {
            case Feature.PROMPT -> this.promptResultMapper(featureMethod, bytecode, returnType);
            case Feature.PROMPT_COMPLETE -> this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.PROMPT_COMPLETE, returnType, DotNames.COMPLETE_RESPONSE, c -> "String"));
            case Feature.TOOL -> this.toolResultMapper(featureMethod, bytecode, returnType);
            case Feature.RESOURCE_TEMPLATE, Feature.RESOURCE -> this.resourceResultMapper(featureMethod, bytecode, returnType);
            case Feature.RESOURCE_TEMPLATE_COMPLETE -> this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.RESOURCE_TEMPLATE_COMPLETE, returnType, DotNames.COMPLETE_RESPONSE, c -> "String"));
            case Feature.NOTIFICATION -> this.readResultMapper(bytecode, returnType.kind() == Type.Kind.VOID ? "ToUni" : "Identity");
            default -> throw new IllegalArgumentException("Unsupported feature: " + String.valueOf(featureMethod.getFeature()));
        };
    }

    ResultHandle resourceResultMapper(FeatureMethodBuildItem featureMethod, BytecodeCreator bytecode, org.jboss.jandex.Type returnType) {
        if (this.useEncoder(returnType, RESOURCE_TYPES)) {
            return this.encoderResultMapper(featureMethod, bytecode, returnType, ResourceContentsEncoderResultMapper.class);
        }
        return this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.RESOURCE, returnType, DotNames.RESOURCE_RESPONSE, c -> "Content"));
    }

    ResultHandle encoderResultMapper(FeatureMethodBuildItem featureMethod, BytecodeCreator bytecode, org.jboss.jandex.Type returnType, Class<?> mapperClazz) {
        ResultHandle container = bytecode.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle instance = bytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{Class.class, Annotation[].class}), container, new ResultHandle[]{bytecode.loadClass(mapperClazz), bytecode.newArray(Annotation.class, 0)});
        ResultHandle mapper = bytecode.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instance, new ResultHandle[0]);
        if (DotNames.UNI.equals((Object)returnType.name())) {
            mapper = this.useUniList(featureMethod, (org.jboss.jandex.Type)returnType.asParameterizedType().arguments().get(0)) ? bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(mapperClazz, (String)"uniList", Function.class, (Class[])new Class[0]), mapper, new ResultHandle[0]) : bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(mapperClazz, (String)"uni", Function.class, (Class[])new Class[0]), mapper, new ResultHandle[0]);
        } else if (this.useUniList(featureMethod, returnType)) {
            mapper = bytecode.invokeVirtualMethod(MethodDescriptor.ofMethod(mapperClazz, (String)"list", Function.class, (Class[])new Class[0]), mapper, new ResultHandle[0]);
        }
        return mapper;
    }

    private boolean useUniList(FeatureMethodBuildItem featureMethod, org.jboss.jandex.Type type) {
        return featureMethod.getFeature() != Feature.PROMPT && !featureMethod.isStructuredContent() && DotNames.LIST.equals((Object)type.name());
    }

    ResultHandle toolResultMapper(FeatureMethodBuildItem featureMethod, BytecodeCreator bytecode, org.jboss.jandex.Type returnType) {
        if (this.useEncoder(returnType, TOOL_TYPES)) {
            if (featureMethod.isStructuredContent()) {
                return this.encoderResultMapper(featureMethod, bytecode, returnType, ToolStructuredContentResultMapper.class);
            }
            return this.encoderResultMapper(featureMethod, bytecode, returnType, ToolEncoderResultMapper.class);
        }
        return this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.TOOL, returnType, DotNames.TOOL_RESPONSE, c -> this.isContent((DotName)c) ? "Content" : "String"));
    }

    ResultHandle promptResultMapper(FeatureMethodBuildItem featureMethod, BytecodeCreator bytecode, org.jboss.jandex.Type returnType) {
        if (this.useEncoder(returnType, PROMPT_TYPES)) {
            return this.encoderResultMapper(featureMethod, bytecode, returnType, PromptEncoderResultMapper.class);
        }
        return this.readResultMapper(bytecode, McpServerProcessor.createMapperClassSimpleName(Feature.PROMPT, returnType, DotNames.PROMPT_RESPONSE, c -> "OfMessage"));
    }

    static String createMapperClassSimpleName(Feature feature, org.jboss.jandex.Type returnType, DotName baseType, Function<DotName, String> componentMapper) {
        StringBuilder ret;
        if (returnType.name().equals((Object)baseType)) {
            return "ToUni";
        }
        org.jboss.jandex.Type type = returnType;
        if (feature == Feature.PROMPT_COMPLETE || feature == Feature.RESOURCE_TEMPLATE_COMPLETE) {
            ret = new StringBuilder("Complete");
        } else {
            String f = feature.toString();
            ret = new StringBuilder().append(f.charAt(0)).append(f.substring(1).toLowerCase());
        }
        if (DotNames.UNI.equals((Object)type.name())) {
            if ((type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0)).name().equals((Object)baseType)) {
                return "Identity";
            }
            ret.append("Uni");
        }
        if (DotNames.LIST.equals((Object)type.name())) {
            type = (org.jboss.jandex.Type)type.asParameterizedType().arguments().get(0);
            ret.append("List");
        }
        ret.append(componentMapper.apply(type.name()));
        return ret.toString();
    }

    private boolean isContent(DotName typeName) {
        return DotNames.CONTENT.equals((Object)typeName) || DotNames.TEXT_CONTENT.equals((Object)typeName) || DotNames.IMAGE_CONTENT.equals((Object)typeName) || DotNames.EMBEDDED_RESOURCE.equals((Object)typeName) || DotNames.RESOURCE_LINK.equals((Object)typeName);
    }

    private ResultHandle readResultMapper(BytecodeCreator bytecode, String mapperClassSimpleName) {
        String mapperClassName = ResultMappers.class.getName() + "$" + mapperClassSimpleName;
        return bytecode.readStaticField(FieldDescriptor.of((String)mapperClassName, (String)"INSTANCE", (String)mapperClassName));
    }

    private static ExecutionModel executionModel(MethodInfo method, TransformedAnnotationsBuildItem transformedAnnotations) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method) && (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), DotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.BLOCKING) || transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.NON_BLOCKING))) {
            throw new IllegalStateException("Kotlin `suspend` functions in MCP components may not be annotated @Blocking, @NonBlocking or @RunOnVirtualThread: " + McpServerProcessor.methodDesc(method));
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.RUN_ON_VIRTUAL_THREAD) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), DotNames.RUN_ON_VIRTUAL_THREAD)) {
            return ExecutionModel.VIRTUAL_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.BLOCKING)) {
            return ExecutionModel.WORKER_THREAD;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.NON_BLOCKING)) {
            return ExecutionModel.EVENT_LOOP;
        }
        if (transformedAnnotations.hasAnnotation((AnnotationTarget)method, DotNames.TRANSACTIONAL) || transformedAnnotations.hasAnnotation((AnnotationTarget)method.declaringClass(), DotNames.TRANSACTIONAL)) {
            return ExecutionModel.WORKER_THREAD;
        }
        return McpServerProcessor.hasBlockingSignature(method) ? ExecutionModel.WORKER_THREAD : ExecutionModel.EVENT_LOOP;
    }

    static boolean hasBlockingSignature(MethodInfo method) {
        if (KotlinUtils.isKotlinSuspendMethod((MethodInfo)method)) {
            return false;
        }
        switch (method.returnType().kind()) {
            case VOID: 
            case CLASS: 
            case ARRAY: {
                return true;
            }
            case PARAMETERIZED_TYPE: {
                DotName name = method.returnType().asParameterizedType().name();
                return !name.equals((Object)DotNames.UNI) && !name.equals((Object)DotNames.MULTI);
            }
        }
        throw new IllegalStateException("Unsupported return type:" + McpServerProcessor.methodDesc(method));
    }

    private static String methodDesc(MethodInfo method) {
        StringBuilder builder = new StringBuilder().append(method.declaringClass().name().withoutPackagePrefix()).append("#").append(method.name()).append('(');
        Iterator it = method.parameterTypes().iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(')');
        return builder.toString();
    }

    private static boolean isReturnTypeReflectionNeeded(DotName returnTypeName) {
        return !McpServerProcessor.isNameInTypes(returnTypeName, TOOL_TYPES) && !McpServerProcessor.isNameInTypes(returnTypeName, PROMPT_TYPES) && !McpServerProcessor.isNameInTypes(returnTypeName, RESOURCE_TYPES) && !McpServerProcessor.isNameInTypes(returnTypeName, COMPLETE_TYPES);
    }

    private static boolean isNameInTypes(DotName name, Set<org.jboss.jandex.Type> types) {
        for (org.jboss.jandex.Type type : types) {
            if (!name.equals((Object)type.name())) continue;
            return true;
        }
        return false;
    }

    private static boolean isParamTypeReflectionNeeded(org.jboss.jandex.Type paramType) {
        return paramType.kind() != Type.Kind.PRIMITIVE && !paramType.name().equals((Object)DotNames.STRING) && !paramType.name().equals((Object)DotNames.MCP_CONNECTION) && !paramType.name().equals((Object)DotNames.MCP_LOG) && !paramType.name().equals((Object)DotNames.REQUEST_ID) && !paramType.name().equals((Object)DotNames.REQUEST_URI) && !paramType.name().equals((Object)DotNames.PROGRESS) && !paramType.name().equals((Object)DotNames.ROOTS) && !paramType.name().equals((Object)DotNames.SAMPLING) && !paramType.name().equals((Object)DotNames.CANCELLATION) && !paramType.name().equals((Object)DotNames.COMPLETE_CONTEXT) && !paramType.name().equals((Object)DotNames.RAW_MESSAGE) && !paramType.name().equals((Object)DotNames.META) && !paramType.name().equals((Object)DotNames.ELICITATION);
    }

    private static /* synthetic */ boolean lambda$validateToolMethod$13(org.jboss.jandex.Type argType, DefaultValueConverterBuildItem c) {
        return c.getArgumentType().equals((Object)argType);
    }
}

