/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.deployment;

import io.quarkiverse.mcp.server.runtime.Feature;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.builder.item.SimpleBuildItem;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public final class FeatureAnnotationsBuildItem
extends SimpleBuildItem {
    private final Map<DotName, Feature> annotationToFeature;

    FeatureAnnotationsBuildItem(Map<DotName, Feature> annotationToFeature) {
        this.annotationToFeature = annotationToFeature;
    }

    public Map<DotName, Feature> annotationToFeature() {
        return this.annotationToFeature;
    }

    public boolean isFeatureMethod(MethodInfo method) {
        if (!Modifier.isStatic(method.flags())) {
            for (DotName annotationName : this.annotationToFeature.keySet()) {
                if (!method.hasDeclaredAnnotation(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasFeatureMethod(BeanInfo bean) {
        ClassInfo beanClass = ((AnnotationTarget)bean.getTarget().get()).asClass();
        for (DotName annotationName : this.annotationToFeature.keySet()) {
            if (!beanClass.hasAnnotation(annotationName)) continue;
            return true;
        }
        return false;
    }

    public AnnotationInstance getFeatureAnnotation(MethodInfo method) {
        for (AnnotationInstance annotation : method.declaredAnnotations()) {
            if (!this.annotationToFeature.containsKey(annotation.name())) continue;
            return annotation;
        }
        return null;
    }

    public Feature getFeature(AnnotationInstance annotation) {
        Feature ret = this.annotationToFeature.get(annotation.name());
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("Not a feature annotation");
    }
}

