package io.quarkiverse.mcp.server.runtime;

import io.vertx.core.json.JsonObject;

public interface McpRequest {

    String serverName();

    Object json();

    McpConnectionBase connection();

    Sender sender();

    SecuritySupport securitySupport();

    ContextSupport contextSupport();

    default void messageReceived(JsonObject message) {
        if (connection().getTrafficLoggerTextLimit() > 0) {
            TrafficLogger.messageReceived(message, connection(), connection().getTrafficLoggerTextLimit());
        }
    }

    default void messageSent(JsonObject message) {
        if (connection().getTrafficLoggerTextLimit() > 0) {
            TrafficLogger.messageSent(message, connection(), connection().getTrafficLoggerTextLimit());
        }
    }

    void contextStart();

    void contextEnd();
}