/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.http.deployment;

import io.quarkiverse.mcp.server.deployment.ServerNameBuildItem;
import io.quarkiverse.mcp.server.http.deployment.McpServerEndpointsBuildItem;
import io.quarkiverse.mcp.server.http.runtime.HttpMcpServerRecorder;
import io.quarkiverse.mcp.server.http.runtime.McpServerEndpoints;
import io.quarkiverse.mcp.server.http.runtime.McpServerEndpointsLogger;
import io.quarkiverse.mcp.server.http.runtime.SseMcpMessageHandler;
import io.quarkiverse.mcp.server.http.runtime.StreamableHttpMcpMessageHandler;
import io.quarkiverse.mcp.server.http.runtime.config.McpHttpServerBuildTimeConfig;
import io.quarkiverse.mcp.server.http.runtime.config.McpHttpServersBuildTimeConfig;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeansRuntimeInitBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.vertx.http.deployment.BodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.spi.RouteBuildItem;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class HttpMcpServerProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem("mcp-server-http");
    }

    @BuildStep
    void addBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{SseMcpMessageHandler.class, StreamableHttpMcpMessageHandler.class, McpServerEndpointsLogger.class}).build());
    }

    @BuildStep
    void serverNames(McpHttpServersBuildTimeConfig config, BuildProducer<ServerNameBuildItem> serverNames) {
        for (String serverName : config.servers().keySet()) {
            serverNames.produce((BuildItem)new ServerNameBuildItem(serverName));
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=SyntheticBeansRuntimeInitBuildItem.class)
    @BuildStep
    void registerEndpoints(McpServerEndpointsBuildItem mcpServerEndpoints, HttpMcpServerRecorder recorder, BodyHandlerBuildItem bodyHandler, BuildProducer<RouteBuildItem> routes) {
        for (McpServerEndpoints.McpServerEndpoint endpoint : mcpServerEndpoints.getEndpoints()) {
            routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)endpoint.mcpPath).withRouteCustomizer(recorder.addBodyHandler(bodyHandler.getHandler())).withRequestHandler(recorder.createMcpEndpointHandler(endpoint.serverName)).build());
            routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)endpoint.ssePath).withRequestHandler(recorder.createSseEndpointHandler(endpoint.mcpPath, endpoint.serverName)).build());
            routes.produce((BuildItem)RouteBuildItem.newFrameworkRoute((String)(endpoint.mcpPath + "/messages/:id")).withRouteCustomizer(recorder.addBodyHandler(bodyHandler.getHandler())).withRequestHandler(recorder.createMessagesEndpointHandler(endpoint.serverName)).build());
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void registerMcpEndpointsBean(McpServerEndpointsBuildItem mcpServerEndpoints, HttpMcpServerRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeans) {
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(McpServerEndpoints.class).scope(Singleton.class)).createWith(recorder.createMcpServerEndpoints(mcpServerEndpoints.getEndpoints())).done());
    }

    @BuildStep
    McpServerEndpointsBuildItem collectMcpServerEndpoints(McpHttpServersBuildTimeConfig config, HttpRootPathBuildItem httpRootPath) {
        ArrayList<McpServerEndpoints.McpServerEndpoint> endpoints = new ArrayList<McpServerEndpoints.McpServerEndpoint>();
        HashSet<String> rootPaths = new HashSet<String>();
        for (Map.Entry e : config.servers().entrySet()) {
            String serverName = (String)e.getKey();
            String rootPath = ((McpHttpServerBuildTimeConfig)e.getValue()).http().rootPath();
            if (!rootPaths.add(rootPath)) {
                throw new IllegalStateException("Multiple server configurations define the same root path: " + rootPath);
            }
            String mcpPath = httpRootPath.relativePath(rootPath);
            String ssePath = mcpPath.endsWith("/") ? mcpPath + "sse" : mcpPath + "/sse";
            endpoints.add(new McpServerEndpoints.McpServerEndpoint(serverName, mcpPath, ssePath));
        }
        return new McpServerEndpointsBuildItem(endpoints);
    }
}

