/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.http.runtime;

import io.quarkiverse.mcp.server.http.runtime.McpServerEndpoints;
import io.quarkus.vertx.http.HttpServerStart;
import io.quarkus.vertx.http.HttpsServerStart;
import io.vertx.core.http.HttpServerOptions;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.event.ObservesAsync;
import java.util.List;
import org.jboss.logging.Logger;

@Dependent
public class McpServerEndpointsLogger {
    void onHttpServerStart(@ObservesAsync HttpServerStart start, McpServerEndpoints endpoints) {
        this.logEndpoints(endpoints.endpoints, start.options());
    }

    void onHttpsServerStart(@ObservesAsync HttpsServerStart start, McpServerEndpoints endpoints) {
        this.logEndpoints(endpoints.endpoints, start.options());
    }

    private void logEndpoints(List<McpServerEndpoints.McpServerEndpoint> endpoints, HttpServerOptions httpServerOptions) {
        Logger log = Logger.getLogger((String)"io.quarkiverse.mcp.server");
        String base = (httpServerOptions.isSsl() ? "https://" : "http://") + httpServerOptions.getHost() + ":" + httpServerOptions.getPort();
        for (McpServerEndpoints.McpServerEndpoint e : endpoints) {
            Object serverInfo = "";
            if (!"<default>".equals(e.serverName)) {
                serverInfo = " [" + e.serverName + "]";
            }
            log.infof("MCP%s HTTP transport endpoints [streamable: %s, SSE: %s]", serverInfo, (Object)(base + e.mcpPath), (Object)(base + e.ssePath));
        }
    }
}

