/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.http.runtime;

import io.quarkiverse.mcp.server.http.runtime.McpServerEndpoints;
import io.quarkiverse.mcp.server.http.runtime.SseMcpConnection;
import io.quarkiverse.mcp.server.http.runtime.SseMcpMessageHandler;
import io.quarkiverse.mcp.server.http.runtime.StreamableHttpMcpMessageHandler;
import io.quarkiverse.mcp.server.http.runtime.config.McpHttpServersBuildTimeConfig;
import io.quarkiverse.mcp.server.runtime.ConnectionManager;
import io.quarkiverse.mcp.server.runtime.McpConnectionBase;
import io.quarkiverse.mcp.server.runtime.config.McpServerRuntimeConfig;
import io.quarkiverse.mcp.server.runtime.config.McpServersRuntimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;

@Recorder
public class HttpMcpServerRecorder {
    private static final Logger LOG = Logger.getLogger(HttpMcpServerRecorder.class);
    static final String CONTEXT_KEY = "mcp.http.server-name";
    private final RuntimeValue<McpServersRuntimeConfig> config;
    private final McpHttpServersBuildTimeConfig sseConfig;

    public HttpMcpServerRecorder(RuntimeValue<McpServersRuntimeConfig> config, McpHttpServersBuildTimeConfig sseConfig) {
        this.config = config;
        this.sseConfig = sseConfig;
    }

    public Handler<RoutingContext> createMcpEndpointHandler(final String serverName) {
        ArcContainer container = Arc.container();
        final ConnectionManager connectionManager = (ConnectionManager)container.instance(ConnectionManager.class, new Annotation[0]).get();
        final StreamableHttpMcpMessageHandler handler = (StreamableHttpMcpMessageHandler)((Object)container.instance(StreamableHttpMcpMessageHandler.class, new Annotation[0]).get());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                ctx.put(HttpMcpServerRecorder.CONTEXT_KEY, (Object)serverName);
                HttpMethod method = ctx.request().method();
                if (HttpMethod.GET.equals((Object)method)) {
                    handler.openSseStream(ctx, connectionManager, serverName);
                } else if (HttpMethod.POST.equals((Object)method)) {
                    handler.handle(ctx);
                } else if (HttpMethod.DELETE.equals((Object)method)) {
                    handler.terminateSession(ctx);
                } else {
                    LOG.debugf("Invalid HTTP method %s [server: %s]", (Object)method, (Object)serverName);
                    ctx.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"GET, POST, DELETE");
                    ctx.fail(405);
                }
            }
        };
    }

    public Handler<RoutingContext> createSseEndpointHandler(final String mcpPath, final String serverName) {
        final McpServerRuntimeConfig serverConfig = (McpServerRuntimeConfig)((McpServersRuntimeConfig)this.config.getValue()).servers().get(serverName);
        ArcContainer container = Arc.container();
        final ConnectionManager connectionManager = (ConnectionManager)container.instance(ConnectionManager.class, new Annotation[0]).get();
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                MultiMap queryParams;
                if (HttpMethod.POST.equals((Object)ctx.request().method())) {
                    ctx.fail(405);
                    return;
                }
                ctx.put(HttpMcpServerRecorder.CONTEXT_KEY, (Object)serverName);
                HttpServerResponse response = ctx.response();
                response.setChunked(true);
                response.headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/event-stream");
                String id = ConnectionManager.connectionId();
                LOG.debugf("SSE connection initialized [%s]", (Object)id);
                SseMcpConnection connection = new SseMcpConnection(id, serverConfig, response);
                connectionManager.add((McpConnectionBase)connection);
                HttpMcpServerRecorder.setCloseHandler(ctx.request(), id, connectionManager);
                StringBuilder endpointPath = new StringBuilder(mcpPath);
                if (!mcpPath.endsWith("/")) {
                    endpointPath.append("/");
                }
                endpointPath.append("messages/").append(id);
                if (HttpMcpServerRecorder.this.sseConfig.servers().get(serverName).http().messageEndpoint().includeQueryParams() && !(queryParams = ctx.queryParams()).isEmpty()) {
                    endpointPath.append("?");
                    Iterator it = queryParams.iterator();
                    while (it.hasNext()) {
                        Map.Entry e = (Map.Entry)it.next();
                        endpointPath.append((String)e.getKey()).append("=").append(URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8));
                        if (!it.hasNext()) continue;
                        endpointPath.append("&");
                    }
                }
                String endpoint = endpointPath.toString();
                LOG.debugf("POST endpoint path: %s", (Object)endpoint);
                connection.sendEvent("endpoint", endpoint);
            }
        };
    }

    static void setCloseHandler(HttpServerRequest request, String connectionId, ConnectionManager connectionManager) {
        HttpMcpServerRecorder.setCloseHandler(request, () -> {
            if (connectionManager.remove(connectionId)) {
                LOG.debugf("Connection %s closed", (Object)connectionId);
            }
        }, "client should close the connection [%s] explicitly".formatted(connectionId));
    }

    static void setCloseHandler(HttpServerRequest request, final Runnable closeAction, String errorMessage) {
        HttpConnection connection = request.connection();
        if (connection instanceof ConnectionBase) {
            ConnectionBase base = (ConnectionBase)connection;
            try {
                MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(ConnectionBase.class, MethodHandles.lookup());
                VarHandle varHandle = lookup.findVarHandle(ConnectionBase.class, "closeHandler", Handler.class);
                final Handler closeHandler = varHandle.get(base);
                base.closeHandler((Handler)new Handler<Void>(){

                    public void handle(Void event) {
                        if (closeHandler != null) {
                            closeHandler.handle((Object)event);
                        }
                        closeAction.run();
                    }
                });
            }
            catch (Exception e) {
                LOG.warnf((Throwable)e, "Unable to set close handler - %s", (Object)errorMessage);
            }
        } else {
            LOG.warnf("Unable to set close handler - %s", (Object)errorMessage);
        }
    }

    public Consumer<Route> addBodyHandler(final Handler<RoutingContext> bodyHandler) {
        return new Consumer<Route>(){

            @Override
            public void accept(Route route) {
                route.handler(bodyHandler);
            }
        };
    }

    public Handler<RoutingContext> createMessagesEndpointHandler(final String serverName) {
        final SseMcpMessageHandler handler = (SseMcpMessageHandler)((Object)Arc.container().instance(SseMcpMessageHandler.class, new Annotation[0]).get());
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext ctx) {
                ctx.put(HttpMcpServerRecorder.CONTEXT_KEY, (Object)serverName);
                handler.handle(ctx);
            }
        };
    }

    public Function<SyntheticCreationalContext<McpServerEndpoints>, McpServerEndpoints> createMcpServerEndpoints(final List<McpServerEndpoints.McpServerEndpoint> endpoints) {
        return new Function<SyntheticCreationalContext<McpServerEndpoints>, McpServerEndpoints>(){

            @Override
            public McpServerEndpoints apply(SyntheticCreationalContext<McpServerEndpoints> t) {
                return new McpServerEndpoints(endpoints);
            }
        };
    }
}

