/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.http.runtime.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import io.smallrye.config.RelocateConfigSourceInterceptor;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.function.Function;
import org.jboss.logging.Logger;

public class McpHttpConfigBuilderCustomizer
implements SmallRyeConfigBuilderCustomizer {
    private static final Logger LOG = Logger.getLogger(McpHttpConfigBuilderCustomizer.class);
    static final String SSE_ROOT_PATH = "sse.root-path";
    static final String HTTP_ROOT_PATH = "http.root-path";
    static final String SSE_MESSAGE_ENDPOINT = "sse.message-endpoint.include-query-params";
    static final String HTTP_MESSAGE_ENDPOINT = "http.message-endpoint.include-query-params";

    public void configBuilder(SmallRyeConfigBuilder builder) {
        builder.withInterceptors(new ConfigSourceInterceptor[]{new FallbackInterceptor(), new RelocateInterceptor()});
    }

    static class FallbackInterceptor
    extends FallbackConfigSourceInterceptor {
        private static final long serialVersionUID = 1L;
        private static final Function<String, String> FALLBACK = name -> {
            if (name.startsWith("quarkus.mcp.server.")) {
                if (name.endsWith(McpHttpConfigBuilderCustomizer.HTTP_ROOT_PATH)) {
                    String fallback = name.substring(0, name.indexOf(McpHttpConfigBuilderCustomizer.HTTP_ROOT_PATH)) + McpHttpConfigBuilderCustomizer.SSE_ROOT_PATH;
                    LOG.debugf("Fallback %s to %s", name, (Object)fallback);
                    return fallback;
                }
                if (name.endsWith(McpHttpConfigBuilderCustomizer.HTTP_MESSAGE_ENDPOINT)) {
                    String fallback = name.substring(0, name.indexOf(McpHttpConfigBuilderCustomizer.HTTP_MESSAGE_ENDPOINT)) + McpHttpConfigBuilderCustomizer.SSE_MESSAGE_ENDPOINT;
                    LOG.debugf("Fallback %s to %s", name, (Object)fallback);
                    return fallback;
                }
            }
            return name;
        };

        public FallbackInterceptor() {
            super(FALLBACK);
        }
    }

    static class RelocateInterceptor
    extends RelocateConfigSourceInterceptor {
        private static final long serialVersionUID = 1L;
        private static final Function<String, String> RELOCATE = name -> {
            if (name.startsWith("quarkus.mcp.server.")) {
                if (name.endsWith(McpHttpConfigBuilderCustomizer.SSE_ROOT_PATH)) {
                    String relocate = name.substring(0, name.indexOf(McpHttpConfigBuilderCustomizer.SSE_ROOT_PATH)) + McpHttpConfigBuilderCustomizer.HTTP_ROOT_PATH;
                    LOG.debugf("Relocate %s to %s", name, (Object)relocate);
                    return relocate;
                }
                if (name.endsWith(McpHttpConfigBuilderCustomizer.SSE_MESSAGE_ENDPOINT)) {
                    String relocate = name.substring(0, name.indexOf(McpHttpConfigBuilderCustomizer.SSE_MESSAGE_ENDPOINT)) + McpHttpConfigBuilderCustomizer.HTTP_MESSAGE_ENDPOINT;
                    LOG.debugf("Relocate %s to %s", name, (Object)relocate);
                    return relocate;
                }
            }
            return name;
        };

        public RelocateInterceptor() {
            super(RELOCATE);
        }
    }
}

