/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.ClientCapability;
import io.quarkiverse.mcp.server.CompletionResponse;
import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.Icon;
import io.quarkiverse.mcp.server.Implementation;
import io.quarkiverse.mcp.server.McpMethod;
import io.quarkiverse.mcp.server.PromptResponse;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.test.McpSseTestClientImpl;
import io.quarkiverse.mcp.server.test.McpStreamableTestClientImpl;
import io.quarkiverse.mcp.server.test.McpWebSocketTestClientImpl;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class McpAssured {
    public static final String PING = "ping";
    public static final String TOOLS_LIST = "tools/list";
    public static final String TOOLS_CALL = "tools/call";
    public static final String PROMPTS_LIST = "prompts/list";
    public static final String PROMPTS_GET = "prompts/get";
    public static final String RESOURCES_LIST = "resources/list";
    public static final String RESOURCES_TEMPLATES_LIST = "resources/templates/list";
    public static final String RESOURCES_READ = "resources/read";
    public static final String COMPLETION_COMPLETE = "completion/complete";
    public static URI baseUri;

    public static McpSseTestClient.Builder newSseClient() {
        return new McpSseTestClientImpl.BuilderImpl();
    }

    public static McpSseTestClient newConnectedSseClient() {
        return (McpSseTestClient)McpAssured.newSseClient().build().connect();
    }

    public static McpStreamableTestClient.Builder newStreamableClient() {
        return new McpStreamableTestClientImpl.BuilderImpl();
    }

    public static McpStreamableTestClient newConnectedStreamableClient() {
        return (McpStreamableTestClient)McpAssured.newStreamableClient().build().connect();
    }

    public static McpWebSocketTestClient.Builder newWebSocketClient() {
        return new McpWebSocketTestClientImpl.BuilderImpl();
    }

    public static McpWebSocketTestClient newConnectedWebSocketClient() {
        return (McpWebSocketTestClient)McpAssured.newWebSocketClient().build().connect();
    }

    public static interface McpSseTestClient
    extends McpTestClient<McpSseAssert, McpSseTestClient> {
        public URI sseEndpoint();

        public URI messageEndpoint();

        public static interface Builder
        extends McpTestClient.Builder<Builder> {
            public Builder setBasicAuth(String var1, String var2);

            public Builder setAdditionalHeaders(Function<JsonObject, MultiMap> var1);

            public Builder setBaseUri(URI var1);

            public Builder setSsePath(String var1);

            public Builder setExpectSseConnectionFailure();

            public McpSseTestClient build();
        }
    }

    public static interface McpTestClient<ASSERT extends McpAssert<ASSERT>, CLIENT extends McpTestClient<ASSERT, CLIENT>> {
        public boolean isConnected();

        public InitResult initResult();

        default public CLIENT connect() {
            return this.connect(null);
        }

        public CLIENT connect(Consumer<InitResult> var1);

        public void disconnect();

        public ASSERT when();

        public ASSERT whenBatch();

        public JsonObject newMessage(String var1);

        default public JsonObject newRequest(McpMethod method) {
            return this.newRequest(method.jsonRpcName());
        }

        public JsonObject newRequest(String var1);

        public JsonObject newInitMessage();

        public void sendAndForget(JsonObject var1);

        public Snapshot snapshot();

        public Snapshot waitForNotifications(int var1);

        public Snapshot waitForRequests(int var1);

        public JsonObject waitForResponse(JsonObject var1);

        public static interface Builder<BUILDER extends Builder<BUILDER>> {
            public BUILDER setName(String var1);

            public BUILDER setVersion(String var1);

            public BUILDER setProtocolVersion(String var1);

            public BUILDER setTitle(String var1);

            public BUILDER setDescription(String var1);

            public BUILDER setIcons(Icon ... var1);

            public BUILDER setWebsiteUrl(String var1);

            public BUILDER setClientCapabilities(ClientCapability ... var1);

            public BUILDER setAutoPong(boolean var1);
        }
    }

    public static interface McpStreamableTestClient
    extends McpTestClient<McpStreamableAssert, McpStreamableTestClient> {
        public URI mcpEndpoint();

        public String mcpSessionId();

        public void terminateSession();

        public static interface Builder
        extends McpTestClient.Builder<Builder> {
            public Builder setBasicAuth(String var1, String var2);

            public Builder setAdditionalHeaders(Function<JsonObject, MultiMap> var1);

            public Builder setBaseUri(URI var1);

            public Builder setMcpPath(String var1);

            public Builder setOpenSubsidiarySse(boolean var1);

            public Builder setExpectConnectFailure();

            public McpStreamableTestClient build();
        }
    }

    public static interface McpWebSocketTestClient
    extends McpTestClient<McpWebSocketAssert, McpWebSocketTestClient> {
        public URI endpointUri();

        public static interface Builder
        extends McpTestClient.Builder<Builder> {
            public Builder setBasicAuth(String var1, String var2);

            public Builder setBaseUri(URI var1);

            public Builder setEndpointPath(String var1);

            public McpWebSocketTestClient build();
        }
    }

    public record McpError(int code, String message) {
    }

    public record HttpResponse(int statusCode, MultiMap headers, String body) {
    }

    public record Snapshot(List<JsonObject> requests, List<JsonObject> responses, List<JsonObject> notifications) {
    }

    public record ToolAnnotations(String title, boolean readOnlyHint, boolean destructiveHint, boolean idempotentHint, boolean openWorldHint) {
    }

    public record PromptArgument(String name, String title, String description, boolean required) {
    }

    public record ResourceTemplateInfo(String uriTemplate, String mimeType, String name, String title, String description, Content.Annotations annotations, JsonObject meta, JsonArray icons) {
    }

    public record ResourceInfo(String uri, String mimeType, String name, String title, String description, Integer size, Content.Annotations annotations, JsonObject meta, JsonArray icons) {
    }

    public record PromptInfo(String name, String title, String description, List<PromptArgument> arguments, JsonObject meta, JsonArray icons) {
    }

    public record ToolInfo(String name, String title, String description, JsonObject inputSchema, JsonObject outputSchema, Optional<ToolAnnotations> annotations, JsonObject meta, JsonArray icons) {
    }

    public record ResourcesTemplatesPage(List<ResourceTemplateInfo> templates, String nextCursor) {
        public int size() {
            return this.templates().size();
        }

        public ResourceTemplateInfo findByUriTemplate(String uriTemplate) {
            return this.templates.stream().filter(t -> t.uriTemplate().equals(uriTemplate)).findFirst().orElseThrow();
        }
    }

    public record ResourcesPage(List<ResourceInfo> resources, String nextCursor) {
        public int size() {
            return this.resources().size();
        }

        public ResourceInfo findByUri(String uri) {
            return this.resources.stream().filter(r -> r.uri().equals(uri)).findFirst().orElseThrow();
        }
    }

    public record PromptsPage(List<PromptInfo> prompts, String nextCursor) {
        public int size() {
            return this.prompts().size();
        }

        public PromptInfo findByName(String name) {
            return this.prompts.stream().filter(p -> p.name().equals(name)).findFirst().orElseThrow();
        }
    }

    public record ToolsPage(List<ToolInfo> tools, String nextCursor) {
        public int size() {
            return this.tools().size();
        }

        public ToolInfo findByName(String name) {
            return this.tools.stream().filter(t -> t.name().equals(name)).findFirst().orElseThrow();
        }
    }

    public record ServerCapability(String name, Map<String, Object> properties) {
    }

    public record InitResult(String protocolVersion, String serverName, String serverTitle, String serverVersion, List<ServerCapability> capabilities, String instructions, Implementation implementation) {
    }

    public static interface McpStreamableAssert
    extends McpAssert<McpStreamableAssert> {
        public McpStreamableAssert addHeaders(MultiMap var1);

        public McpStreamableAssert basicAuth(String var1, String var2);

        public McpStreamableAssert noBasicAuth();
    }

    public static interface McpWebSocketAssert
    extends McpAssert<McpWebSocketAssert> {
    }

    public static interface McpSseAssert
    extends McpAssert<McpSseAssert> {
        public McpSseAssert addHeader(String var1, String var2);

        public McpSseAssert addHeaders(MultiMap var1);

        public McpSseAssert validateHttpResponse(Consumer<HttpResponse> var1);

        public McpSseAssert basicAuth(String var1, String var2);

        public McpSseAssert noBasicAuth();
    }

    public static interface McpAssert<ASSERT extends McpAssert<ASSERT>> {
        default public ASSERT pingPong() {
            return this.ping().withPongAssert().send();
        }

        @CheckReturnValue
        public PingMessage<ASSERT> ping();

        @CheckReturnValue
        default public ASSERT toolsList(Consumer<ToolsPage> assertFunction) {
            return this.toolsList().withAssert(assertFunction).send();
        }

        @CheckReturnValue
        public ToolsListMessage<ASSERT> toolsList();

        @CheckReturnValue
        default public ASSERT toolsCall(String toolName, Consumer<ToolResponse> assertFunction) {
            return this.toolsCall(toolName).withAssert(assertFunction).send();
        }

        @CheckReturnValue
        default public ASSERT toolsCall(String toolName, Map<String, Object> args, Consumer<ToolResponse> assertFunction) {
            return this.toolsCall(toolName).withArguments(args).withAssert(assertFunction).send();
        }

        @CheckReturnValue
        public ToolsCallMessage<ASSERT> toolsCall(String var1);

        default public ASSERT promptsList(Consumer<PromptsPage> assertFunction) {
            return this.promptsList().withAssert(assertFunction).send();
        }

        public PromptsListMessage<ASSERT> promptsList();

        default public ASSERT promptsGet(String promptName, Consumer<PromptResponse> assertFunction) {
            return this.promptsGet(promptName).withAssert(assertFunction).send();
        }

        default public ASSERT promptsGet(String promptName, Map<String, String> args, Consumer<PromptResponse> assertFunction) {
            return this.promptsGet(promptName).withArguments(args).withAssert(assertFunction).send();
        }

        default public ASSERT resourcesRead(String uri, Consumer<ResourceResponse> assertFunction) {
            return this.resourcesRead(uri).withAssert(assertFunction).send();
        }

        public ResourcesReadMessage<ASSERT> resourcesRead(String var1);

        default public ASSERT resourcesList(Consumer<ResourcesPage> assertFunction) {
            return this.resourcesList().withAssert(assertFunction).send();
        }

        public ResourcesListMessage<ASSERT> resourcesList();

        default public ASSERT resourcesTemplatesList(Consumer<ResourcesTemplatesPage> assertFunction) {
            return this.resourcesTemplatesList().withAssert(assertFunction).send();
        }

        public ResourcesTemplatesListMessage<ASSERT> resourcesTemplatesList();

        public ResourceTemplateCompleteMessage<ASSERT> resourceTemplateComplete(String var1);

        default public ASSERT resourceTemplateComplete(String uriTemplate, String argumentName, String argumentValue, Consumer<CompletionResponse> assertFunction) {
            return this.resourceTemplateComplete(uriTemplate).withArgument(argumentName, argumentValue).withAssert(assertFunction).send();
        }

        public PromptsGetMessage<ASSERT> promptsGet(String var1);

        public PromptsCompleteMessage<ASSERT> promptComplete(String var1);

        default public ASSERT promptComplete(String promptName, String argumentName, String argumentValue, Consumer<CompletionResponse> assertFunction) {
            return this.promptComplete(promptName).withArgument(argumentName, argumentValue).withAssert(assertFunction).send();
        }

        @CheckReturnValue
        public GenericMessage<ASSERT> message(JsonObject var1);

        public Snapshot thenAssertResults();

        public static interface PingMessage<ASSERT extends McpAssert<ASSERT>> {
            public PingMessage<ASSERT> withPongAssert();

            public PingMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface ToolsListMessage<ASSERT extends McpAssert<ASSERT>> {
            public ToolsListMessage<ASSERT> withCursor(String var1);

            public ToolsListMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public ToolsListMessage<ASSERT> withAssert(Consumer<ToolsPage> var1);

            public ToolsListMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface ToolsCallMessage<ASSERT extends McpAssert<ASSERT>> {
            public ToolsCallMessage<ASSERT> withArguments(Map<String, Object> var1);

            public ToolsCallMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public ToolsCallMessage<ASSERT> withAssert(Consumer<ToolResponse> var1);

            public ToolsCallMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface PromptsListMessage<ASSERT extends McpAssert<ASSERT>> {
            public PromptsListMessage<ASSERT> withCursor(String var1);

            public PromptsListMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public PromptsListMessage<ASSERT> withAssert(Consumer<PromptsPage> var1);

            public PromptsListMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface PromptsGetMessage<ASSERT extends McpAssert<ASSERT>> {
            public PromptsGetMessage<ASSERT> withArguments(Map<String, String> var1);

            public PromptsGetMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public PromptsGetMessage<ASSERT> withAssert(Consumer<PromptResponse> var1);

            public PromptsGetMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface ResourcesReadMessage<ASSERT extends McpAssert<ASSERT>> {
            public ResourcesReadMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public ResourcesReadMessage<ASSERT> withAssert(Consumer<ResourceResponse> var1);

            public ResourcesReadMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface ResourcesListMessage<ASSERT extends McpAssert<ASSERT>> {
            public ResourcesListMessage<ASSERT> withCursor(String var1);

            public ResourcesListMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public ResourcesListMessage<ASSERT> withAssert(Consumer<ResourcesPage> var1);

            public ResourcesListMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface ResourcesTemplatesListMessage<ASSERT extends McpAssert<ASSERT>> {
            public ResourcesTemplatesListMessage<ASSERT> withCursor(String var1);

            public ResourcesTemplatesListMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public ResourcesTemplatesListMessage<ASSERT> withAssert(Consumer<ResourcesTemplatesPage> var1);

            public ResourcesTemplatesListMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface ResourceTemplateCompleteMessage<ASSERT extends McpAssert<ASSERT>> {
            public ResourceTemplateCompleteMessage<ASSERT> withArgument(String var1, String var2);

            public ResourceTemplateCompleteMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public ResourceTemplateCompleteMessage<ASSERT> withContext(Map<String, String> var1);

            public ResourceTemplateCompleteMessage<ASSERT> withAssert(Consumer<CompletionResponse> var1);

            public ResourceTemplateCompleteMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface PromptsCompleteMessage<ASSERT extends McpAssert<ASSERT>> {
            public PromptsCompleteMessage<ASSERT> withArgument(String var1, String var2);

            public PromptsCompleteMessage<ASSERT> withMetadata(Map<String, Object> var1);

            public PromptsCompleteMessage<ASSERT> withContext(Map<String, String> var1);

            public PromptsCompleteMessage<ASSERT> withAssert(Consumer<CompletionResponse> var1);

            public PromptsCompleteMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }

        public static interface GenericMessage<ASSERT extends McpAssert<ASSERT>> {
            public GenericMessage<ASSERT> withAssert(Consumer<JsonObject> var1);

            public GenericMessage<ASSERT> withErrorAssert(Consumer<McpError> var1);

            public ASSERT send();
        }
    }
}

