/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.test.McpAssured;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.awaitility.Awaitility;

final class McpClientState {
    final AtomicInteger requestIdGenerator = new AtomicInteger();
    final List<JsonObject> requests = new CopyOnWriteArrayList<JsonObject>();
    final List<JsonObject> responses = new CopyOnWriteArrayList<JsonObject>();
    final List<JsonObject> notifications = new CopyOnWriteArrayList<JsonObject>();

    McpClientState() {
    }

    public int nextRequestId() {
        return this.requestIdGenerator.incrementAndGet();
    }

    public JsonObject waitForLastResponse() {
        int lastId = this.requestIdGenerator.get();
        if (lastId == 0) {
            return null;
        }
        Awaitility.await().until(() -> this.responses.stream().anyMatch(r -> r.getInteger("id") == lastId));
        return this.responses.stream().filter(r -> r.getInteger("id") == lastId).findFirst().orElseThrow();
    }

    public List<JsonObject> waitForNotifications(int count) {
        Awaitility.await().until(() -> this.notifications.size() >= count);
        return this.notifications;
    }

    public List<JsonObject> waitForRequests(int count) {
        Awaitility.await().until(() -> this.requests.size() >= count);
        return this.requests;
    }

    public List<JsonObject> waitForResponses(int count) {
        Awaitility.await().until(() -> this.responses.size() >= count);
        return this.responses;
    }

    public JsonObject waitForResponse(JsonObject request) {
        int id = request.getInteger("id");
        Awaitility.await().until(() -> this.getResponse(id) != null);
        return this.getResponse(id);
    }

    public JsonObject getResponse(int id) {
        for (JsonObject r : this.responses) {
            if (r.getInteger("id") != id) continue;
            return r;
        }
        return null;
    }

    public List<JsonObject> getRequests() {
        return List.copyOf(this.requests);
    }

    public List<JsonObject> getResponses() {
        return List.copyOf(this.responses);
    }

    public List<JsonObject> getNotifications() {
        return List.copyOf(this.notifications);
    }

    public void clearRequests() {
        this.requests.clear();
    }

    public McpAssured.Snapshot toSnapshot() {
        return new McpAssured.Snapshot(this.getRequests(), this.getResponses(), this.getNotifications());
    }
}

