/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.sse.client.SseClient;
import io.quarkiverse.mcp.server.test.McpClientState;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.awaitility.Awaitility;

class McpSseClient
extends SseClient {
    final McpClientState state;
    final List<SseClient.SseEvent> allEvents;
    final AtomicReference<Consumer<JsonObject>> requestConsumer = new AtomicReference();

    public McpSseClient(URI uri) {
        super(uri);
        this.allEvents = new CopyOnWriteArrayList<SseClient.SseEvent>();
        this.state = new McpClientState();
    }

    public void setRequestConsumer(Consumer<JsonObject> value) {
        this.requestConsumer.set(value);
    }

    public SseClient.SseEvent waitForFirstEvent() {
        Awaitility.await().until(() -> !this.allEvents.isEmpty());
        return this.allEvents.get(0);
    }

    protected void process(SseClient.SseEvent event) {
        this.allEvents.add(event);
        if ("message".equals(event.name())) {
            JsonObject json = new JsonObject(event.data());
            if (json.containsKey("id")) {
                if (json.containsKey("result") || json.containsKey("error")) {
                    this.state.responses.add(json);
                } else {
                    this.state.requests.add(json);
                    Consumer<JsonObject> c = this.requestConsumer.get();
                    if (c != null) {
                        c.accept(json);
                    }
                }
            } else {
                this.state.notifications.add(json);
            }
        }
    }
}

