/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.Implementation;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.sse.client.SseClient;
import io.quarkiverse.mcp.server.test.McpAssured;
import io.quarkiverse.mcp.server.test.McpClientState;
import io.quarkiverse.mcp.server.test.McpSseClient;
import io.quarkiverse.mcp.server.test.McpTestClientBase;
import io.quarkiverse.mcp.server.test.McpTestClientBuilder;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

class McpSseTestClientImpl
extends McpTestClientBase<McpAssured.McpSseAssert, McpAssured.McpSseTestClient>
implements McpAssured.McpSseTestClient {
    private static final Logger LOG = Logger.getLogger(McpSseTestClientImpl.class);
    private final URI sseEndpoint;
    private final HttpClient httpClient;
    private final boolean expectSseConnectionFailure;
    private volatile McpSseClient client;
    private volatile URI messageEndpoint;

    McpSseTestClientImpl(BuilderImpl builder) {
        super(builder.name, builder.version, builder.protocolVersion, builder.clientCapabilities, builder.additionalHeaders, builder.autoPong, builder.basicAuth, builder.title, builder.description, builder.websiteUrl, builder.icons);
        this.sseEndpoint = McpSseTestClientImpl.createEndpointUri(builder.baseUri, builder.ssePath);
        this.expectSseConnectionFailure = builder.expectSseConnectionFailure;
        this.httpClient = HttpClient.newHttpClient();
        LOG.debugf("McpSseTestClient created with SSE endpoint: %s", (Object)this.sseEndpoint);
    }

    @Override
    public URI sseEndpoint() {
        return this.sseEndpoint;
    }

    @Override
    public URI messageEndpoint() {
        return this.messageEndpoint;
    }

    @Override
    public McpAssured.McpSseTestClient connect(Consumer<McpAssured.InitResult> assertFunction) {
        URI endpoint;
        URI uriBase;
        this.client = new McpSseClient(this.sseEndpoint);
        if (this.autoPong) {
            this.client.setRequestConsumer(m -> {
                String method = m.getString("method");
                if (method != null && "ping".equals(method)) {
                    JsonObject pong = Messages.newResult((Object)m.getValue("id"), (Object)new JsonObject());
                    this.sendAndForget(pong);
                }
            });
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.clientBasicAuth != null) {
            headers.put("Authorization", McpTestClientBase.getBasicAuthenticationHeader(this.clientBasicAuth.username(), this.clientBasicAuth.password()));
        }
        CompletableFuture cf = this.client.connect(headers);
        if (this.expectSseConnectionFailure) {
            try {
                HttpResponse response = (HttpResponse)cf.get(5L, TimeUnit.SECONDS);
                Assertions.assertNotEquals((int)200, (int)response.statusCode());
                return this;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted");
            }
            catch (ExecutionException | TimeoutException e) {
                throw new IllegalStateException(e);
            }
        }
        SseClient.SseEvent event = this.client.waitForFirstEvent();
        try {
            uriBase = new URI(this.sseEndpoint.getScheme(), null, this.sseEndpoint.getHost(), this.sseEndpoint.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        this.messageEndpoint = endpoint = URI.create(uriBase.toString() + event.data().strip());
        LOG.infof("Message endpoint received: %s", (Object)endpoint);
        JsonObject initMessage = this.newInitMessage();
        McpAssured.HttpResponse response = this.sendSync(initMessage, (MultiMap)this.additionalHeaders.apply(initMessage), this.clientBasicAuth);
        Assertions.assertEquals((int)200, (int)response.statusCode(), (String)("Invalid HTTP response status: " + response.statusCode()));
        JsonObject initResponse = this.client.state.waitForResponse(initMessage);
        JsonObject initResult = McpSseTestClientImpl.assertResultResponse(initMessage, initResponse);
        Assertions.assertNotNull((Object)initResult);
        JsonObject serverInfo = initResult.getJsonObject("serverInfo");
        JsonObject initCapabilities = initResult.getJsonObject("capabilities");
        ArrayList<McpAssured.ServerCapability> capabilities = new ArrayList<McpAssured.ServerCapability>();
        if (initCapabilities != null) {
            for (String capability : initCapabilities.fieldNames()) {
                capabilities.add(new McpAssured.ServerCapability(capability, initCapabilities.getJsonObject(capability).getMap()));
            }
        }
        Implementation implementation = Messages.decodeImplementation((JsonObject)serverInfo);
        McpAssured.InitResult r = new McpAssured.InitResult(initResult.getString("protocolVersion"), implementation.name(), implementation.title(), implementation.version(), capabilities, initResult.getString("instructions"), implementation);
        if (assertFunction != null) {
            assertFunction.accept(r);
        }
        this.initResult = r;
        JsonObject nofitication = this.newMessage("notifications/initialized");
        response = this.sendSync(nofitication, (MultiMap)this.additionalHeaders.apply(nofitication), this.clientBasicAuth);
        Assertions.assertEquals((int)200, (int)response.statusCode());
        this.connected.set(true);
        return this;
    }

    @Override
    public void disconnect() {
        JsonObject message = this.newMessage("q/close");
        McpAssured.HttpResponse response = this.sendSync(message, (MultiMap)this.additionalHeaders.apply(message), this.clientBasicAuth);
        Assertions.assertEquals((int)200, (int)response.statusCode());
        this.messageEndpoint = null;
        this.connected.set(false);
        this.client = null;
    }

    @Override
    public McpAssured.McpSseAssert when() {
        if (!this.isConnected()) {
            throw McpSseTestClientImpl.notConnected();
        }
        return new McpSseAssertImpl();
    }

    @Override
    public McpAssured.McpSseAssert whenBatch() {
        if (!this.isConnected()) {
            throw McpSseTestClientImpl.notConnected();
        }
        return new McpSseAssertBatch();
    }

    @Override
    protected McpClientState clientState() {
        return this.client.state;
    }

    @Override
    public void sendAndForget(JsonObject message) {
        this.sendAsync(message.encode(), (MultiMap)this.additionalHeaders.apply(message), this.clientBasicAuth);
    }

    private McpAssured.HttpResponse sendSync(JsonObject message, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        return this.sendSync(message.encode(), additionalHeaders, basicAuth);
    }

    private McpAssured.HttpResponse sendSync(JsonArray batch, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        return this.sendSync(batch.encode(), additionalHeaders, basicAuth);
    }

    private CompletableFuture<HttpResponse<String>> sendAsync(String data, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        if (this.messageEndpoint == null) {
            throw new IllegalStateException("Message endpoint not ready");
        }
        return this.httpClient.sendAsync(this.buildRequest(data, additionalHeaders, basicAuth), HttpResponse.BodyHandlers.ofString());
    }

    private McpAssured.HttpResponse sendSync(String data, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        if (this.messageEndpoint == null) {
            throw new IllegalStateException("Message endpoint not ready");
        }
        try {
            HttpResponse<String> r = this.httpClient.send(this.buildRequest(data, additionalHeaders, basicAuth), HttpResponse.BodyHandlers.ofString());
            MultiMap responseHeaders = MultiMap.caseInsensitiveMultiMap();
            for (Map.Entry<String, List<String>> e : r.headers().map().entrySet()) {
                for (String val : e.getValue()) {
                    responseHeaders.add(e.getKey(), val);
                }
            }
            return new McpAssured.HttpResponse(r.statusCode(), responseHeaders, r.body());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private HttpRequest buildRequest(String data, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.messageEndpoint).version(HttpClient.Version.HTTP_1_1).header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(data));
        additionalHeaders.forEach(builder::header);
        if (basicAuth != null && !basicAuth.isEmpty()) {
            builder.header("Authorization", McpTestClientBase.getBasicAuthenticationHeader(basicAuth.username(), basicAuth.password()));
        }
        return builder.build();
    }

    static class BuilderImpl
    extends McpTestClientBuilder<McpAssured.McpSseTestClient.Builder>
    implements McpAssured.McpSseTestClient.Builder {
        private String ssePath = "/mcp/sse";
        private URI baseUri = McpAssured.baseUri;
        private Function<JsonObject, MultiMap> additionalHeaders = m -> MultiMap.caseInsensitiveMultiMap();
        private McpTestClientBase.BasicAuth basicAuth;
        private boolean expectSseConnectionFailure;

        BuilderImpl() {
        }

        @Override
        public McpAssured.McpSseTestClient.Builder setBaseUri(URI baseUri) {
            if (baseUri == null) {
                throw McpTestClientBase.mustNotBeNull("testUri");
            }
            this.baseUri = baseUri;
            return this;
        }

        @Override
        public McpAssured.McpSseTestClient.Builder setSsePath(String ssePath) {
            if (ssePath == null) {
                throw McpTestClientBase.mustNotBeNull("ssePath");
            }
            this.ssePath = ssePath;
            return this;
        }

        @Override
        public McpAssured.McpSseTestClient.Builder setAdditionalHeaders(Function<JsonObject, MultiMap> additionalHeaders) {
            if (additionalHeaders == null) {
                throw McpTestClientBase.mustNotBeNull("additionalHeaders");
            }
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        @Override
        public McpAssured.McpSseTestClient.Builder setBasicAuth(String username, String password) {
            if (username == null) {
                throw McpTestClientBase.mustNotBeNull("username");
            }
            if (password == null) {
                throw McpTestClientBase.mustNotBeNull("password");
            }
            this.basicAuth = new McpTestClientBase.BasicAuth(username, password);
            return this;
        }

        @Override
        public McpAssured.McpSseTestClient.Builder setExpectSseConnectionFailure() {
            this.expectSseConnectionFailure = true;
            return this;
        }

        @Override
        public McpAssured.McpSseTestClient build() {
            if (this.baseUri == null) {
                throw new IllegalArgumentException("Base URI must be set");
            }
            return new McpSseTestClientImpl(this);
        }
    }

    class McpSseAssertImpl
    extends McpTestClientBase.McpAssertBase
    implements McpAssured.McpSseAssert {
        static final Consumer<McpAssured.HttpResponse> DEFAULT_HTTP_RESPONSE_VALIDATOR = httpResponse -> Assertions.assertEquals((int)200, (int)httpResponse.statusCode());
        protected final AtomicReference<Consumer<McpAssured.HttpResponse>> httpResponseValidator;
        protected final AtomicReference<MultiMap> additionalHeaders = new AtomicReference<MultiMap>(MultiMap.caseInsensitiveMultiMap());
        protected final AtomicReference<McpTestClientBase.BasicAuth> basicAuth = new AtomicReference();

        McpSseAssertImpl() {
            this.httpResponseValidator = new AtomicReference<Consumer<McpAssured.HttpResponse>>(DEFAULT_HTTP_RESPONSE_VALIDATOR);
        }

        @Override
        public McpAssured.McpSseAssert addHeader(String name, String value) {
            this.additionalHeaders.get().add(name, value);
            return this;
        }

        @Override
        public McpAssured.McpSseAssert addHeaders(MultiMap additionalHeaders) {
            this.additionalHeaders.set(additionalHeaders);
            return this;
        }

        @Override
        public McpAssured.McpSseAssert validateHttpResponse(Consumer<McpAssured.HttpResponse> validator) {
            this.httpResponseValidator.set(validator);
            return this;
        }

        @Override
        public McpAssured.McpSseAssert basicAuth(String username, String password) {
            this.basicAuth.set(new McpTestClientBase.BasicAuth(username, password));
            return this;
        }

        @Override
        public McpAssured.McpSseAssert noBasicAuth() {
            this.basicAuth.set(new McpTestClientBase.BasicAuth(null, null));
            return this;
        }

        @Override
        protected void doSend(JsonObject message) {
            McpTestClientBase.BasicAuth basicAuth = this.basicAuth.get();
            if (basicAuth == null) {
                basicAuth = McpSseTestClientImpl.this.clientBasicAuth;
            }
            McpAssured.HttpResponse response = McpSseTestClientImpl.this.sendSync(message, this.additionalHeaders(message), basicAuth);
            Consumer<McpAssured.HttpResponse> validator = this.httpResponseValidator.get();
            if (validator != null) {
                validator.accept(response);
            }
        }

        protected McpAssured.McpSseAssert self() {
            return this;
        }

        protected MultiMap additionalHeaders(JsonObject message) {
            MultiMap headers = (MultiMap)McpSseTestClientImpl.this.additionalHeaders.apply(message);
            MultiMap additionalHeaders = this.additionalHeaders.get();
            if (additionalHeaders != null) {
                headers.addAll(additionalHeaders);
            }
            return headers;
        }
    }

    class McpSseAssertBatch
    extends McpSseAssertImpl {
        private final List<JsonObject> requests = new ArrayList<JsonObject>();

        McpSseAssertBatch() {
        }

        @Override
        protected void doSend(JsonObject message) {
            this.requests.add(message);
        }

        @Override
        public McpAssured.Snapshot thenAssertResults() {
            McpTestClientBase.BasicAuth basicAuth;
            JsonArray batch = new JsonArray();
            this.requests.forEach(arg_0 -> ((JsonArray)batch).add(arg_0));
            MultiMap headers = MultiMap.caseInsensitiveMultiMap();
            for (JsonObject request : this.requests) {
                headers.addAll((MultiMap)McpSseTestClientImpl.this.additionalHeaders.apply(request));
            }
            MultiMap additionalHeaders = (MultiMap)this.additionalHeaders.get();
            if (additionalHeaders != null) {
                headers.addAll(additionalHeaders);
            }
            if ((basicAuth = (McpTestClientBase.BasicAuth)this.basicAuth.get()) == null) {
                basicAuth = McpSseTestClientImpl.this.clientBasicAuth;
            }
            McpAssured.HttpResponse response = McpSseTestClientImpl.this.sendSync(batch, headers, basicAuth);
            Consumer validator = (Consumer)this.httpResponseValidator.get();
            if (validator != null) {
                validator.accept(response);
            }
            return super.thenAssertResults();
        }
    }
}

