/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.sse.client.SseClient;
import io.quarkiverse.mcp.server.test.McpClientState;
import io.quarkiverse.mcp.server.test.McpStremableRequest;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

class McpStreamableClient
extends SseClient {
    final HttpClient httpClient;
    final URI mcpEndpoint;
    final McpClientState state;
    final AtomicReference<Consumer<JsonObject>> requestConsumer = new AtomicReference();

    McpStreamableClient(URI mcpEndpoint) {
        super(mcpEndpoint);
        this.httpClient = HttpClient.newHttpClient();
        this.mcpEndpoint = mcpEndpoint;
        this.state = new McpClientState();
    }

    public void setRequestConsumer(Consumer<JsonObject> value) {
        this.requestConsumer.set(value);
    }

    HttpResponse<String> sendSync(String body, MultiMap headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.mcpEndpoint).version(HttpClient.Version.HTTP_1_1).header("Accept", "text/event-stream").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(body));
        headers.forEach(builder::header);
        return this.doSend(builder.build());
    }

    HttpResponse<String> sendTerminate(MultiMap headers) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(this.mcpEndpoint).version(HttpClient.Version.HTTP_1_1).header("Accept", "text/event-stream").header("Accept", "application/json").DELETE();
        headers.forEach(builder::header);
        return this.doSend(builder.build());
    }

    private HttpResponse<String> doSend(HttpRequest request) {
        try {
            return this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void send(String body, MultiMap headers) {
        McpStremableRequest request = new McpStremableRequest(this.httpClient, this.mcpEndpoint, headers, this.state.responses::add, this.state.notifications::add, this.state.requests::add);
        request.send(body);
    }

    CompletableFuture<HttpResponse<Void>> connectSubsidiarySse(MultiMap headers) {
        return this.connect(this.httpClient, headers);
    }

    protected void process(SseClient.SseEvent event) {
        if ("message".equals(event.name())) {
            JsonObject json = new JsonObject(event.data());
            if (json.containsKey("id")) {
                if (json.containsKey("result") || json.containsKey("error")) {
                    this.state.responses.add(json);
                } else {
                    this.state.requests.add(json);
                }
            } else {
                this.state.notifications.add(json);
            }
        }
    }
}

