/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.Implementation;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.test.McpAssured;
import io.quarkiverse.mcp.server.test.McpClientState;
import io.quarkiverse.mcp.server.test.McpStreamableClient;
import io.quarkiverse.mcp.server.test.McpTestClientBase;
import io.quarkiverse.mcp.server.test.McpTestClientBuilder;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

class McpStreamableTestClientImpl
extends McpTestClientBase<McpAssured.McpStreamableAssert, McpAssured.McpStreamableTestClient>
implements McpAssured.McpStreamableTestClient {
    private static final Logger LOG = Logger.getLogger(McpStreamableTestClientImpl.class);
    private final URI mcpEndpoint;
    private final boolean openSubsidiarySse;
    private final boolean expectConnectFailure;
    private volatile McpStreamableClient client;
    private volatile String mcpSessionId;

    private McpStreamableTestClientImpl(BuilderImpl builder) {
        super(builder.name, builder.version, builder.protocolVersion, builder.clientCapabilities, builder.additionalHeaders, builder.autoPong, builder.basicAuth, builder.title, builder.description, builder.websiteUrl, builder.icons);
        this.mcpEndpoint = McpStreamableTestClientImpl.createEndpointUri(builder.baseUri, builder.mcpPath);
        this.client = new McpStreamableClient(this.mcpEndpoint);
        this.openSubsidiarySse = builder.openSubsidiarySse;
        this.expectConnectFailure = builder.expectConnectFailure;
    }

    @Override
    public URI mcpEndpoint() {
        return this.mcpEndpoint;
    }

    @Override
    public String mcpSessionId() {
        return this.mcpSessionId;
    }

    @Override
    public McpAssured.McpStreamableTestClient connect(Consumer<McpAssured.InitResult> assertFunction) {
        if (this.client == null) {
            this.client = new McpStreamableClient(this.mcpEndpoint);
        }
        JsonObject initMessage = this.newInitMessage();
        MultiMap initHeaders = (MultiMap)this.additionalHeaders.apply(initMessage);
        this.addAuthorizationHeader(initHeaders, this.clientBasicAuth);
        HttpResponse<String> response = this.client.sendSync(initMessage.encode(), initHeaders);
        if (this.expectConnectFailure) {
            Assertions.assertNotEquals((int)200, (int)response.statusCode());
            return this;
        }
        Assertions.assertEquals((int)200, (int)response.statusCode(), (String)("Invalid HTTP response status: " + response.statusCode()));
        this.mcpSessionId = response.headers().firstValue("Mcp-Session-Id").orElse(null);
        if (this.mcpSessionId == null) {
            throw new IllegalStateException("Mcp-Session-Id header not found: " + String.valueOf(response.headers()));
        }
        LOG.infof("Mcp-Session-Id received: %s", (Object)this.mcpSessionId);
        JsonObject initResponse = new JsonObject(response.body());
        this.client.state.responses.add(initResponse);
        JsonObject initResult = McpStreamableTestClientImpl.assertResultResponse(initMessage, initResponse);
        Assertions.assertNotNull((Object)initResult);
        JsonObject serverInfo = initResult.getJsonObject("serverInfo");
        JsonObject initCapabilities = initResult.getJsonObject("capabilities");
        ArrayList<McpAssured.ServerCapability> capabilities = new ArrayList<McpAssured.ServerCapability>();
        if (initCapabilities != null) {
            for (String capability : initCapabilities.fieldNames()) {
                capabilities.add(new McpAssured.ServerCapability(capability, initCapabilities.getJsonObject(capability).getMap()));
            }
        }
        Implementation implementation = Messages.decodeImplementation((JsonObject)serverInfo);
        McpAssured.InitResult r = new McpAssured.InitResult(initResult.getString("protocolVersion"), implementation.name(), implementation.title(), implementation.version(), capabilities, serverInfo.getString("instructions"), implementation);
        if (assertFunction != null) {
            assertFunction.accept(r);
        }
        this.initResult = r;
        if (this.openSubsidiarySse) {
            this.client.connectSubsidiarySse(this.additionalHeaders(null));
            if (this.autoPong) {
                this.client.setRequestConsumer(m -> {
                    String method = m.getString("method");
                    if (method != null && "ping".equals(method)) {
                        JsonObject pong = Messages.newResult((Object)m.getValue("id"), (Object)new JsonObject());
                        this.sendAndForget(pong);
                    }
                });
            }
        }
        JsonObject nofitication = this.newMessage("notifications/initialized");
        MultiMap headers = this.additionalHeaders(nofitication);
        this.addAuthorizationHeader(headers, this.clientBasicAuth);
        response = this.client.sendSync(nofitication.encode(), headers);
        if (response.statusCode() != 202) {
            throw new IllegalStateException("Initialization not finished successfully; HTTP response status: " + response.statusCode());
        }
        this.connected.set(true);
        return this;
    }

    private MultiMap additionalHeaders(JsonObject message) {
        MultiMap ret = (MultiMap)this.additionalHeaders.apply(message);
        if (this.mcpSessionId != null) {
            ret.add("Mcp-Session-Id", this.mcpSessionId);
        }
        return ret;
    }

    @Override
    public void disconnect() {
        this.mcpSessionId = null;
        this.connected.set(false);
        this.client = null;
    }

    @Override
    public void terminateSession() {
        MultiMap headers = MultiMap.caseInsensitiveMultiMap();
        if (this.mcpSessionId != null) {
            headers.add("Mcp-Session-Id", this.mcpSessionId);
        }
        this.client.sendTerminate(headers);
    }

    @Override
    public McpAssured.McpStreamableAssert when() {
        return new McpStreamableAssertImpl();
    }

    @Override
    public McpAssured.McpStreamableAssert whenBatch() {
        return new McpStreamableAssertBatch();
    }

    @Override
    protected McpClientState clientState() {
        return this.client.state;
    }

    @Override
    public void sendAndForget(JsonObject message) {
        this.send(message, this.additionalHeaders(message), this.clientBasicAuth);
    }

    private void send(JsonObject message, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        this.send(message.encode(), additionalHeaders, basicAuth);
    }

    private void send(JsonArray batch, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        this.send(batch.encode(), additionalHeaders, basicAuth);
    }

    private void send(String data, MultiMap additionalHeaders, McpTestClientBase.BasicAuth basicAuth) {
        if (!this.connected.get()) {
            throw new IllegalStateException("Client is not connected");
        }
        this.addAuthorizationHeader(additionalHeaders, basicAuth);
        this.client.send(data, additionalHeaders);
    }

    static class BuilderImpl
    extends McpTestClientBuilder<McpAssured.McpStreamableTestClient.Builder>
    implements McpAssured.McpStreamableTestClient.Builder {
        private String mcpPath = "/mcp";
        private URI baseUri = McpAssured.baseUri;
        private Function<JsonObject, MultiMap> additionalHeaders = m -> MultiMap.caseInsensitiveMultiMap();
        private McpTestClientBase.BasicAuth basicAuth;
        private boolean openSubsidiarySse = false;
        private boolean expectConnectFailure = false;

        BuilderImpl() {
        }

        @Override
        public McpAssured.McpStreamableTestClient.Builder setBaseUri(URI baseUri) {
            if (baseUri == null) {
                throw McpTestClientBase.mustNotBeNull("baseUri");
            }
            this.baseUri = baseUri;
            return this;
        }

        @Override
        public McpAssured.McpStreamableTestClient.Builder setMcpPath(String mcpPath) {
            if (mcpPath == null) {
                throw McpTestClientBase.mustNotBeNull("mcpPath");
            }
            this.mcpPath = mcpPath;
            return this;
        }

        @Override
        public McpAssured.McpStreamableTestClient.Builder setAdditionalHeaders(Function<JsonObject, MultiMap> additionalHeaders) {
            if (additionalHeaders == null) {
                throw McpTestClientBase.mustNotBeNull("additionalHeaders");
            }
            this.additionalHeaders = additionalHeaders;
            return this;
        }

        @Override
        public McpAssured.McpStreamableTestClient.Builder setBasicAuth(String username, String password) {
            if (username == null) {
                throw McpTestClientBase.mustNotBeNull("username");
            }
            if (password == null) {
                throw McpTestClientBase.mustNotBeNull("password");
            }
            this.basicAuth = new McpTestClientBase.BasicAuth(username, password);
            return this;
        }

        @Override
        public McpAssured.McpStreamableTestClient.Builder setOpenSubsidiarySse(boolean value) {
            this.openSubsidiarySse = value;
            return this;
        }

        @Override
        public McpAssured.McpStreamableTestClient.Builder setExpectConnectFailure() {
            this.expectConnectFailure = true;
            return this;
        }

        @Override
        public McpAssured.McpStreamableTestClient build() {
            if (this.baseUri == null) {
                throw new IllegalArgumentException("Base URI must be set");
            }
            return new McpStreamableTestClientImpl(this);
        }
    }

    class McpStreamableAssertImpl
    extends McpTestClientBase.McpAssertBase
    implements McpAssured.McpStreamableAssert {
        protected final AtomicReference<MultiMap> additionalHeaders = new AtomicReference();
        protected final AtomicReference<McpTestClientBase.BasicAuth> basicAuth = new AtomicReference();

        private McpStreamableAssertImpl() {
        }

        @Override
        public McpAssured.McpStreamableAssert addHeaders(MultiMap additionalHeaders) {
            this.additionalHeaders.set(additionalHeaders);
            return this;
        }

        @Override
        public McpAssured.McpStreamableAssert basicAuth(String username, String password) {
            this.basicAuth.set(new McpTestClientBase.BasicAuth(username, password));
            return this;
        }

        @Override
        public McpAssured.McpStreamableAssert noBasicAuth() {
            this.basicAuth.set(new McpTestClientBase.BasicAuth(null, null));
            return this;
        }

        protected McpAssured.McpStreamableAssert self() {
            return this;
        }

        @Override
        protected void doSend(JsonObject message) {
            McpTestClientBase.BasicAuth basicAuth = this.basicAuth.get();
            if (basicAuth == null) {
                basicAuth = McpStreamableTestClientImpl.this.clientBasicAuth;
            }
            McpStreamableTestClientImpl.this.send(message, McpStreamableTestClientImpl.this.additionalHeaders(message), basicAuth);
        }
    }

    class McpStreamableAssertBatch
    extends McpStreamableAssertImpl {
        private final List<JsonObject> requests = new ArrayList<JsonObject>();

        McpStreamableAssertBatch() {
        }

        @Override
        protected void doSend(JsonObject message) {
            this.requests.add(message);
        }

        @Override
        public McpAssured.Snapshot thenAssertResults() {
            McpTestClientBase.BasicAuth basicAuth;
            JsonArray batch = new JsonArray();
            this.requests.forEach(arg_0 -> ((JsonArray)batch).add(arg_0));
            MultiMap headers = MultiMap.caseInsensitiveMultiMap();
            if (McpStreamableTestClientImpl.this.mcpSessionId != null) {
                headers.add("Mcp-Session-Id", McpStreamableTestClientImpl.this.mcpSessionId);
            }
            for (JsonObject request : this.requests) {
                headers.addAll((MultiMap)McpStreamableTestClientImpl.this.additionalHeaders.apply(request));
            }
            MultiMap additionalHeaders = (MultiMap)this.additionalHeaders.get();
            if (additionalHeaders != null) {
                headers.addAll(additionalHeaders);
            }
            if ((basicAuth = (McpTestClientBase.BasicAuth)this.basicAuth.get()) == null) {
                basicAuth = McpStreamableTestClientImpl.this.clientBasicAuth;
            }
            McpStreamableTestClientImpl.this.send(batch, headers, basicAuth);
            return super.thenAssertResults();
        }
    }
}

