/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.ClientCapability;
import io.quarkiverse.mcp.server.CompletionResponse;
import io.quarkiverse.mcp.server.Content;
import io.quarkiverse.mcp.server.Icon;
import io.quarkiverse.mcp.server.PromptMessage;
import io.quarkiverse.mcp.server.PromptResponse;
import io.quarkiverse.mcp.server.ResourceContents;
import io.quarkiverse.mcp.server.ResourceResponse;
import io.quarkiverse.mcp.server.Role;
import io.quarkiverse.mcp.server.ToolResponse;
import io.quarkiverse.mcp.server.runtime.Contents;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.test.McpAssured;
import io.quarkiverse.mcp.server.test.McpClientState;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;

abstract class McpTestClientBase<ASSERT extends McpAssured.McpAssert<ASSERT>, CLIENT extends McpAssured.McpTestClient<ASSERT, CLIENT>>
implements McpAssured.McpTestClient<ASSERT, CLIENT> {
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected final String name;
    protected final String version;
    protected final String protocolVersion;
    protected final Set<ClientCapability> clientCapabilities;
    protected final Function<JsonObject, MultiMap> additionalHeaders;
    protected final boolean autoPong;
    protected final BasicAuth clientBasicAuth;
    protected final AtomicBoolean connected;
    protected volatile McpAssured.InitResult initResult;
    protected String title;
    protected String description;
    protected String websiteUrl;
    protected Set<Icon> icons;

    McpTestClientBase(String name, String version, String protocolVersion, Set<ClientCapability> clientCapabilities, Function<JsonObject, MultiMap> additionalHeaders, boolean autoPong, BasicAuth clientBasicAuth, String title, String description, String websiteUrl, Set<Icon> icons) {
        this.name = name;
        this.version = version;
        this.protocolVersion = protocolVersion;
        this.clientCapabilities = clientCapabilities;
        this.additionalHeaders = additionalHeaders;
        this.autoPong = autoPong;
        this.clientBasicAuth = clientBasicAuth;
        this.connected = new AtomicBoolean();
        this.title = title;
        this.description = description;
        this.websiteUrl = websiteUrl;
        this.icons = icons != null ? icons : Set.of();
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public McpAssured.InitResult initResult() {
        return this.initResult;
    }

    @Override
    public JsonObject newMessage(String method) {
        return new JsonObject().put("jsonrpc", (Object)"2.0").put("method", (Object)method);
    }

    @Override
    public JsonObject newRequest(String method) {
        return this.newMessage(method).put("id", (Object)this.nextRequestId());
    }

    @Override
    public McpAssured.Snapshot waitForNotifications(int count) {
        if (!this.isConnected()) {
            throw McpTestClientBase.notConnected();
        }
        this.clientState().waitForNotifications(count);
        return this.snapshot();
    }

    @Override
    public McpAssured.Snapshot waitForRequests(int count) {
        if (!this.isConnected()) {
            throw McpTestClientBase.notConnected();
        }
        this.clientState().waitForRequests(count);
        return this.snapshot();
    }

    @Override
    public JsonObject waitForResponse(JsonObject request) {
        if (!this.isConnected()) {
            throw McpTestClientBase.notConnected();
        }
        return this.clientState().waitForResponse(request);
    }

    protected abstract McpClientState clientState();

    @Override
    public McpAssured.Snapshot snapshot() {
        return this.clientState().toSnapshot();
    }

    protected static void assertResponse(JsonObject request, JsonObject response) {
        Assertions.assertEquals((Integer)request.getInteger("id"), (Integer)response.getInteger("id"));
        Assertions.assertEquals((Object)"2.0", (Object)response.getString("jsonrpc"));
    }

    protected static JsonObject assertResultResponse(JsonObject request, JsonObject response) {
        McpTestClientBase.assertResponse(request, response);
        JsonObject result = response.getJsonObject("result");
        Assertions.assertNotNull((Object)result, (String)("Expected result response but received: " + String.valueOf(response)));
        return result;
    }

    protected static JsonObject assertErrorResponse(JsonObject request, JsonObject response) {
        McpTestClientBase.assertResponse(request, response);
        JsonObject error = response.getJsonObject("error");
        Assertions.assertNotNull((Object)error, (String)("Expected error response but received: " + String.valueOf(response)));
        return error;
    }

    protected JsonObject newRequest(String method, Consumer<JsonObject> paramsConsumer) {
        JsonObject params = new JsonObject();
        paramsConsumer.accept(params);
        return this.newRequest(method).put("params", (Object)params);
    }

    protected JsonObject newToolsCallMessage(String toolName, Map<String, Object> arguments, Map<String, Object> meta) {
        return this.newRequest("tools/call", p -> {
            p.put("name", (Object)toolName);
            this.addMeta((JsonObject)p, meta);
            if (!arguments.isEmpty()) {
                p.put("arguments", (Object)arguments);
            }
        });
    }

    protected JsonObject newListMessage(String method, Map<String, Object> meta, String cursor) {
        return this.newRequest(method, p -> {
            this.addMeta((JsonObject)p, meta);
            if (cursor != null) {
                p.put("cursor", (Object)cursor);
            }
        });
    }

    protected void addMeta(JsonObject params, Map<String, Object> meta) {
        if (!meta.isEmpty()) {
            params.put("_meta", meta);
        }
    }

    protected JsonObject newPromptsGetMessage(String promptName, Map<String, String> args, Map<String, Object> meta) {
        return this.newRequest("prompts/get", p -> {
            p.put("name", (Object)promptName);
            this.addMeta((JsonObject)p, meta);
            if (!args.isEmpty()) {
                p.put("arguments", (Object)args);
            }
        });
    }

    protected JsonObject newCompleteMessage(String refType, String refName, String argumentName, String argumentValue, Map<String, String> contextArgs, Map<String, Object> meta) {
        return this.newRequest("completion/complete", p -> {
            JsonObject ref = new JsonObject().put("type", (Object)refType);
            if (Messages.isPromptRef((String)refType)) {
                ref.put("name", (Object)refName);
            } else if (Messages.isResourceRef((String)refType)) {
                ref.put("uri", (Object)refName);
            }
            this.addMeta((JsonObject)p, meta);
            p.put("ref", (Object)ref);
            p.put("argument", (Object)new JsonObject().put("name", (Object)argumentName).put("value", (Object)argumentValue));
            if (contextArgs != null) {
                p.put("context", (Object)new JsonObject().put("arguments", (Object)contextArgs));
            }
        });
    }

    protected JsonObject newResourcesReadMessage(String uri, Map<String, Object> meta) {
        return this.newRequest("resources/read", p -> {
            p.put("uri", (Object)uri);
            this.addMeta((JsonObject)p, meta);
        });
    }

    @Override
    public JsonObject newInitMessage() {
        JsonObject initMessage = this.newRequest("initialize");
        JsonObject clientInfo = new JsonObject().put("name", (Object)this.name).put("version", (Object)this.version);
        if (this.title != null) {
            clientInfo.put("title", (Object)this.title);
        }
        if (this.description != null) {
            clientInfo.put("description", (Object)this.description);
        }
        if (this.websiteUrl != null) {
            clientInfo.put("websiteUrl", (Object)this.websiteUrl);
        }
        if (!this.icons.isEmpty()) {
            JsonArray icons = new JsonArray();
            for (Icon icon : this.icons) {
                JsonObject i = new JsonObject().put("src", (Object)icon.src());
                if (icon.mimeType() != null) {
                    i.put("mimeType", (Object)icon.mimeType());
                }
                if (icon.theme() != null) {
                    i.put("theme", (Object)icon.theme().toString().toLowerCase());
                }
                if (!icon.sizes().isEmpty()) {
                    i.put("sizes", (Object)icon.sizes());
                }
                icons.add((Object)i);
            }
            clientInfo.put("icons", (Object)icons);
        }
        JsonObject params = new JsonObject().put("clientInfo", (Object)clientInfo).put("protocolVersion", (Object)this.protocolVersion);
        if (!this.clientCapabilities.isEmpty()) {
            JsonObject capabilities = new JsonObject();
            for (ClientCapability capability : this.clientCapabilities) {
                capabilities.put(capability.name(), (Object)capability.properties());
            }
            params.put("capabilities", (Object)capabilities);
        }
        initMessage.put("params", (Object)params);
        return initMessage;
    }

    protected int nextRequestId() {
        return this.clientState().nextRequestId();
    }

    static final String getBasicAuthenticationHeader(String username, String password) {
        String value = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(value.getBytes());
    }

    protected static IllegalStateException notConnected() {
        return new IllegalStateException("Client is not connected yet");
    }

    protected static IllegalArgumentException mustNotBeNull(String name) {
        return new IllegalArgumentException(name + " must not be null");
    }

    protected static URI createEndpointUri(URI baseUri, String path) {
        Object endpointUri = baseUri.toString();
        endpointUri = ((String)endpointUri).endsWith("/") ? (path.startsWith("/") ? (String)endpointUri + path.substring(1) : (String)endpointUri + path) : (path.startsWith("/") ? (String)endpointUri + path : (String)endpointUri + "/" + path);
        return URI.create((String)endpointUri);
    }

    protected void addAuthorizationHeader(MultiMap headers, BasicAuth basicAuth) {
        if (basicAuth != null) {
            headers.add(HEADER_AUTHORIZATION, McpTestClientBase.getBasicAuthenticationHeader(basicAuth.username(), basicAuth.password()));
        }
    }

    record BasicAuth(String username, String password) {
        boolean isEmpty() {
            return this.username == null;
        }
    }

    record ToolsCallAssert(JsonObject request, Consumer<ToolResponse> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            List<Content> content;
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            boolean isError = result.getBoolean("isError");
            JsonArray contentArray = result.getJsonArray("content");
            if (contentArray != null) {
                content = new ArrayList(contentArray.size());
                for (int i = 0; i < contentArray.size(); ++i) {
                    content.add(Contents.parseContent((JsonObject)contentArray.getJsonObject(i)));
                }
            } else {
                content = List.of();
            }
            this.assertFunction.accept(new ToolResponse(isError, content, (Object)result.getJsonObject("structuredContent"), Contents.parseMeta((JsonObject)result)));
        }
    }

    record ResourcesReadAssert(JsonObject request, Consumer<ResourceResponse> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            JsonArray contents = result.getJsonArray("contents");
            ArrayList<ResourceContents> resourceContents = new ArrayList<ResourceContents>();
            if (!contents.isEmpty()) {
                for (int i = 0; i < contents.size(); ++i) {
                    resourceContents.add(Contents.parseResourceContents((JsonObject)contents.getJsonObject(i)));
                }
            }
            this.assertFunction.accept(new ResourceResponse(resourceContents, Contents.parseMeta((JsonObject)result)));
        }
    }

    record ToolsListAssert(JsonObject request, Consumer<McpAssured.ToolsPage> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            JsonArray tools = result.getJsonArray("tools");
            Assertions.assertNotNull((Object)tools);
            ArrayList<McpAssured.ToolInfo> infos = new ArrayList<McpAssured.ToolInfo>();
            for (int i = 0; i < tools.size(); ++i) {
                JsonObject tool = tools.getJsonObject(i);
                infos.add(this.parseTool(tool));
            }
            this.assertFunction.accept(new McpAssured.ToolsPage(infos, result.getString("nextCursor")));
        }

        private McpAssured.ToolInfo parseTool(JsonObject tool) {
            JsonObject annotations = tool.getJsonObject("annotations");
            Optional<McpAssured.ToolAnnotations> toolAnnotations = annotations == null ? Optional.empty() : Optional.of(new McpAssured.ToolAnnotations(annotations.getString("title", ""), annotations.getBoolean("readOnlyHint", Boolean.valueOf(false)), annotations.getBoolean("destructiveHint", Boolean.valueOf(true)), annotations.getBoolean("idempotentHint", Boolean.valueOf(false)), annotations.getBoolean("openWorldHint", Boolean.valueOf(true))));
            return new McpAssured.ToolInfo(tool.getString("name"), tool.getString("title"), tool.getString("description"), tool.getJsonObject("inputSchema"), tool.getJsonObject("outputSchema"), toolAnnotations, tool.getJsonObject("_meta"), tool.getJsonArray("icons"));
        }
    }

    record PromptsCompleteAssert(JsonObject request, Consumer<CompletionResponse> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            if (this.assertFunction == null) {
                return;
            }
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            JsonObject completion = result.getJsonObject("completion");
            ArrayList<String> values = new ArrayList<String>();
            for (Object val : completion.getJsonArray("values")) {
                values.add(val.toString());
            }
            Integer total = completion.getInteger("total");
            Boolean hasMore = completion.getBoolean("hasMore");
            this.assertFunction.accept(new CompletionResponse(values, total, hasMore));
        }
    }

    record PromptsGetAssert(JsonObject request, Consumer<PromptResponse> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            if (this.assertFunction == null) {
                return;
            }
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            String description = result.getString("description");
            ArrayList<PromptMessage> promptMessages = new ArrayList<PromptMessage>();
            JsonArray messages = result.getJsonArray("messages");
            if (!messages.isEmpty()) {
                for (int i = 0; i < messages.size(); ++i) {
                    JsonObject message = messages.getJsonObject(i);
                    Role role = Role.valueOf((String)message.getString("role").toUpperCase());
                    JsonObject content = message.getJsonObject("content");
                    Content messageContent = Contents.parseContent((JsonObject)content);
                    promptMessages.add(new PromptMessage(role, messageContent));
                }
            }
            this.assertFunction.accept(new PromptResponse(description, promptMessages, Contents.parseMeta((JsonObject)result)));
        }
    }

    record PromptsListAssert(JsonObject request, Consumer<McpAssured.PromptsPage> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            JsonArray prompts = result.getJsonArray("prompts");
            Assertions.assertNotNull((Object)prompts);
            ArrayList<McpAssured.PromptInfo> infos = new ArrayList<McpAssured.PromptInfo>();
            for (int i = 0; i < prompts.size(); ++i) {
                JsonObject prompt = prompts.getJsonObject(i);
                infos.add(this.parsePrompt(prompt));
            }
            this.assertFunction.accept(new McpAssured.PromptsPage(infos, result.getString("nextCursor")));
        }

        private McpAssured.PromptInfo parsePrompt(JsonObject prompt) {
            JsonArray args = prompt.getJsonArray("arguments");
            ArrayList<McpAssured.PromptArgument> promptArgs = null;
            if (!args.isEmpty()) {
                promptArgs = new ArrayList<McpAssured.PromptArgument>();
                for (int i = 0; i < args.size(); ++i) {
                    JsonObject arg = args.getJsonObject(i);
                    promptArgs.add(new McpAssured.PromptArgument(arg.getString("name"), arg.getString("title"), arg.getString("description"), arg.getBoolean("required", Boolean.valueOf(false))));
                }
            }
            return new McpAssured.PromptInfo(prompt.getString("name"), prompt.getString("title"), prompt.getString("description"), promptArgs, prompt.getJsonObject("_meta"), prompt.getJsonArray("icons"));
        }
    }

    record ResourcesTemplatesListAssert(JsonObject request, Consumer<McpAssured.ResourcesTemplatesPage> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            JsonArray templates = result.getJsonArray("resourceTemplates");
            Assertions.assertNotNull((Object)templates);
            ArrayList<McpAssured.ResourceTemplateInfo> infos = new ArrayList<McpAssured.ResourceTemplateInfo>();
            for (int i = 0; i < templates.size(); ++i) {
                JsonObject info = templates.getJsonObject(i);
                infos.add(this.parseResourceTemplate(info));
            }
            this.assertFunction.accept(new McpAssured.ResourcesTemplatesPage(infos, result.getString("nextCursor")));
        }

        private McpAssured.ResourceTemplateInfo parseResourceTemplate(JsonObject resource) {
            return new McpAssured.ResourceTemplateInfo(resource.getString("uriTemplate"), resource.getString("mimeType"), resource.getString("name"), resource.getString("title"), resource.getString("description"), Contents.parseAnnotations((JsonObject)resource), resource.getJsonObject("_meta"), resource.getJsonArray("icons"));
        }
    }

    record ResourcesListAssert(JsonObject request, Consumer<McpAssured.ResourcesPage> assertFunction) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            JsonArray resources = result.getJsonArray("resources");
            Assertions.assertNotNull((Object)resources);
            ArrayList<McpAssured.ResourceInfo> infos = new ArrayList<McpAssured.ResourceInfo>();
            for (int i = 0; i < resources.size(); ++i) {
                JsonObject info = resources.getJsonObject(i);
                infos.add(this.parseResource(info));
            }
            this.assertFunction.accept(new McpAssured.ResourcesPage(infos, result.getString("nextCursor")));
        }

        private McpAssured.ResourceInfo parseResource(JsonObject resource) {
            return new McpAssured.ResourceInfo(resource.getString("uri"), resource.getString("mimeType"), resource.getString("name"), resource.getString("title"), resource.getString("description"), resource.getInteger("size"), Contents.parseAnnotations((JsonObject)resource), resource.getJsonObject("_meta"), resource.getJsonArray("icons"));
        }
    }

    record PongAssert(JsonObject request) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject result = McpTestClientBase.assertResultResponse(this.request, response);
            Assertions.assertTrue((boolean)result.isEmpty());
        }
    }

    record ErrorAssert(JsonObject request, Consumer<McpAssured.McpError> errorMessageAssert) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            JsonObject error = McpTestClientBase.assertErrorResponse(response, response);
            this.errorMessageAssert.accept(new McpAssured.McpError(error.getInteger("code"), error.getString("message")));
        }
    }

    record MessageAssert(JsonObject request, Consumer<JsonObject> responseAssert) implements ResponseAssert
    {
        @Override
        public void doAssert(JsonObject response) {
            this.responseAssert.accept(response);
        }
    }

    static interface ResponseAssert {
        public JsonObject request();

        public void doAssert(JsonObject var1);
    }

    abstract class McpAssertBase
    implements McpAssured.McpAssert<ASSERT> {
        protected final List<ResponseAssert> asserts = new ArrayList<ResponseAssert>();

        McpAssertBase() {
        }

        protected abstract ASSERT self();

        protected abstract void doSend(JsonObject var1);

        @Override
        public McpAssured.Snapshot thenAssertResults() {
            for (ResponseAssert responseAssert : this.asserts) {
                JsonObject response = McpTestClientBase.this.clientState().waitForResponse(responseAssert.request());
                Assertions.assertNotNull((Object)response);
                responseAssert.doAssert(response);
            }
            return McpTestClientBase.this.snapshot();
        }

        @Override
        public McpAssured.McpAssert.PingMessage<ASSERT> ping() {
            return new PingMessageImpl();
        }

        @Override
        public McpAssured.McpAssert.ToolsListMessage<ASSERT> toolsList() {
            return new ToolsListMessageImpl();
        }

        @Override
        public McpAssured.McpAssert.ToolsCallMessage<ASSERT> toolsCall(String toolName) {
            if (toolName == null) {
                throw McpTestClientBase.mustNotBeNull("toolName");
            }
            return new ToolsCallMessageImpl(toolName);
        }

        @Override
        public McpAssured.McpAssert.PromptsListMessage<ASSERT> promptsList() {
            return new PromptsListMessageImpl();
        }

        @Override
        public McpAssured.McpAssert.PromptsGetMessage<ASSERT> promptsGet(String promptName) {
            if (promptName == null) {
                throw McpTestClientBase.mustNotBeNull("promptName");
            }
            return new PromptsGetMessageImpl(promptName);
        }

        @Override
        public McpAssured.McpAssert.PromptsCompleteMessage<ASSERT> promptComplete(String promptName) {
            if (promptName == null) {
                throw McpTestClientBase.mustNotBeNull("promptName");
            }
            return new PromptsCompleteMessageImpl(promptName);
        }

        @Override
        public McpAssured.McpAssert.ResourcesReadMessage<ASSERT> resourcesRead(String uri) {
            if (uri == null) {
                throw McpTestClientBase.mustNotBeNull("uri");
            }
            return new ResourcesReadMessageImpl(uri);
        }

        @Override
        public McpAssured.McpAssert.ResourcesListMessage<ASSERT> resourcesList() {
            return new ResourcesListMessageImpl();
        }

        @Override
        public McpAssured.McpAssert.ResourcesTemplatesListMessage<ASSERT> resourcesTemplatesList() {
            return new ResourcesTemplatesListMessageImpl();
        }

        @Override
        public McpAssured.McpAssert.ResourceTemplateCompleteMessage<ASSERT> resourceTemplateComplete(String uriTemplate) {
            return new ResourceTemplateCompleteMessageImpl(uriTemplate);
        }

        @Override
        public McpAssured.McpAssert.GenericMessage<ASSERT> message(JsonObject message) {
            if (message == null) {
                throw McpTestClientBase.mustNotBeNull("message");
            }
            return new GenericMessageImpl(message);
        }

        class PingMessageImpl
        implements McpAssured.McpAssert.PingMessage<ASSERT> {
            private boolean pongAssert;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            PingMessageImpl() {
            }

            @Override
            public McpAssured.McpAssert.PingMessage<ASSERT> withPongAssert() {
                this.pongAssert = true;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PingMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newRequest("ping");
                McpAssertBase.this.doSend(message);
                if (this.pongAssert) {
                    McpAssertBase.this.asserts.add(new PongAssert(message));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class ToolsListMessageImpl
        implements McpAssured.McpAssert.ToolsListMessage<ASSERT> {
            private String cursor;
            private Map<String, Object> meta = Map.of();
            private Consumer<McpAssured.ToolsPage> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            ToolsListMessageImpl() {
            }

            @Override
            public McpAssured.McpAssert.ToolsListMessage<ASSERT> withCursor(String cursor) {
                this.cursor = cursor;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ToolsListMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ToolsListMessage<ASSERT> withAssert(Consumer<McpAssured.ToolsPage> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ToolsListMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newListMessage("tools/list", this.meta, this.cursor);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new ToolsListAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class ToolsCallMessageImpl
        implements McpAssured.McpAssert.ToolsCallMessage<ASSERT> {
            private final String toolName;
            private Map<String, Object> args = Map.of();
            private Map<String, Object> meta = Map.of();
            private Consumer<ToolResponse> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            ToolsCallMessageImpl(String toolName) {
                this.toolName = toolName;
            }

            @Override
            public McpAssured.McpAssert.ToolsCallMessage<ASSERT> withArguments(Map<String, Object> args) {
                if (args == null) {
                    throw McpTestClientBase.mustNotBeNull("args");
                }
                this.args = args;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ToolsCallMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                if (meta == null) {
                    throw McpTestClientBase.mustNotBeNull("meta");
                }
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ToolsCallMessage<ASSERT> withAssert(Consumer<ToolResponse> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ToolsCallMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newToolsCallMessage(this.toolName, this.args, this.meta);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new ToolsCallAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class PromptsListMessageImpl
        implements McpAssured.McpAssert.PromptsListMessage<ASSERT> {
            private String cursor;
            private Map<String, Object> meta = Map.of();
            private Consumer<McpAssured.PromptsPage> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            PromptsListMessageImpl() {
            }

            @Override
            public McpAssured.McpAssert.PromptsListMessage<ASSERT> withCursor(String cursor) {
                this.cursor = cursor;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsListMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsListMessage<ASSERT> withAssert(Consumer<McpAssured.PromptsPage> assertFunction) {
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsListMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newListMessage("prompts/list", this.meta, this.cursor);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new PromptsListAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class PromptsGetMessageImpl
        implements McpAssured.McpAssert.PromptsGetMessage<ASSERT> {
            private final String promptName;
            private Map<String, String> args = Map.of();
            private Map<String, Object> meta = Map.of();
            private Consumer<PromptResponse> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            PromptsGetMessageImpl(String promptName) {
                this.promptName = promptName;
            }

            @Override
            public McpAssured.McpAssert.PromptsGetMessage<ASSERT> withArguments(Map<String, String> args) {
                this.args = args;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsGetMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                if (meta == null) {
                    throw McpTestClientBase.mustNotBeNull("meta");
                }
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsGetMessage<ASSERT> withAssert(Consumer<PromptResponse> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsGetMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newPromptsGetMessage(this.promptName, this.args, this.meta);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new PromptsGetAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        /*
         * Signature claims super is io.quarkiverse.mcp.server.test.McpTestClientBase$McpAssertBase.CompleteMessageImpl, not io.quarkiverse.mcp.server.test.McpTestClientBase$McpAssertBase$CompleteMessageImpl - discarding signature.
         */
        class PromptsCompleteMessageImpl
        extends CompleteMessageImpl
        implements McpAssured.McpAssert.PromptsCompleteMessage {
            PromptsCompleteMessageImpl(String promptName) {
                super(promptName);
            }

            @Override
            public McpAssured.McpAssert.PromptsCompleteMessage<ASSERT> withArgument(String name, String value) {
                if (name == null) {
                    throw McpTestClientBase.mustNotBeNull("name");
                }
                if (value == null) {
                    throw McpTestClientBase.mustNotBeNull("value");
                }
                this.argumentName = name;
                this.argumentValue = value;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsCompleteMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                if (meta == null) {
                    throw McpTestClientBase.mustNotBeNull("meta");
                }
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsCompleteMessage<ASSERT> withContext(Map<String, String> arguments) {
                this.contextArguments = arguments;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsCompleteMessage<ASSERT> withAssert(Consumer<CompletionResponse> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.PromptsCompleteMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newCompleteMessage("ref/prompt", this.name, this.argumentName, this.argumentValue, this.contextArguments, this.meta);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new PromptsCompleteAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class ResourcesReadMessageImpl
        implements McpAssured.McpAssert.ResourcesReadMessage<ASSERT> {
            private final String uri;
            private Map<String, Object> meta = Map.of();
            private Consumer<ResourceResponse> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            ResourcesReadMessageImpl(String uri) {
                this.uri = uri;
            }

            @Override
            public McpAssured.McpAssert.ResourcesReadMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                if (meta == null) {
                    throw McpTestClientBase.mustNotBeNull("meta");
                }
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesReadMessage<ASSERT> withAssert(Consumer<ResourceResponse> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesReadMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newResourcesReadMessage(this.uri, this.meta);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new ResourcesReadAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class ResourcesListMessageImpl
        implements McpAssured.McpAssert.ResourcesListMessage<ASSERT> {
            private String cursor;
            private Map<String, Object> meta = Map.of();
            private Consumer<McpAssured.ResourcesPage> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            ResourcesListMessageImpl() {
            }

            @Override
            public McpAssured.McpAssert.ResourcesListMessage<ASSERT> withCursor(String cursor) {
                this.cursor = cursor;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesListMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesListMessage<ASSERT> withAssert(Consumer<McpAssured.ResourcesPage> assertFunction) {
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesListMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newListMessage("resources/list", this.meta, this.cursor);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new ResourcesListAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class ResourcesTemplatesListMessageImpl
        implements McpAssured.McpAssert.ResourcesTemplatesListMessage<ASSERT> {
            private String cursor;
            private Map<String, Object> meta = Map.of();
            private Consumer<McpAssured.ResourcesTemplatesPage> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            ResourcesTemplatesListMessageImpl() {
            }

            @Override
            public McpAssured.McpAssert.ResourcesTemplatesListMessage<ASSERT> withCursor(String cursor) {
                this.cursor = cursor;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesTemplatesListMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesTemplatesListMessage<ASSERT> withAssert(Consumer<McpAssured.ResourcesTemplatesPage> assertFunction) {
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourcesTemplatesListMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newListMessage("resources/templates/list", this.meta, this.cursor);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new ResourcesTemplatesListAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        /*
         * Signature claims super is io.quarkiverse.mcp.server.test.McpTestClientBase$McpAssertBase.CompleteMessageImpl, not io.quarkiverse.mcp.server.test.McpTestClientBase$McpAssertBase$CompleteMessageImpl - discarding signature.
         */
        class ResourceTemplateCompleteMessageImpl
        extends CompleteMessageImpl
        implements McpAssured.McpAssert.ResourceTemplateCompleteMessage {
            private Map<String, Object> meta;

            ResourceTemplateCompleteMessageImpl(String uriTemplate) {
                super(uriTemplate);
                this.meta = Map.of();
            }

            @Override
            public McpAssured.McpAssert.ResourceTemplateCompleteMessage<ASSERT> withArgument(String name, String value) {
                if (name == null) {
                    throw McpTestClientBase.mustNotBeNull("name");
                }
                if (value == null) {
                    throw McpTestClientBase.mustNotBeNull("value");
                }
                this.argumentName = name;
                this.argumentValue = value;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourceTemplateCompleteMessage<ASSERT> withMetadata(Map<String, Object> meta) {
                if (meta == null) {
                    throw McpTestClientBase.mustNotBeNull("meta");
                }
                this.meta = meta;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourceTemplateCompleteMessage<ASSERT> withContext(Map<String, String> arguments) {
                this.contextArguments = arguments;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourceTemplateCompleteMessage<ASSERT> withAssert(Consumer<CompletionResponse> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.ResourceTemplateCompleteMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                JsonObject message = McpTestClientBase.this.newCompleteMessage("ref/resource", this.name, this.argumentName, this.argumentValue, this.contextArguments, this.meta);
                McpAssertBase.this.doSend(message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new PromptsCompleteAssert(message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        class GenericMessageImpl
        implements McpAssured.McpAssert.GenericMessage<ASSERT> {
            private final JsonObject message;
            private Consumer<JsonObject> assertFunction;
            private Consumer<McpAssured.McpError> errorAssertFunction;

            GenericMessageImpl(JsonObject message) {
                this.message = message;
            }

            @Override
            public McpAssured.McpAssert.GenericMessage<ASSERT> withAssert(Consumer<JsonObject> assertFunction) {
                if (assertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("assertFunction");
                }
                this.assertFunction = assertFunction;
                return this;
            }

            @Override
            public McpAssured.McpAssert.GenericMessage<ASSERT> withErrorAssert(Consumer<McpAssured.McpError> errorAssertFunction) {
                if (errorAssertFunction == null) {
                    throw McpTestClientBase.mustNotBeNull("errorAssertFunction");
                }
                this.errorAssertFunction = errorAssertFunction;
                return this;
            }

            @Override
            public ASSERT send() {
                McpAssertBase.this.doSend(this.message);
                if (this.assertFunction != null) {
                    McpAssertBase.this.asserts.add(new MessageAssert(this.message, this.assertFunction));
                } else if (this.errorAssertFunction != null) {
                    McpAssertBase.this.asserts.add(new ErrorAssert(this.message, this.errorAssertFunction));
                }
                return McpAssertBase.this.self();
            }
        }

        abstract class CompleteMessageImpl {
            protected final String name;
            protected String argumentName;
            protected String argumentValue;
            protected Map<String, String> contextArguments;
            protected Consumer<CompletionResponse> assertFunction;
            protected Consumer<McpAssured.McpError> errorAssertFunction;
            protected Map<String, Object> meta = Map.of();

            CompleteMessageImpl(String name) {
                this.name = name;
            }
        }
    }
}

