/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.Implementation;
import io.quarkiverse.mcp.server.runtime.Messages;
import io.quarkiverse.mcp.server.test.McpAssured;
import io.quarkiverse.mcp.server.test.McpClientState;
import io.quarkiverse.mcp.server.test.McpTestClientBase;
import io.quarkiverse.mcp.server.test.McpTestClientBuilder;
import io.quarkiverse.mcp.server.test.McpWebSocketClient;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

class McpWebSocketTestClientImpl
extends McpTestClientBase<McpAssured.McpWebSocketAssert, McpAssured.McpWebSocketTestClient>
implements McpAssured.McpWebSocketTestClient {
    private static final Logger LOG = Logger.getLogger(McpWebSocketTestClientImpl.class);
    private final URI endpointUri;
    private volatile McpWebSocketClient client;

    McpWebSocketTestClientImpl(BuilderImpl builder) {
        super(builder.name, builder.version, builder.protocolVersion, builder.clientCapabilities, null, builder.autoPong, builder.basicAuth, builder.title, builder.description, builder.websiteUrl, builder.icons);
        this.endpointUri = McpWebSocketTestClientImpl.createEndpointUri(builder.baseUri, builder.endpointPath);
        LOG.debugf("McpWebSocketTestClient created with WebSocket endpoint: %s", (Object)this.endpointUri);
    }

    @Override
    public URI endpointUri() {
        return this.endpointUri;
    }

    @Override
    public McpAssured.McpWebSocketTestClient connect(Consumer<McpAssured.InitResult> assertFunction) {
        if (this.client == null) {
            ArcContainer container = Arc.container();
            Vertx vertx = container != null && container.isRunning() ? (Vertx)container.instance(Vertx.class, new Annotation[0]).get() : Vertx.vertx();
            MultiMap headers = MultiMap.caseInsensitiveMultiMap();
            if (this.clientBasicAuth != null) {
                headers.add("Authorization", McpTestClientBase.getBasicAuthenticationHeader(this.clientBasicAuth.username(), this.clientBasicAuth.password()));
            }
            this.client = new McpWebSocketClient(this.endpointUri, vertx, headers);
        }
        if (this.autoPong) {
            this.client.setRequestConsumer(m -> {
                String method = m.getString("method");
                if (method != null && "ping".equals(method)) {
                    JsonObject pong = Messages.newResult((Object)m.getValue("id"), (Object)new JsonObject());
                    this.sendAndForget(pong);
                }
            });
        }
        JsonObject initMessage = this.newInitMessage();
        this.sendAndForget(initMessage);
        JsonObject initResponse = this.client.state.waitForResponse(initMessage);
        JsonObject initResult = McpWebSocketTestClientImpl.assertResultResponse(initMessage, initResponse);
        Assertions.assertNotNull((Object)initResult);
        JsonObject serverInfo = initResult.getJsonObject("serverInfo");
        JsonObject initCapabilities = initResult.getJsonObject("capabilities");
        ArrayList<McpAssured.ServerCapability> capabilities = new ArrayList<McpAssured.ServerCapability>();
        if (initCapabilities != null) {
            for (String capability : initCapabilities.fieldNames()) {
                capabilities.add(new McpAssured.ServerCapability(capability, initCapabilities.getJsonObject(capability).getMap()));
            }
        }
        Implementation implementation = Messages.decodeImplementation((JsonObject)serverInfo);
        McpAssured.InitResult r = new McpAssured.InitResult(initResult.getString("protocolVersion"), implementation.name(), implementation.title(), implementation.version(), capabilities, initResult.getString("instructions"), implementation);
        if (assertFunction != null) {
            assertFunction.accept(r);
        }
        this.initResult = r;
        JsonObject nofitication = this.newMessage("notifications/initialized");
        this.client.send(nofitication.encode()).toCompletionStage().toCompletableFuture().join();
        this.connected.set(true);
        return this;
    }

    @Override
    public void disconnect() {
        this.client.disconnect();
    }

    @Override
    public McpAssured.McpWebSocketAssert when() {
        return new McpWebSocketAssertImpl();
    }

    @Override
    public McpAssured.McpWebSocketAssert whenBatch() {
        return new McpWebSocketAssertBatch();
    }

    @Override
    public void sendAndForget(JsonObject message) {
        this.client.send(message.encode());
    }

    @Override
    protected McpClientState clientState() {
        return this.client.state;
    }

    static class BuilderImpl
    extends McpTestClientBuilder<McpAssured.McpWebSocketTestClient.Builder>
    implements McpAssured.McpWebSocketTestClient.Builder {
        private String endpointPath = "/mcp/ws";
        private URI baseUri = McpAssured.baseUri;
        private McpTestClientBase.BasicAuth basicAuth;

        BuilderImpl() {
        }

        @Override
        public McpAssured.McpWebSocketTestClient.Builder setBasicAuth(String username, String password) {
            this.basicAuth = new McpTestClientBase.BasicAuth(username, password);
            return this;
        }

        @Override
        public McpAssured.McpWebSocketTestClient.Builder setBaseUri(URI baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        @Override
        public McpAssured.McpWebSocketTestClient.Builder setEndpointPath(String path) {
            this.endpointPath = path;
            return this;
        }

        @Override
        public McpAssured.McpWebSocketTestClient build() {
            return new McpWebSocketTestClientImpl(this);
        }
    }

    class McpWebSocketAssertImpl
    extends McpTestClientBase.McpAssertBase
    implements McpAssured.McpWebSocketAssert {
        McpWebSocketAssertImpl() {
            super(McpWebSocketTestClientImpl.this);
        }

        protected McpAssured.McpWebSocketAssert self() {
            return this;
        }

        @Override
        protected void doSend(JsonObject message) {
            McpWebSocketTestClientImpl.this.sendAndForget(message);
        }
    }

    class McpWebSocketAssertBatch
    extends McpWebSocketAssertImpl {
        private final List<JsonObject> requests = new ArrayList<JsonObject>();

        McpWebSocketAssertBatch() {
        }

        @Override
        protected void doSend(JsonObject message) {
            this.requests.add(message);
        }

        @Override
        public McpAssured.Snapshot thenAssertResults() {
            JsonArray batch = new JsonArray();
            this.requests.forEach(arg_0 -> ((JsonArray)batch).add(arg_0));
            McpWebSocketTestClientImpl.this.client.send(batch.encode());
            return super.thenAssertResults();
        }
    }
}

