/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.ClientCapability;
import io.quarkiverse.mcp.server.Icon;
import io.quarkiverse.mcp.server.runtime.McpMessageHandler;
import io.quarkiverse.mcp.server.test.McpAssured;
import io.quarkiverse.mcp.server.test.McpTestClientBase;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

abstract class McpTestClientBuilder<BUILDER extends McpAssured.McpTestClient.Builder<BUILDER>>
implements McpAssured.McpTestClient.Builder<BUILDER> {
    protected String name = "test-client";
    protected String version = "1.0";
    protected String protocolVersion = (String)McpMessageHandler.SUPPORTED_PROTOCOL_VERSIONS.get(0);
    protected String title;
    protected String description;
    protected String websiteUrl;
    protected Set<ClientCapability> clientCapabilities = Set.of();
    protected Set<Icon> icons;
    protected boolean autoPong = true;

    McpTestClientBuilder() {
    }

    @Override
    public BUILDER setName(String clientName) {
        if (clientName == null) {
            throw McpTestClientBase.mustNotBeNull("clientName");
        }
        this.name = clientName;
        return this.self();
    }

    @Override
    public BUILDER setVersion(String clientVersion) {
        if (clientVersion == null) {
            throw McpTestClientBase.mustNotBeNull("clientVersion");
        }
        this.version = clientVersion;
        return this.self();
    }

    @Override
    public BUILDER setProtocolVersion(String protocolVersion) {
        if (protocolVersion == null) {
            throw McpTestClientBase.mustNotBeNull("protocolVersion");
        }
        this.protocolVersion = protocolVersion;
        return this.self();
    }

    @Override
    public BUILDER setTitle(String title) {
        if (title == null) {
            throw McpTestClientBase.mustNotBeNull("title");
        }
        this.title = title;
        return this.self();
    }

    @Override
    public BUILDER setDescription(String description) {
        if (description == null) {
            throw McpTestClientBase.mustNotBeNull("description");
        }
        this.description = description;
        return this.self();
    }

    @Override
    public BUILDER setIcons(Icon ... icons) {
        this.icons = new HashSet<Icon>(Arrays.asList(icons));
        return this.self();
    }

    @Override
    public BUILDER setWebsiteUrl(String websiteUrl) {
        if (websiteUrl == null) {
            throw McpTestClientBase.mustNotBeNull("websiteUrl");
        }
        this.websiteUrl = websiteUrl;
        return this.self();
    }

    @Override
    public BUILDER setClientCapabilities(ClientCapability ... capabilities) {
        this.clientCapabilities = new HashSet<ClientCapability>(Arrays.asList(capabilities));
        return this.self();
    }

    @Override
    public BUILDER setAutoPong(boolean val) {
        this.autoPong = val;
        return this.self();
    }

    private BUILDER self() {
        return (BUILDER)this;
    }
}

