/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.mcp.server.test;

import io.quarkiverse.mcp.server.test.McpClientState;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.ClientWebSocket;
import io.vertx.core.http.WebSocketClient;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.json.JsonObject;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

class McpWebSocketClient {
    final McpClientState state;
    final WebSocketClient client;
    final ClientWebSocket webSocket;
    final List<Buffer> messages = new CopyOnWriteArrayList<Buffer>();
    final AtomicReference<Consumer<JsonObject>> requestConsumer = new AtomicReference();

    public void setRequestConsumer(Consumer<JsonObject> value) {
        this.requestConsumer.set(value);
    }

    public McpWebSocketClient(URI endpointUri, Vertx vertx, MultiMap headers) {
        this.state = new McpClientState();
        WebSocketClientOptions clientOptions = new WebSocketClientOptions();
        this.client = vertx.createWebSocketClient(clientOptions);
        this.webSocket = this.client.webSocket();
        this.webSocket.handler(b -> {
            this.messages.add((Buffer)b);
            JsonObject json = new JsonObject(b);
            if (json.containsKey("id")) {
                if (json.containsKey("result") || json.containsKey("error")) {
                    this.state.responses.add(json);
                } else {
                    this.state.requests.add(json);
                    Consumer<JsonObject> c = this.requestConsumer.get();
                    if (c != null) {
                        c.accept(json);
                    }
                }
            } else {
                this.state.notifications.add(json);
            }
        });
        WebSocketConnectOptions connectOptions = new WebSocketConnectOptions();
        headers.forEach((arg_0, arg_1) -> ((WebSocketConnectOptions)connectOptions).addHeader(arg_0, arg_1));
        connectOptions.setPort(Integer.valueOf(endpointUri.getPort()));
        connectOptions.setHost(endpointUri.getHost());
        connectOptions.setURI(endpointUri.getPath());
        this.webSocket.connect(connectOptions).toCompletionStage().toCompletableFuture().join();
    }

    Future<Void> send(String message) {
        return this.webSocket.writeTextMessage(message);
    }

    void disconnect() {
        this.messages.clear();
        this.webSocket.close().toCompletionStage().toCompletableFuture().join();
    }
}

