/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.runtime;

import io.quarkus.cache.Cache;
import io.quarkus.cache.CacheManager;
import io.quarkus.cache.CacheManagerInfo;
import io.quarkus.cache.runtime.CacheBuildConfig;
import io.quarkus.cache.runtime.CacheConfig;
import io.quarkus.cache.runtime.CacheManagerImpl;
import io.quarkus.cache.runtime.caffeine.CaffeineCacheManagerBuilder;
import io.quarkus.cache.runtime.noop.NoOpCacheManagerBuilder;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.spi.DeploymentException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class CacheManagerRecorder {
    private final CacheBuildConfig cacheBuildConfig;
    private final RuntimeValue<CacheConfig> cacheConfigRV;

    public CacheManagerRecorder(CacheBuildConfig cacheBuildConfig, RuntimeValue<CacheConfig> cacheConfigRV) {
        this.cacheBuildConfig = cacheBuildConfig;
        this.cacheConfigRV = cacheConfigRV;
    }

    private CacheManagerInfo.Context createContextForCacheType(final String cacheType, final boolean micrometerMetricsEnabled) {
        return new CacheManagerInfo.Context(){
            private final Set<String> cacheNames = new HashSet<String>();

            public boolean cacheEnabled() {
                return ((CacheConfig)CacheManagerRecorder.this.cacheConfigRV.getValue()).enabled();
            }

            public CacheManagerInfo.Context.Metrics metrics() {
                return micrometerMetricsEnabled ? CacheManagerInfo.Context.Metrics.MICROMETER : CacheManagerInfo.Context.Metrics.NONE;
            }

            public String cacheType() {
                return cacheType;
            }

            public Set<String> cacheNames() {
                return this.cacheNames;
            }
        };
    }

    private Map<String, String> mapCacheTypeByCacheName(Set<String> cacheNames) {
        HashMap<String, String> cacheTypeByName = new HashMap<String, String>(cacheNames.size());
        for (String cacheName : cacheNames) {
            CacheBuildConfig.CacheTypeBuildConfig cacheTypeBuildConfig = this.cacheBuildConfig.cacheTypeByName().get(cacheName);
            if (cacheTypeBuildConfig != null && cacheTypeBuildConfig.type() != null && !cacheTypeBuildConfig.type().isEmpty()) {
                cacheTypeByName.put(cacheName, cacheTypeBuildConfig.type());
                continue;
            }
            cacheTypeByName.put(cacheName, this.cacheBuildConfig.type());
        }
        return cacheTypeByName;
    }

    private Supplier<CacheManager> findSupplierForType(CacheManagerInfo.Context context, Collection<CacheManagerInfo> infos) {
        for (CacheManagerInfo info : infos) {
            if (!info.supports(context)) continue;
            return info.get(context);
        }
        throw new DeploymentException("Unknown cache type: " + context.cacheType());
    }

    private Map<String, Supplier<CacheManager>> createCacheSupplierByCacheType(Collection<CacheManagerInfo> infos, Set<String> cacheNames, boolean micrometerMetricsEnabled) {
        Map<String, String> cacheTypeByCacheName = this.mapCacheTypeByCacheName(cacheNames);
        HashMap<String, CacheManagerInfo.Context> contextByCacheType = new HashMap<String, CacheManagerInfo.Context>();
        for (String cacheName : cacheNames) {
            contextByCacheType.computeIfAbsent(cacheTypeByCacheName.get(cacheName), cacheType -> this.createContextForCacheType((String)cacheType, micrometerMetricsEnabled)).cacheNames().add(cacheName);
        }
        HashMap<String, Supplier<CacheManager>> suppliersByType = new HashMap<String, Supplier<CacheManager>>();
        for (Map.Entry entry : contextByCacheType.entrySet()) {
            String cacheType2 = (String)entry.getKey();
            if (suppliersByType.containsKey(cacheType2)) continue;
            suppliersByType.put(cacheType2, this.findSupplierForType((CacheManagerInfo.Context)entry.getValue(), infos));
        }
        return suppliersByType;
    }

    public Supplier<CacheManager> resolveCacheInfo(Collection<CacheManagerInfo> infos, Set<String> cacheNames, boolean micrometerMetricsEnabled) {
        final Map<String, Supplier<CacheManager>> suppliersByType = this.createCacheSupplierByCacheType(infos, cacheNames, micrometerMetricsEnabled);
        return new Supplier<CacheManager>(){

            @Override
            public CacheManager get() {
                if (suppliersByType.size() == 1) {
                    return (CacheManager)((Supplier)suppliersByType.values().iterator().next()).get();
                }
                HashMap<String, CacheManager> cacheImplByCacheType = new HashMap<String, CacheManager>();
                for (Map.Entry entry : suppliersByType.entrySet()) {
                    cacheImplByCacheType.put((String)entry.getKey(), (CacheManager)((Supplier)entry.getValue()).get());
                }
                HashMap<String, Cache> allCaches = new HashMap<String, Cache>();
                for (CacheManager cacheManager : cacheImplByCacheType.values()) {
                    for (String cacheName : cacheManager.getCacheNames()) {
                        cacheManager.getCache(cacheName).ifPresent(cache -> allCaches.put(cacheName, (Cache)cache));
                    }
                }
                return new CacheManagerImpl(allCaches);
            }
        };
    }

    public CacheManagerInfo noOpCacheManagerInfo() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return !context.cacheEnabled();
            }

            public Supplier<CacheManager> get(CacheManagerInfo.Context context) {
                return NoOpCacheManagerBuilder.build(context.cacheNames());
            }
        };
    }

    public CacheManagerInfo getCacheManagerInfoWithMicrometerMetrics() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && context.cacheType().equals("caffeine") && context.metrics() == CacheManagerInfo.Context.Metrics.MICROMETER;
            }

            public Supplier<CacheManager> get(CacheManagerInfo.Context context) {
                return CaffeineCacheManagerBuilder.buildWithMicrometerMetrics(context.cacheNames(), (CacheConfig)CacheManagerRecorder.this.cacheConfigRV.getValue());
            }
        };
    }

    public CacheManagerInfo getCacheManagerInfoWithoutMetrics() {
        return new CacheManagerInfo(){

            public boolean supports(CacheManagerInfo.Context context) {
                return context.cacheEnabled() && context.cacheType().equals("caffeine") && context.metrics() == CacheManagerInfo.Context.Metrics.NONE;
            }

            public Supplier<CacheManager> get(CacheManagerInfo.Context context) {
                return CaffeineCacheManagerBuilder.buildWithoutMetrics(context.cacheNames(), (CacheConfig)CacheManagerRecorder.this.cacheConfigRV.getValue());
            }
        };
    }
}

