/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.docker.common.deployment;

import io.quarkus.container.image.docker.common.deployment.DockerFileBaseInformationProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class RedHatOpenJDKRuntimeBaseProvider
implements DockerFileBaseInformationProvider {
    private static final Pattern PATTERN = Pattern.compile(".*ubi([8-9]|[1-9][0-9]+)/openjdk-(\\w+)-runtime.*");

    RedHatOpenJDKRuntimeBaseProvider() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<DockerFileBaseInformationProvider.DockerFileBaseInformation> determine(Path dockerFile) {
        try (Stream<String> lines = Files.lines(dockerFile);){
            Optional<String> fromOpt = lines.filter(l -> l.startsWith("FROM")).findFirst();
            if (!fromOpt.isPresent()) return Optional.empty();
            String fromLine = fromOpt.get();
            String baseImage = fromLine.substring(4).trim();
            Matcher matcher = PATTERN.matcher(baseImage);
            if (!matcher.find()) return Optional.empty();
            String match = matcher.group(2);
            try {
                Optional<DockerFileBaseInformationProvider.DockerFileBaseInformation> optional = Optional.of(new DockerFileBaseInformationProvider.DockerFileBaseInformation(baseImage, Integer.parseInt(match)));
                return optional;
            }
            catch (NumberFormatException numberFormatException) {
                return Optional.empty();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

