/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.docker.common.deployment;

import io.quarkus.container.image.docker.common.deployment.DockerFileBaseInformationProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

class UbiMinimalBaseProvider
implements DockerFileBaseInformationProvider {
    private static final Pattern BASE_IMAGE_PATTERN = Pattern.compile(".*/ubi([8-9]|[1-9][0-9]+)/ubi-minimal");
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("ARG JAVA_PACKAGE=java-(\\w+)-openjdk-headless");

    UbiMinimalBaseProvider() {
    }

    @Override
    public Optional<DockerFileBaseInformationProvider.DockerFileBaseInformation> determine(Path dockerFile) {
        AtomicInteger state = new AtomicInteger(State.FROM_NOT_ENCOUNTERED.ordinal());
        AtomicReference<Object> baseImage = new AtomicReference<Object>(null);
        AtomicInteger javaVersion = new AtomicInteger(0);
        try (Stream<String> lines = Files.lines(dockerFile);){
            lines.takeWhile(s -> state.get() < State.ARG_JAVA_PACKAGE_FOUND.ordinal()).forEach(s -> {
                Matcher matcher;
                if (s.startsWith("FROM")) {
                    String image = s.substring(4).trim();
                    Matcher matcher2 = BASE_IMAGE_PATTERN.matcher(image);
                    if (matcher2.find()) {
                        baseImage.set(image);
                        state.set(State.MATCHING_FROM_FOUND.ordinal());
                    } else {
                        state.set(State.NON_MATCHING_FROM_FOUND.ordinal());
                    }
                } else if (s.startsWith("ARG JAVA_PACKAGE") && (matcher = JAVA_VERSION_PATTERN.matcher((CharSequence)s)).find()) {
                    String match = matcher.group(1);
                    try {
                        javaVersion.set(Integer.parseInt(match));
                        state.set(State.ARG_JAVA_PACKAGE_FOUND.ordinal());
                    }
                    catch (NumberFormatException ignored) {
                        state.set(State.EXCEPTION_OCCURRED.ordinal());
                    }
                }
            });
        }
        catch (IOException ignored) {
            state.set(State.EXCEPTION_OCCURRED.ordinal());
        }
        if (state.get() == State.ARG_JAVA_PACKAGE_FOUND.ordinal()) {
            return Optional.of(new DockerFileBaseInformationProvider.DockerFileBaseInformation(baseImage.get(), javaVersion.get()));
        }
        return Optional.empty();
    }

    private static enum State {
        FROM_NOT_ENCOUNTERED,
        MATCHING_FROM_FOUND,
        ARG_JAVA_PACKAGE_FOUND,
        NON_MATCHING_FROM_FOUND,
        EXCEPTION_OCCURRED;

    }
}

