/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.comms;

import io.quarkus.arc.Arc;
import io.quarkus.arc.DefaultBean;
import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.comms.JsonRpcResponseWriter;
import io.quarkus.devui.runtime.comms.MessageType;
import io.quarkus.devui.runtime.js.JavaScriptResponseWriter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcCodec;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcRequest;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.runtime.StartupEvent;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.unchecked.Unchecked;
import io.vertx.core.http.ServerWebSocket;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import org.jboss.logging.Logger;

public class JsonRpcRouter {
    private final Map<Integer, Cancellable> activeSubscriptions = new ConcurrentHashMap<Integer, Cancellable>();
    private Map<String, JsonRpcMethod> runtimeMethodsMap;
    private Map<String, JsonRpcMethod> runtimeSubscriptionMap;
    private Map<String, JsonRpcMethod> deploymentMethodsMap;
    private Map<String, JsonRpcMethod> deploymentSubscriptionsMap;
    private Map<String, JsonRpcMethod> recordedMethodsMap;
    private Map<String, JsonRpcMethod> recordedSubscriptionsMap;
    private static final List<JsonRpcResponseWriter> SESSIONS = Collections.synchronizedList(new ArrayList());
    private JsonRpcCodec codec;
    @Inject
    Logger logger;
    private static final String UNSUBSCRIBE = "unsubscribe";

    @Produces
    @DefaultBean
    public Optional<Assistant> defaultAssistant() {
        return Optional.empty();
    }

    public void populateJsonRpcEndpoints(Map<String, JsonRpcMethod> runtimeMethods, Map<String, JsonRpcMethod> runtimeSubscriptions, Map<String, JsonRpcMethod> deploymentMethods, Map<String, JsonRpcMethod> deploymentSubscriptions, Map<String, JsonRpcMethod> recordedMethods, Map<String, JsonRpcMethod> recordedSubscriptions) {
        this.runtimeMethodsMap = this.enhanceRuntimeJsonRpcEndpoints(runtimeMethods);
        this.runtimeSubscriptionMap = this.enhanceRuntimeJsonRpcEndpoints(runtimeSubscriptions);
        this.deploymentMethodsMap = deploymentMethods;
        this.deploymentSubscriptionsMap = deploymentSubscriptions;
        this.recordedMethodsMap = recordedMethods;
        this.recordedSubscriptionsMap = recordedSubscriptions;
    }

    public void initializeCodec(JsonMapper jsonMapper) {
        this.codec = new JsonRpcCodec(jsonMapper);
    }

    public void addSocket(ServerWebSocket socket) {
        JavaScriptResponseWriter writer = new JavaScriptResponseWriter(socket);
        SESSIONS.add(writer);
        socket.textMessageHandler(e -> {
            JsonRpcRequest jsonRpcRequest = this.codec.readRequest((String)e);
            this.route(jsonRpcRequest, writer);
        }).closeHandler(e -> this.purge());
        this.purge();
    }

    @Produces
    public JsonRpcCodec getJsonRpcCodec() {
        return this.codec;
    }

    public Map<String, JsonRpcMethod> getRuntimeMethodsMap() {
        return this.runtimeMethodsMap;
    }

    public Map<String, JsonRpcMethod> getRuntimeSubscriptionMap() {
        return this.runtimeSubscriptionMap;
    }

    public Map<String, JsonRpcMethod> getDeploymentMethodsMap() {
        return this.deploymentMethodsMap;
    }

    public Map<String, JsonRpcMethod> getDeploymentSubscriptionsMap() {
        return this.deploymentSubscriptionsMap;
    }

    public Map<String, JsonRpcMethod> getRecordedMethodsMap() {
        return this.recordedMethodsMap;
    }

    public Map<String, JsonRpcMethod> getRecordedSubscriptionsMap() {
        return this.recordedSubscriptionsMap;
    }

    void onStart(@Observes StartupEvent ev) {
        this.purge();
        for (JsonRpcResponseWriter jrrw : new ArrayList<JsonRpcResponseWriter>(SESSIONS)) {
            if (jrrw.isClosed()) continue;
            this.codec.writeResponse(jrrw, -1, LocalDateTime.now().toString(), MessageType.HotReload);
        }
    }

    private void purge() {
        SESSIONS.removeIf(JsonRpcResponseWriter::isClosed);
    }

    public void route(JsonRpcRequest jsonRpcRequest, JsonRpcResponseWriter jrrw) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        if (jsonRpcMethodName.equalsIgnoreCase(UNSUBSCRIBE)) {
            this.routeToDevUIUnsubscribe(jsonRpcRequest, jrrw);
        } else if (this.runtimeMethodsMap.containsKey(jsonRpcMethodName)) {
            this.routeToRuntimeMethod(jsonRpcRequest, jrrw);
        } else if (this.runtimeSubscriptionMap.containsKey(jsonRpcMethodName)) {
            this.routeToRuntimeSubscription(jsonRpcRequest, jrrw);
        } else if (this.deploymentMethodsMap.containsKey(jsonRpcMethodName) || this.deploymentSubscriptionsMap.containsKey(jsonRpcMethodName) || this.recordedMethodsMap.containsKey(jsonRpcMethodName) || this.recordedSubscriptionsMap.containsKey(jsonRpcMethodName)) {
            this.routeToDeployment(jsonRpcRequest, jrrw);
        } else {
            this.codec.writeMethodNotFoundResponse(jrrw, jsonRpcRequest.getId(), jsonRpcMethodName);
        }
    }

    private void routeToDevUIUnsubscribe(JsonRpcRequest jsonRpcRequest, JsonRpcResponseWriter jrrw) {
        if (this.activeSubscriptions.containsKey(jsonRpcRequest.getId())) {
            Cancellable cancellable = this.activeSubscriptions.remove(jsonRpcRequest.getId());
            cancellable.cancel();
        }
        this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), null, MessageType.Void);
    }

    private void routeToRuntimeMethod(JsonRpcRequest jsonRpcRequest, JsonRpcResponseWriter jrrw) {
        Uni<?> uni;
        JsonRpcMethod runtimeJsonRpcMethod = this.runtimeMethodsMap.get(jsonRpcRequest.getMethod());
        Object target = Arc.container().select(runtimeJsonRpcMethod.getBean(), new Annotation[0]).get();
        try {
            Object[] args = new Object[]{};
            if (jsonRpcRequest.hasParams()) {
                args = this.getArgsAsObjects(runtimeJsonRpcMethod.getParameters(), jsonRpcRequest);
            }
            uni = this.invoke(runtimeJsonRpcMethod, target, args);
        }
        catch (Exception e) {
            this.logger.errorf((Throwable)e, "Unable to invoke method %s using JSON-RPC, request was: %s", (Object)jsonRpcRequest.getMethod(), (Object)jsonRpcRequest);
            this.codec.writeErrorResponse(jrrw, jsonRpcRequest.getId(), jsonRpcRequest.getMethod(), e);
            return;
        }
        uni.subscribe().with(item -> {
            if (item != null && Map.class.isAssignableFrom(item.getClass())) {
                Map map = (Map)item;
                if (map.size() == 3 && map.containsKey("alreadySerialized") && map.containsKey("messageType") && map.containsKey("response") && map.get("alreadySerialized").equals("true")) {
                    Object response = map.get("response");
                    jrrw.write("{\"id\":" + jsonRpcRequest.getId() + ",\"result\":{\"messageType\":\"" + String.valueOf(map.get("messageType")) + "\",\"object\":" + String.valueOf(response) + "}}");
                } else {
                    this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), item, MessageType.Response);
                }
            } else {
                this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), item, MessageType.Response);
            }
        }, failure -> {
            Throwable patt0$temp;
            Throwable actualFailure;
            if (failure instanceof InvocationTargetException) {
                InvocationTargetException f = (InvocationTargetException)failure;
                actualFailure = f.getTargetException();
            } else if (failure.getCause() != null && (patt0$temp = failure.getCause()) instanceof InvocationTargetException) {
                InvocationTargetException f = (InvocationTargetException)patt0$temp;
                actualFailure = f.getTargetException();
            } else {
                actualFailure = failure;
            }
            this.codec.writeErrorResponse(jrrw, jsonRpcRequest.getId(), jsonRpcRequest.getMethod(), actualFailure);
        });
    }

    private void routeToRuntimeSubscription(JsonRpcRequest jsonRpcRequest, JsonRpcResponseWriter jrrw) {
        Multi multi;
        JsonRpcMethod runtimeJsonRpcSubscription = this.runtimeSubscriptionMap.get(jsonRpcRequest.getMethod());
        Object target = Arc.container().select(runtimeJsonRpcSubscription.getBean(), new Annotation[0]).get();
        if (this.activeSubscriptions.containsKey(jsonRpcRequest.getId())) {
            Cancellable cancellable = this.activeSubscriptions.remove(jsonRpcRequest.getId());
            cancellable.cancel();
        }
        try {
            if (jsonRpcRequest.hasParams()) {
                Object[] args = this.getArgsAsObjects(runtimeJsonRpcSubscription.getParameters(), jsonRpcRequest);
                multi = (Multi)runtimeJsonRpcSubscription.getJavaMethod().invoke(target, args);
            } else {
                multi = (Multi)runtimeJsonRpcSubscription.getJavaMethod().invoke(target, new Object[0]);
            }
        }
        catch (Exception e) {
            this.logger.errorf((Throwable)e, "Unable to invoke method %s using JSON-RPC, request was: %s", (Object)jsonRpcRequest.getMethod(), (Object)jsonRpcRequest);
            this.codec.writeErrorResponse(jrrw, jsonRpcRequest.getId(), jsonRpcRequest.getMethod(), e);
            return;
        }
        Cancellable cancellable = multi.subscribe().with(item -> this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), item, MessageType.SubscriptionMessage), failure -> {
            this.codec.writeErrorResponse(jrrw, jsonRpcRequest.getId(), jsonRpcRequest.getMethod(), (Throwable)failure);
            this.activeSubscriptions.remove(jsonRpcRequest.getId());
        }, () -> this.activeSubscriptions.remove(jsonRpcRequest.getId()));
        this.activeSubscriptions.put(jsonRpcRequest.getId(), cancellable);
        this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), null, MessageType.Void);
    }

    private void routeToDeployment(JsonRpcRequest jsonRpcRequest, JsonRpcResponseWriter jrrw) {
        String jsonRpcMethodName = jsonRpcRequest.getMethod();
        if (this.activeSubscriptions.containsKey(jsonRpcRequest.getId())) {
            Cancellable cancellable = this.activeSubscriptions.remove(jsonRpcRequest.getId());
            cancellable.cancel();
        }
        Object returnedObject = null;
        returnedObject = this.recordedMethodsMap.containsKey(jsonRpcMethodName) ? this.recordedMethodsMap.get(jsonRpcMethodName).getRuntimeValue().getValue() : (this.recordedSubscriptionsMap.containsKey(jsonRpcMethodName) ? this.recordedSubscriptionsMap.get(jsonRpcMethodName).getRuntimeValue().getValue() : DevConsoleManager.invoke((String)jsonRpcMethodName, this.getArgsAsMap(jsonRpcRequest)));
        if (returnedObject != null) {
            if (returnedObject instanceof Flow.Publisher) {
                Flow.Publisher publisher = (Flow.Publisher)returnedObject;
                Cancellable cancellable = Multi.createFrom().publisher(publisher).subscribe().with(item -> this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), item, MessageType.SubscriptionMessage), failure -> {
                    this.codec.writeErrorResponse(jrrw, jsonRpcRequest.getId(), jsonRpcMethodName, (Throwable)failure);
                    this.activeSubscriptions.remove(jsonRpcRequest.getId());
                }, () -> this.activeSubscriptions.remove(jsonRpcRequest.getId()));
                this.activeSubscriptions.put(jsonRpcRequest.getId(), cancellable);
                this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), null, MessageType.Void);
            } else if (returnedObject instanceof CompletionStage) {
                CompletionStage future = (CompletionStage)returnedObject;
                future.thenAccept(r -> this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), r, MessageType.Response)).exceptionally(throwable -> {
                    this.codec.writeErrorResponse(jrrw, jsonRpcRequest.getId(), jsonRpcMethodName, (Throwable)throwable);
                    return null;
                });
            } else {
                this.codec.writeResponse(jrrw, jsonRpcRequest.getId(), returnedObject, MessageType.Response);
            }
        }
    }

    private Uni<?> invoke(JsonRpcMethod runtimeJsonRpcMethod, Object target, Object[] args) {
        Uni uni;
        if (runtimeJsonRpcMethod.isReturningUni()) {
            try {
                uni = (Uni)runtimeJsonRpcMethod.getJavaMethod().invoke(target, args);
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        } else if (runtimeJsonRpcMethod.isReturningCompletableFuture() || runtimeJsonRpcMethod.isReturningCompletionStage()) {
            try {
                uni = Uni.createFrom().completionStage((CompletionStage)runtimeJsonRpcMethod.getJavaMethod().invoke(target, args));
            }
            catch (Exception e) {
                return Uni.createFrom().failure((Throwable)e);
            }
        } else {
            uni = Uni.createFrom().item(Unchecked.supplier(() -> runtimeJsonRpcMethod.getJavaMethod().invoke(target, args)));
        }
        if (!runtimeJsonRpcMethod.isIsExplicitlyNonBlocking()) {
            return uni.runSubscriptionOn(Infrastructure.getDefaultExecutor());
        }
        return uni;
    }

    private Object[] getArgsAsObjects(Map<String, JsonRpcMethod.Parameter> parameters, JsonRpcRequest jsonRpcRequest) {
        ArrayList objects = new ArrayList();
        for (Map.Entry<String, JsonRpcMethod.Parameter> expectedParams : parameters.entrySet()) {
            String paramName = expectedParams.getKey();
            Class<?> paramType = expectedParams.getValue().getType();
            Object param = jsonRpcRequest.getParam(paramName, paramType);
            objects.add(param);
        }
        return objects.toArray(Object[]::new);
    }

    private Map<String, String> getArgsAsMap(JsonRpcRequest jsonRpcRequest) {
        if (jsonRpcRequest.hasParams()) {
            return jsonRpcRequest.getParams();
        }
        return Map.of();
    }

    public JsonMapper getJsonMapper() {
        return this.codec.getJsonMapper();
    }

    private Map<String, JsonRpcMethod> enhanceRuntimeJsonRpcEndpoints(Map<String, JsonRpcMethod> runtimeMethods) {
        for (Map.Entry<String, JsonRpcMethod> method : runtimeMethods.entrySet()) {
            JsonRpcMethod jsonRpcMethod = method.getValue();
            Object providerInstance = Arc.container().select(jsonRpcMethod.getBean(), new Annotation[0]).get();
            try {
                Method javaMethod;
                if (jsonRpcMethod.hasParameters()) {
                    Class[] types = (Class[])jsonRpcMethod.getParameters().values().stream().map(p -> p.getType()).toArray(Class[]::new);
                    javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getJavaMethodName(), types);
                } else {
                    javaMethod = providerInstance.getClass().getMethod(jsonRpcMethod.getJavaMethodName(), new Class[0]);
                }
                jsonRpcMethod.setJavaMethod(javaMethod);
            }
            catch (NoSuchMethodException | SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }
        return runtimeMethods;
    }
}

