/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.discovery;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.Extension;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class DiscoveryRootElement {
    private final Extension extension;
    private final String binaryName;
    private final String qualifiedName;
    private final Map<String, DiscoveryConfigProperty> properties = new LinkedHashMap<String, DiscoveryConfigProperty>();
    @Deprecated(forRemoval=true)
    private final boolean configMapping;

    DiscoveryRootElement(Extension extension, String binaryName, String qualifiedName, boolean configMapping) {
        this.extension = extension;
        this.binaryName = binaryName;
        this.qualifiedName = qualifiedName;
        this.configMapping = configMapping;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public String getBinaryName() {
        return this.binaryName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void addProperty(DiscoveryConfigProperty discoveryConfigProperty) {
        this.properties.put(discoveryConfigProperty.getSourceElementName(), discoveryConfigProperty);
    }

    public Map<String, DiscoveryConfigProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Deprecated(forRemoval=true)
    public boolean isConfigMapping() {
        return this.configMapping;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix + "binaryName = " + this.binaryName);
        if (!this.properties.isEmpty()) {
            sb.append("\n\n" + prefix + "--- Properties ---\n\n");
            for (DiscoveryConfigProperty property : this.properties.values()) {
                sb.append(property.toString(prefix) + prefix + "--\n");
            }
        }
        return sb.toString();
    }
}

