/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.merger;

import io.quarkus.annotation.processor.documentation.config.merger.JavadocRepository;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.util.JacksonMappers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.TreeMap;

public final class JavadocMerger {
    private JavadocMerger() {
    }

    public static JavadocRepository mergeJavadocElements(List<Path> buildOutputDirectories) {
        TreeMap<String, JavadocElements.JavadocElement> javadocElementsMap = new TreeMap<String, JavadocElements.JavadocElement>();
        for (Path buildOutputDirectory : buildOutputDirectories) {
            Path javadocPath = buildOutputDirectory.resolve("quarkus-config-doc/quarkus-config-javadoc.yaml");
            if (!Files.isReadable(javadocPath)) continue;
            try {
                InputStream javadocIs = Files.newInputStream(javadocPath, new OpenOption[0]);
                try {
                    JavadocElements javadocElements = (JavadocElements)JacksonMappers.yamlObjectReader().readValue(javadocIs, JavadocElements.class);
                    if (javadocElements.elements() == null || javadocElements.elements().isEmpty()) continue;
                    javadocElementsMap.putAll(javadocElements.elements());
                }
                finally {
                    if (javadocIs == null) continue;
                    javadocIs.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to parse: " + String.valueOf(javadocPath), e);
            }
        }
        return new JavadocRepository(javadocElementsMap);
    }
}

