/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.protoc.plugin;

import com.google.common.base.Strings;
import com.google.common.html.HtmlEscapers;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.Generator;
import com.salesforce.jprotoc.GeneratorException;
import com.salesforce.jprotoc.ProtoTypeMap;
import com.salesforce.jprotoc.ProtocPlugin;
import io.smallrye.common.annotation.SuppressForbidden;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@SuppressForbidden(reason="It is fine to use java.util.logging")
public class MutinyGrpcGenerator
extends Generator {
    private static final Logger log = Logger.getLogger(MutinyGrpcGenerator.class.getName());
    private static final int SERVICE_NUMBER_OF_PATHS = 2;
    private static final int METHOD_NUMBER_OF_PATHS = 4;
    public static final String CLASS_PREFIX = "Mutiny";

    private String getServiceJavaDocPrefix() {
        return "    ";
    }

    private String getMethodJavaDocPrefix() {
        return "        ";
    }

    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_PROTO3_OPTIONAL);
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        ProtoTypeMap typeMap = ProtoTypeMap.of((Collection)request.getProtoFileList());
        List<DescriptorProtos.FileDescriptorProto> protosToGenerate = request.getProtoFileList().stream().filter(protoFile -> request.getFileToGenerateList().contains((Object)protoFile.getName())).collect(Collectors.toList());
        List<ServiceContext> services = this.findServices(protosToGenerate, typeMap);
        this.validateServices(services);
        return this.generateFiles(services);
    }

    private void validateServices(List<ServiceContext> services) {
        boolean failed = false;
        for (ServiceContext service : services) {
            if (service.packageName != null && !service.packageName.isBlank()) continue;
            log.log(Level.SEVERE, "Using the default java package is not supported for Quarkus gRPC code generation. Please specify `option java_package = \"your.package\"` in " + service.protoName);
            failed = true;
        }
        if (failed) {
            throw new IllegalArgumentException("Code generation failed. Please check the log above for details.");
        }
    }

    private List<ServiceContext> findServices(List<DescriptorProtos.FileDescriptorProto> protos, ProtoTypeMap typeMap) {
        ArrayList<ServiceContext> contexts = new ArrayList<ServiceContext>();
        protos.forEach(fileProto -> {
            for (int serviceNumber = 0; serviceNumber < fileProto.getServiceCount(); ++serviceNumber) {
                ServiceContext serviceContext = this.buildServiceContext(fileProto.getService(serviceNumber), typeMap, fileProto.getSourceCodeInfo().getLocationList(), serviceNumber);
                serviceContext.protoName = fileProto.getName();
                serviceContext.packageName = this.extractPackageName((DescriptorProtos.FileDescriptorProto)fileProto);
                contexts.add(serviceContext);
            }
        });
        return contexts;
    }

    private String extractPackageName(DescriptorProtos.FileDescriptorProto proto) {
        String javaPackage;
        DescriptorProtos.FileOptions options = proto.getOptions();
        if (options != null && !Strings.isNullOrEmpty((String)(javaPackage = options.getJavaPackage()))) {
            return javaPackage;
        }
        return Strings.nullToEmpty((String)proto.getPackage());
    }

    private ServiceContext buildServiceContext(DescriptorProtos.ServiceDescriptorProto serviceProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int serviceNumber) {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.classPrefix = CLASS_PREFIX;
        serviceContext.fileName = CLASS_PREFIX + serviceProto.getName() + "Grpc.java";
        serviceContext.className = CLASS_PREFIX + serviceProto.getName() + "Grpc";
        serviceContext.serviceName = serviceProto.getName();
        serviceContext.deprecated = serviceProto.getOptions() != null && serviceProto.getOptions().getDeprecated();
        List allLocationsForService = locations.stream().filter(location -> location.getPathCount() >= 2 && location.getPath(0) == 6 && location.getPath(1) == serviceNumber).collect(Collectors.toList());
        DescriptorProtos.SourceCodeInfo.Location serviceLocation = allLocationsForService.stream().filter(location -> location.getPathCount() == 2).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        serviceContext.javaDoc = this.getJavaDoc(this.getComments(serviceLocation), this.getServiceJavaDocPrefix());
        for (int methodNumber = 0; methodNumber < serviceProto.getMethodCount(); ++methodNumber) {
            MethodContext methodContext = this.buildMethodContext(serviceProto.getMethod(methodNumber), typeMap, locations, methodNumber);
            serviceContext.methods.add(methodContext);
        }
        return serviceContext;
    }

    private MethodContext buildMethodContext(DescriptorProtos.MethodDescriptorProto methodProto, ProtoTypeMap typeMap, List<DescriptorProtos.SourceCodeInfo.Location> locations, int methodNumber) {
        MethodContext methodContext = new MethodContext();
        methodContext.methodName = MutinyGrpcGenerator.adaptMethodName(methodProto.getName());
        methodContext.inputType = typeMap.toJavaTypeName(methodProto.getInputType());
        methodContext.outputType = typeMap.toJavaTypeName(methodProto.getOutputType());
        methodContext.deprecated = methodProto.getOptions() != null && methodProto.getOptions().getDeprecated();
        methodContext.isManyInput = methodProto.getClientStreaming();
        methodContext.isManyOutput = methodProto.getServerStreaming();
        methodContext.methodNumber = methodNumber;
        DescriptorProtos.SourceCodeInfo.Location methodLocation = locations.stream().filter(location -> location.getPathCount() == 4 && location.getPath(3) == methodNumber).findFirst().orElseGet(DescriptorProtos.SourceCodeInfo.Location::getDefaultInstance);
        methodContext.javaDoc = this.getJavaDoc(this.getComments(methodLocation), this.getMethodJavaDocPrefix());
        if (!methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "oneToOne";
            methodContext.grpcCallsMethodName = "asyncUnaryCall";
        }
        if (!methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "oneToMany";
            methodContext.grpcCallsMethodName = "asyncServerStreamingCall";
        }
        if (methodProto.getClientStreaming() && !methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "manyToOne";
            methodContext.grpcCallsMethodName = "asyncClientStreamingCall";
        }
        if (methodProto.getClientStreaming() && methodProto.getServerStreaming()) {
            methodContext.mutinyCallsMethodName = "manyToMany";
            methodContext.grpcCallsMethodName = "asyncBidiStreamingCall";
        }
        return methodContext;
    }

    static String adaptMethodName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        StringBuilder ret = new StringBuilder();
        ret.append(Character.toLowerCase(name.charAt(0)));
        if (name.length() > 1) {
            if (name.contains("_")) {
                for (String str : name.substring(1).split("_")) {
                    if (ret.length() == 1) {
                        ret.append(str);
                        continue;
                    }
                    ret.append(Character.toUpperCase(str.charAt(0)));
                    if (str.length() <= 1) continue;
                    ret.append(str.substring(1));
                }
            } else {
                ret.append(name.substring(1));
            }
            if (MutinyGrpcGenerator.isJavaKeyword(ret.toString())) {
                ret.append("_");
            }
        }
        return ret.toString();
    }

    private static boolean isJavaKeyword(String value) {
        switch (value) {
            case "public": 
            case "protected": 
            case "private": 
            case "abstract": 
            case "static": 
            case "final": 
            case "transient": 
            case "volatile": 
            case "synchronized": 
            case "native": 
            case "class": 
            case "interface": 
            case "extends": 
            case "package": 
            case "throws": 
            case "implements": 
            case "boolean": 
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": 
            case "void": 
            case "if": 
            case "else": 
            case "try": 
            case "catch": 
            case "finally": 
            case "do": 
            case "while": 
            case "for": 
            case "continue": 
            case "switch": 
            case "case": 
            case "default": 
            case "break": 
            case "throw": 
            case "return": 
            case "this": 
            case "new": 
            case "super": 
            case "import": 
            case "instanceof": 
            case "goto": 
            case "const": 
            case "null": 
            case "true": 
            case "false": {
                return true;
            }
        }
        return false;
    }

    private List<PluginProtos.CodeGeneratorResponse.File> generateFiles(List<ServiceContext> services) {
        ArrayList<PluginProtos.CodeGeneratorResponse.File> files = new ArrayList<PluginProtos.CodeGeneratorResponse.File>();
        for (ServiceContext service : services) {
            files.add(this.buildFile(service, "MutinyStub.mustache", this.absoluteFileName(service, null)));
            files.add(this.buildFile(service, "MutinyInterface.mustache", this.absoluteFileName(service, service.serviceName + ".java")));
            files.add(this.buildFile(service, "MutinyBean.mustache", this.absoluteFileName(service, service.serviceName + "Bean.java")));
            files.add(this.buildFile(service, "MutinyClient.mustache", this.absoluteFileName(service, service.serviceName + "Client.java")));
        }
        return files;
    }

    private PluginProtos.CodeGeneratorResponse.File buildFile(ServiceContext context, String templateName, String fileName) {
        String content = this.applyTemplate(templateName, context);
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(fileName).setContent(content).build();
    }

    private String absoluteFileName(ServiceContext ctx, String fileName) {
        String dir;
        if (fileName == null) {
            fileName = ctx.fileName;
        }
        if (Strings.isNullOrEmpty((String)(dir = ctx.packageName.replace('.', '/')))) {
            return fileName;
        }
        return dir + "/" + fileName;
    }

    private String getComments(DescriptorProtos.SourceCodeInfo.Location location) {
        return location.getLeadingComments().isEmpty() ? location.getTrailingComments() : location.getLeadingComments();
    }

    private String getJavaDoc(String comments, String prefix) {
        if (!comments.isEmpty()) {
            StringBuilder builder = new StringBuilder("/**\n").append(prefix).append(" * <pre>\n");
            Arrays.stream(HtmlEscapers.htmlEscaper().escape(comments).split("\n")).map(line -> line.replace("*/", "&#42;&#47;").replace("*", "&#42;")).forEach(line -> builder.append(prefix).append(" * ").append((String)line).append("\n"));
            builder.append(prefix).append(" * </pre>\n").append(prefix).append(" */");
            return builder.toString();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            ProtocPlugin.generate((Generator)new MutinyGrpcGenerator());
        } else {
            ProtocPlugin.debug((Generator)new MutinyGrpcGenerator(), (String)args[0]);
        }
    }

    private static class ServiceContext {
        public String fileName;
        public String protoName;
        public String packageName;
        public String className;
        public String classPrefix;
        public String serviceName;
        public boolean deprecated;
        public String javaDoc;
        public List<MethodContext> methods = new ArrayList<MethodContext>();

        private ServiceContext() {
        }

        public List<MethodContext> unaryUnaryMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> unaryManyMethods() {
            return this.methods.stream().filter(m -> !m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyUnaryMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && !m.isManyOutput).collect(Collectors.toList());
        }

        public List<MethodContext> manyManyMethods() {
            return this.methods.stream().filter(m -> m.isManyInput && m.isManyOutput).collect(Collectors.toList());
        }
    }

    private static class MethodContext {
        public String methodName;
        public String inputType;
        public String outputType;
        public boolean deprecated;
        public boolean isManyInput;
        public boolean isManyOutput;
        public String mutinyCallsMethodName;
        public String grpcCallsMethodName;
        public int methodNumber;
        public String javaDoc;

        private MethodContext() {
        }

        public String methodNameUpperUnderscore() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.methodName.length(); ++i) {
                char c = this.methodName.charAt(i);
                s.append(Character.toUpperCase(c));
                if (i >= this.methodName.length() - 1 || !Character.isLowerCase(c) || !Character.isUpperCase(this.methodName.charAt(i + 1))) continue;
                s.append('_');
            }
            return s.toString();
        }

        public String methodNamePascalCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toUpperCase(mn.charAt(0))) + mn.substring(1);
        }

        public String methodNameCamelCase() {
            String mn = this.methodName.replace("_", "");
            return String.valueOf(Character.toLowerCase(mn.charAt(0))) + mn.substring(1);
        }

        public String methodHeader() {
            Object mh = "";
            if (!Strings.isNullOrEmpty((String)this.javaDoc)) {
                mh = this.javaDoc;
            }
            if (this.deprecated) {
                mh = (String)mh + "\n        @Deprecated";
            }
            return mh;
        }
    }
}

