/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.rest.client.reactive.jackson.deployment;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.rest.client.reactive.deployment.AnnotationToRegisterIntoClientContextBuildItem;
import io.quarkus.rest.client.reactive.jackson.ClientObjectMapper;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ClientJacksonMessageBodyReader;
import io.quarkus.rest.client.reactive.jackson.runtime.serialisers.ClientJacksonMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.common.deployment.processor.ResteasyReactiveJacksonProviderDefinedBuildItem;
import io.quarkus.resteasy.reactive.jackson.common.runtime.serialisers.vertx.VertxJsonArrayBasicMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.common.runtime.serialisers.vertx.VertxJsonArrayBasicMessageBodyWriter;
import io.quarkus.resteasy.reactive.jackson.common.runtime.serialisers.vertx.VertxJsonObjectBasicMessageBodyReader;
import io.quarkus.resteasy.reactive.jackson.common.runtime.serialisers.vertx.VertxJsonObjectBasicMessageBodyWriter;
import io.quarkus.resteasy.reactive.spi.MessageBodyReaderBuildItem;
import io.quarkus.resteasy.reactive.spi.MessageBodyWriterBuildItem;
import io.quarkus.vertx.deployment.ReinitializeVertxJsonBuildItem;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.ws.rs.RuntimeType;
import java.util.Collections;
import java.util.List;
import org.jboss.jandex.DotName;

public class RestClientReactiveJacksonProcessor {
    private static final List<String> HANDLED_WRITE_MEDIA_TYPES = Collections.singletonList("application/json");
    private static final List<String> HANDLED_READ_MEDIA_TYPES = List.of("application/json", "application/x-ndjson", "application/stream+json");

    @BuildStep
    void feature(BuildProducer<FeatureBuildItem> features) {
        features.produce((BuildItem)new FeatureBuildItem(Feature.REST_CLIENT_JACKSON));
    }

    @BuildStep
    ReinitializeVertxJsonBuildItem vertxJson() {
        return new ReinitializeVertxJsonBuildItem();
    }

    @BuildStep
    void additionalProviders(BuildProducer<AnnotationToRegisterIntoClientContextBuildItem> annotation) {
        annotation.produce((BuildItem)new AnnotationToRegisterIntoClientContextBuildItem(DotName.createSimple(ClientObjectMapper.class), ObjectMapper.class));
    }

    @BuildStep
    void additionalProviders(List<ResteasyReactiveJacksonProviderDefinedBuildItem> jacksonProviderDefined, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<MessageBodyReaderBuildItem> additionalReaders, BuildProducer<MessageBodyWriterBuildItem> additionalWriters) {
        additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(ClientJacksonMessageBodyReader.class.getName()).addBeanClass(ClientJacksonMessageBodyWriter.class.getName()).setUnremovable().build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(ClientJacksonMessageBodyReader.class.getName(), Object.class.getName()).setMediaTypeStrings(HANDLED_READ_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.CLIENT).build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(VertxJsonArrayBasicMessageBodyReader.class.getName(), JsonArray.class.getName()).setMediaTypeStrings(HANDLED_READ_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.CLIENT).build());
        additionalReaders.produce((BuildItem)new MessageBodyReaderBuildItem.Builder(VertxJsonObjectBasicMessageBodyReader.class.getName(), JsonObject.class.getName()).setMediaTypeStrings(HANDLED_READ_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.CLIENT).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(ClientJacksonMessageBodyWriter.class.getName(), Object.class.getName()).setMediaTypeStrings(HANDLED_WRITE_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.CLIENT).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(VertxJsonArrayBasicMessageBodyWriter.class.getName(), JsonArray.class.getName()).setMediaTypeStrings(HANDLED_WRITE_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.CLIENT).build());
        additionalWriters.produce((BuildItem)new MessageBodyWriterBuildItem.Builder(VertxJsonObjectBasicMessageBodyWriter.class.getName(), JsonObject.class.getName()).setMediaTypeStrings(HANDLED_WRITE_MEDIA_TYPES).setBuiltin(true).setRuntimeType(RuntimeType.CLIENT).build());
    }
}

