/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.runtime.dev.ui;

import io.quarkus.resteasy.reactive.server.runtime.ResteasyReactiveRecorder;
import io.smallrye.common.annotation.NonBlocking;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.ws.rs.core.MediaType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.model.ResourceParamConverterProvider;
import org.jboss.resteasy.reactive.server.core.RuntimeExceptionMapper;
import org.jboss.resteasy.reactive.server.util.ScoreSystem;

public class ResteasyReactiveJsonRPCService {
    @NonBlocking
    public JsonObject getEndpointScores() {
        JsonObject endpointScore = new JsonObject();
        ScoreSystem.EndpointScores result = ScoreSystem.latestScores;
        if (result != null) {
            endpointScore.put("score", (Object)result.score);
            JsonArray endpoints = new JsonArray();
            for (ScoreSystem.EndpointScore endpoint : result.endpoints) {
                JsonObject e = new JsonObject();
                e.put("className", (Object)endpoint.className);
                e.put("httpMethod", (Object)endpoint.httpMethod);
                e.put("fullPath", (Object)endpoint.fullPath);
                e.put("producesHeaders", endpoint.produces.stream().map(MediaType::toString).collect(Collectors.toList()));
                e.put("consumesHeaders", endpoint.consumes.stream().map(MediaType::toString).collect(Collectors.toList()));
                JsonObject diagnostics = new JsonObject();
                TreeMap sortedDiagnostics = new TreeMap(endpoint.diagnostics);
                for (Map.Entry diagnostic : sortedDiagnostics.entrySet()) {
                    JsonArray diagnosticValues = new JsonArray();
                    for (ScoreSystem.Diagnostic value : (List)diagnostic.getValue()) {
                        JsonObject diagnosticValue = new JsonObject();
                        diagnosticValue.put("message", (Object)value.message);
                        diagnosticValue.put("score", (Object)value.score);
                        diagnosticValues.add((Object)diagnosticValue);
                    }
                    diagnostics.put(((ScoreSystem.Category)diagnostic.getKey()).name(), (Object)diagnosticValues);
                }
                e.put("diagnostics", (Object)diagnostics);
                e.put("requestFilterEntries", endpoint.requestFilterEntries.stream().map(ScoreSystem.RequestFilterEntry::getName).collect(Collectors.toList()));
                e.put("score", (Object)endpoint.score);
                endpoints.add((Object)e);
            }
            endpointScore.put("endpoints", (Object)endpoints);
        } else {
            endpointScore.put("score", (Object)0);
        }
        return endpointScore;
    }

    @NonBlocking
    public JsonArray getExceptionMappers() {
        JsonArray all = new JsonArray();
        Map mappers = RuntimeExceptionMapper.getMappers();
        for (Map.Entry entry : mappers.entrySet()) {
            JsonObject m = new JsonObject();
            m.put("name", (Object)((Class)entry.getKey()).getName());
            m.put("className", (Object)((ResourceExceptionMapper)entry.getValue()).getClassName());
            m.put("priority", (Object)((ResourceExceptionMapper)entry.getValue()).getPriority());
            all.add((Object)m);
        }
        return all;
    }

    @NonBlocking
    public JsonArray getParamConverterProviders() {
        JsonArray all = new JsonArray();
        List providers = ResteasyReactiveRecorder.getCurrentDeployment().getParamConverterProviders().getParamConverterProviders();
        for (ResourceParamConverterProvider provider : providers) {
            JsonObject m = new JsonObject();
            m.put("className", (Object)provider.getClassName());
            m.put("priority", (Object)provider.getPriority());
            all.add((Object)m);
        }
        return all;
    }
}

