/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.test.utils;

import io.quarkus.security.test.utils.AuthData;
import io.quarkus.security.test.utils.IdentityMock;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class SecurityTestUtils {
    public static <T> void assertSuccess(Supplier<T> action, T expectedResult, AuthData ... auth) {
        for (AuthData authData : auth) {
            IdentityMock.setUpAuth(authData);
            Assertions.assertEquals(expectedResult, action.get());
        }
        if (auth.length == 0) {
            throw new IllegalStateException("No tests were executed as AuthData are missing");
        }
    }

    public static <T> void assertSuccess(Uni<T> action, final T expectedResult, AuthData authData) {
        IdentityMock.setUpAuth(authData);
        action.subscribe().with(new Consumer<T>(){

            @Override
            public void accept(T actual) {
                Assertions.assertEquals((Object)expectedResult, actual);
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                Assertions.fail((String)("Assertion failed with: " + throwable.getMessage()));
            }
        });
    }

    public static void assertFailureFor(Executable action, Class<? extends Exception> expectedException, AuthData ... auth) {
        for (AuthData authData : auth) {
            IdentityMock.setUpAuth(authData);
            Assertions.assertThrows(expectedException, (Executable)action);
        }
        if (auth.length == 0) {
            throw new IllegalStateException("No tests were executed as AuthData are missing");
        }
    }

    public static <T> void assertFailureFor(Uni<T> action, final Class<? extends Exception> expectedException, AuthData authData) {
        IdentityMock.setUpAuth(authData);
        action.subscribe().with(new Consumer<T>(){

            @Override
            public void accept(T actual) {
                Assertions.fail((String)String.format("Expected exception %s was never thrown", expectedException));
            }
        }, (Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable actual) {
                Assertions.assertEquals((Object)expectedException, actual.getClass());
            }
        });
    }

    private SecurityTestUtils() {
    }
}

