/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.dev;

import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.runtime.annotations.DevMCPEnableByDefault;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.quarkus.smallrye.openapi.runtime.OpenApiDocumentService;
import io.smallrye.openapi.runtime.io.Format;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class OpenApiJsonRpcService {
    @Inject
    Optional<Assistant> assistant;
    @Inject
    OpenApiDocumentService openApiDocumentService;
    private static final String USER_MESSAGE = "Given the OpenAPI Schema document :\n{{schemaDocument}}\nPlease generate a {{language}} Object that act as a client to all the operations in the schema.\nThis {{language}} code must be able to be called like this (pseudo code):\n```\nvar stub = new ResourceNameHereClient();\nvar response = stub.doOperation(someparam);\n```\n\nDon't use ResourceNameHereClient as the name for the generated code (it's just an example). Derive a sensible name from the schema provided.\nYour reponse should only contain one field called `code` that contains a value with only the {{language}} code, nothing else, no explanation, and do not put the code in backticks.\nThe {{language}} code must run and be valid.\nExample response: {code: 'package foo.bar; // more code here'}\n\n{{extraContext}}\n";

    @JsonRpcDescription(value="Get the running application's OpenAPI Schema Document in json format")
    @DevMCPEnableByDefault
    public String getOpenAPISchema() {
        return new String(this.openApiDocumentService.getDocument(Format.JSON));
    }

    public CompletionStage<Map<String, String>> generateClient(String language, String extraContext) {
        if (this.assistant.isPresent()) {
            String schemaDocument = this.getOpenAPISchema();
            return this.assistant.get().assistBuilder().userMessage(USER_MESSAGE).addVariable("schemaDocument", schemaDocument).addVariable("language", language).addVariable("extraContext", extraContext).assist();
        }
        return CompletableFuture.failedStage(new RuntimeException("Assistant is not available"));
    }
}

