/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.spring;

import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractParameterProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.spring.SpringConstants;
import io.smallrye.openapi.spring.SpringParameter;
import io.smallrye.openapi.spring.SpringSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class SpringParameterProcessor
extends AbstractParameterProcessor {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)\\}");

    SpringParameterProcessor(AnnotationScannerContext scannerContext, String contextPath, ClassInfo resourceClass, MethodInfo resourceMethod) {
        super(scannerContext, contextPath, resourceClass, resourceMethod);
    }

    public static ResourceParameters process(AnnotationScannerContext context, String contextPath, ClassInfo resourceClass, MethodInfo resourceMethod) {
        SpringParameterProcessor processor = new SpringParameterProcessor(context, contextPath, resourceClass, resourceMethod);
        return processor.process();
    }

    protected Pattern getTemplateParameterPattern() {
        return TEMPLATE_PARAM_PATTERN;
    }

    protected FrameworkParameter getMatrixParameter() {
        return SpringParameter.MATRIX_PARAM.parameter;
    }

    protected void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (this.isReadableParameterAnnotation(name)) {
            this.readParameterAnnotation(annotation, overriddenParametersOnly);
        } else {
            FrameworkParameter frameworkParam = SpringParameter.forName(name);
            if (frameworkParam != null) {
                this.readSpringParameter(frameworkParam, annotation, beanParamAnnotation, overriddenParametersOnly);
            }
        }
    }

    private void readSpringParameter(FrameworkParameter frameworkParam, AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        block4: {
            Type targetType;
            AnnotationTarget target;
            block6: {
                block5: {
                    block3: {
                        target = annotation.target();
                        targetType = this.getType(target);
                        if (frameworkParam.style != Parameter.Style.FORM) break block3;
                        this.formParams.put(SpringParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                        this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
                        break block4;
                    }
                    if (frameworkParam.style != Parameter.Style.MATRIX) break block5;
                    List pathSegments = beanParamAnnotation != null ? this.lastPathSegmentsOf(beanParamAnnotation.target()) : this.lastPathSegmentsOf(target);
                    for (String pathSegment : pathSegments) {
                        this.matrixParams.computeIfAbsent(pathSegment, k -> new HashMap()).put(SpringParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
                    }
                    break block4;
                }
                if (frameworkParam.location == null) break block6;
                this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
                break block4;
            }
            if (target == null || !SpringParameterProcessor.annotatesHttpGET(target)) break block4;
            this.setMediaType(frameworkParam);
            targetType = TypeUtil.unwrapType((Type)targetType);
            if (targetType != null) {
                ClassInfo beanParam = this.index.getClassByName(targetType.name());
                for (Map.Entry entry : TypeResolver.getAllFields((AnnotationScannerContext)this.scannerContext, (Type)targetType, (ClassInfo)beanParam, null).entrySet()) {
                    AnnotationInstance syntheticQuery = AnnotationInstance.builder((DotName)SpringConstants.QUERY_PARAM).buildWithTarget(((TypeResolver)entry.getValue()).getAnnotationTarget());
                    this.readAnnotatedType(syntheticQuery, beanParamAnnotation, overriddenParametersOnly);
                }
            }
        }
    }

    static boolean annotatesHttpGET(AnnotationTarget target) {
        MethodInfo resourceMethod = SpringParameterProcessor.targetMethod((AnnotationTarget)target);
        if (resourceMethod != null) {
            return SpringSupport.getHttpMethods(resourceMethod).contains(PathItem.HttpMethod.GET);
        }
        return false;
    }

    protected Set<DotName> getDefaultAnnotationNames() {
        return Collections.singleton(SpringConstants.QUERY_PARAM);
    }

    protected String getDefaultAnnotationProperty() {
        return "defaultValue";
    }

    protected List<String> pathsOf(AnnotationTarget target) {
        AnnotationInstance path = null;
        Set<DotName> paths = SpringConstants.HTTP_METHODS;
        for (DotName possiblePath : paths) {
            AnnotationInstance annotation = this.scannerContext.annotations().getAnnotation(target, new DotName[]{possiblePath});
            if (!SpringParameterProcessor.mappingHasPath(annotation)) continue;
            path = annotation;
        }
        AnnotationInstance annotation = this.scannerContext.annotations().getAnnotation(target, new DotName[]{SpringConstants.REQUEST_MAPPING});
        if (SpringParameterProcessor.mappingHasPath(annotation)) {
            path = annotation;
        }
        if (path != null) {
            List<String> pathValues = SpringParameterProcessor.requestMappingValuesToPath(path);
            return pathValues.stream().map(pathValue -> {
                if (pathValue.startsWith("/")) {
                    pathValue = pathValue.substring(1);
                }
                if (pathValue.endsWith("/")) {
                    pathValue = pathValue.substring(0, pathValue.length() - 1);
                }
                return pathValue;
            }).collect(Collectors.toList());
        }
        return List.of("");
    }

    static boolean mappingHasPath(AnnotationInstance mappingAnnotation) {
        return mappingAnnotation != null && (mappingAnnotation.value() != null || mappingAnnotation.value("path") != null);
    }

    static List<String> requestMappingValuesToPath(AnnotationInstance requestMappingAnnotation) {
        AnnotationValue value = SpringParameterProcessor.getRequestMappingPathAnnotation(requestMappingAnnotation);
        if (value == null) {
            return Collections.emptyList();
        }
        return List.of(value.asStringArray());
    }

    static AnnotationValue getRequestMappingPathAnnotation(AnnotationInstance requestMappingAnnotation) {
        AnnotationValue value = requestMappingAnnotation.value();
        if (value != null) {
            return value;
        }
        return requestMappingAnnotation.value("path");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSubResourceLocator(MethodInfo method) {
        if (method.returnType().kind() != Type.Kind.CLASS) return false;
        if (!this.isResourceMethod(method)) return false;
        if (!method.annotations().stream().map(AnnotationInstance::name).noneMatch(SpringConstants.HTTP_METHODS::contains)) return false;
        return true;
    }

    protected boolean isResourceMethod(MethodInfo method) {
        return method.annotations().stream().map(AnnotationInstance::name).anyMatch(SpringConstants.HTTP_METHODS::contains);
    }

    protected boolean isParameter(DotName annotationName) {
        if (SpringParameter.isParameter(annotationName)) {
            return true;
        }
        if (Names.PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return Names.PARAMETERS.equals((Object)annotationName);
    }
}

