/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth;

import io.stargate.auth.ImmutableAuthenticationSubject;
import io.stargate.db.AuthenticatedUser;
import io.stargate.db.ImmutableAuthenticatedUser;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@Value.Immutable
@Value.Style(builtinContainerAttributes=false)
public interface AuthenticationSubject {
    @Nullable
    @Value.Parameter
    public String token();

    @Value.Parameter
    public String roleName();

    @Value.Parameter
    public boolean isFromExternalAuth();

    @Value.Parameter
    public Map<String, String> customProperties();

    default public AuthenticatedUser asUser() {
        return ImmutableAuthenticatedUser.of((String)this.roleName(), (String)this.token(), (boolean)this.isFromExternalAuth(), this.customProperties());
    }

    public static AuthenticationSubject of(String token, String roleName, boolean fromExternalAuth, Map<String, String> properties) {
        return ImmutableAuthenticationSubject.of(token, roleName, fromExternalAuth, Collections.unmodifiableMap(properties));
    }

    public static AuthenticationSubject of(String token, String roleName, boolean fromExternalAuth) {
        return ImmutableAuthenticationSubject.of(token, roleName, fromExternalAuth, Collections.emptyMap());
    }

    public static AuthenticationSubject of(String token, String roleName) {
        return ImmutableAuthenticationSubject.of(token, roleName, false, Collections.emptyMap());
    }

    public static AuthenticationSubject of(AuthenticatedUser user) {
        return ImmutableAuthenticationSubject.of(user.token(), user.name(), user.isFromExternalAuth(), user.customProperties());
    }
}

