/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.auth.AuthenticationSubject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AuthenticationSubject", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAuthenticationSubject
implements AuthenticationSubject {
    @Nullable
    private final String token;
    private final String roleName;
    private final boolean isFromExternalAuth;
    private final Map<String, String> customProperties;

    private ImmutableAuthenticationSubject(@Nullable String token, String roleName, boolean isFromExternalAuth, Map<String, String> customProperties) {
        this.token = token;
        this.roleName = Objects.requireNonNull(roleName, "roleName");
        this.isFromExternalAuth = isFromExternalAuth;
        this.customProperties = Objects.requireNonNull(customProperties, "customProperties");
    }

    private ImmutableAuthenticationSubject(ImmutableAuthenticationSubject original, @Nullable String token, String roleName, boolean isFromExternalAuth, Map<String, String> customProperties) {
        this.token = token;
        this.roleName = roleName;
        this.isFromExternalAuth = isFromExternalAuth;
        this.customProperties = customProperties;
    }

    @Override
    @Nullable
    public String token() {
        return this.token;
    }

    @Override
    public String roleName() {
        return this.roleName;
    }

    @Override
    public boolean isFromExternalAuth() {
        return this.isFromExternalAuth;
    }

    @Override
    public Map<String, String> customProperties() {
        return this.customProperties;
    }

    public final ImmutableAuthenticationSubject withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableAuthenticationSubject(this, value, this.roleName, this.isFromExternalAuth, this.customProperties);
    }

    public final ImmutableAuthenticationSubject withRoleName(String value) {
        String newValue = Objects.requireNonNull(value, "roleName");
        if (this.roleName.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthenticationSubject(this, this.token, newValue, this.isFromExternalAuth, this.customProperties);
    }

    public final ImmutableAuthenticationSubject withIsFromExternalAuth(boolean value) {
        if (this.isFromExternalAuth == value) {
            return this;
        }
        return new ImmutableAuthenticationSubject(this, this.token, this.roleName, value, this.customProperties);
    }

    public final ImmutableAuthenticationSubject withCustomProperties(Map<String, String> value) {
        if (this.customProperties == value) {
            return this;
        }
        Map<String, String> newValue = Objects.requireNonNull(value, "customProperties");
        return new ImmutableAuthenticationSubject(this, this.token, this.roleName, this.isFromExternalAuth, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticationSubject && this.equalTo((ImmutableAuthenticationSubject)another);
    }

    private boolean equalTo(ImmutableAuthenticationSubject another) {
        return Objects.equals(this.token, another.token) && this.roleName.equals(another.roleName) && this.isFromExternalAuth == another.isFromExternalAuth && this.customProperties.equals(another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.token);
        h += (h << 5) + this.roleName.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isFromExternalAuth);
        h += (h << 5) + this.customProperties.hashCode();
        return h;
    }

    public String toString() {
        return "AuthenticationSubject{token=" + this.token + ", roleName=" + this.roleName + ", isFromExternalAuth=" + this.isFromExternalAuth + ", customProperties=" + this.customProperties + "}";
    }

    public static ImmutableAuthenticationSubject of(@Nullable String token, String roleName, boolean isFromExternalAuth, Map<String, String> customProperties) {
        return new ImmutableAuthenticationSubject(token, roleName, isFromExternalAuth, customProperties);
    }

    public static ImmutableAuthenticationSubject copyOf(AuthenticationSubject instance) {
        if (instance instanceof ImmutableAuthenticationSubject) {
            return (ImmutableAuthenticationSubject)instance;
        }
        return ImmutableAuthenticationSubject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthenticationSubject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ROLE_NAME = 1L;
        private static final long INIT_BIT_IS_FROM_EXTERNAL_AUTH = 2L;
        private static final long INIT_BIT_CUSTOM_PROPERTIES = 4L;
        private long initBits = 7L;
        @Nullable
        private String token;
        @Nullable
        private String roleName;
        private boolean isFromExternalAuth;
        @Nullable
        private Map<String, String> customProperties;

        private Builder() {
        }

        public final Builder from(AuthenticationSubject instance) {
            Objects.requireNonNull(instance, "instance");
            String tokenValue = instance.token();
            if (tokenValue != null) {
                this.token(tokenValue);
            }
            this.roleName(instance.roleName());
            this.isFromExternalAuth(instance.isFromExternalAuth());
            this.customProperties(instance.customProperties());
            return this;
        }

        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        public final Builder roleName(String roleName) {
            this.roleName = Objects.requireNonNull(roleName, "roleName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder isFromExternalAuth(boolean isFromExternalAuth) {
            this.isFromExternalAuth = isFromExternalAuth;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = Objects.requireNonNull(customProperties, "customProperties");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAuthenticationSubject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthenticationSubject(null, this.token, this.roleName, this.isFromExternalAuth, this.customProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("roleName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("isFromExternalAuth");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("customProperties");
            }
            return "Cannot build AuthenticationSubject, some of required attributes are not set " + attributes;
        }
    }
}

