/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public enum SourceAPI {
    GRAPHQL("graphql"),
    CQL("cql"),
    REST("rest");

    public static final String CUSTOM_PAYLOAD_KEY = "stargate.sourceAPI";
    private final String name;

    private SourceAPI(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void toCustomPayload(Map<String, ByteBuffer> customPayload) {
        if (null == customPayload) {
            return;
        }
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(this.getName()).asReadOnlyBuffer();
        customPayload.put(CUSTOM_PAYLOAD_KEY, buffer);
    }

    public static SourceAPI fromCustomPayload(Map<String, ByteBuffer> customPayload, SourceAPI defaultIfMissing) {
        if (null == customPayload) {
            return defaultIfMissing;
        }
        return Optional.ofNullable(customPayload.get(CUSTOM_PAYLOAD_KEY)).flatMap(buffer -> {
            String decode = StandardCharsets.UTF_8.decode((ByteBuffer)buffer).toString();
            return Arrays.stream(SourceAPI.values()).filter(s -> Objects.equals(s.getName(), decode)).findFirst();
        }).orElse(defaultIfMissing);
    }
}

