/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth;

import io.stargate.db.query.BoundDMLQuery;
import io.stargate.db.query.BoundSelect;
import io.stargate.db.query.PartitionKey;
import io.stargate.db.query.PrimaryKey;
import io.stargate.db.query.RowsImpacted;
import io.stargate.db.query.RowsRange;
import io.stargate.db.query.TypedValue;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class TypedKeyValue {
    private final String name;
    private final Column.ColumnType type;
    private final Object value;

    public TypedKeyValue(String name, Column.ColumnType type, Object value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public TypedKeyValue(String name, TypedValue typedValue) {
        this(name, typedValue.type(), typedValue.javaValue());
    }

    public String getName() {
        return this.name;
    }

    public Column.ColumnType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    private static List<TypedKeyValue> fromImpactedRows(AbstractTable table, RowsImpacted rowsSelection) {
        List keyColumns = table.primaryKeyColumns();
        ArrayList<TypedKeyValue> typedKeyValues = new ArrayList<TypedKeyValue>();
        if (rowsSelection.isKeys()) {
            for (PrimaryKey key : rowsSelection.asKeys().primaryKeys()) {
                for (int i = 0; i < keyColumns.size(); ++i) {
                    typedKeyValues.add(new TypedKeyValue(((Column)keyColumns.get(i)).name(), key.get(i)));
                }
            }
        } else {
            for (RowsRange range : rowsSelection.asRanges().ranges()) {
                PartitionKey partitionKey = range.partitionKey();
                for (int i = 0; i < partitionKey.size(); ++i) {
                    typedKeyValues.add(new TypedKeyValue(((Column)keyColumns.get(i)).name(), partitionKey.get(i)));
                }
            }
        }
        return typedKeyValues;
    }

    public static List<TypedKeyValue> forSelect(BoundSelect select) {
        Optional selected = select.selectedRows();
        return selected.map(rowsImpacted -> TypedKeyValue.fromImpactedRows(select.table(), rowsImpacted)).orElse(Collections.emptyList());
    }

    public static List<TypedKeyValue> forDML(BoundDMLQuery dmlQuery) {
        return TypedKeyValue.fromImpactedRows((AbstractTable)dmlQuery.table(), dmlQuery.rowsUpdated());
    }
}

