/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.auth.entity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.stargate.auth.entity.AuthorizedResource;
import io.stargate.auth.entity.EntitySelector;
import io.stargate.auth.entity.ResourceKind;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AuthorizedResource", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAuthorizedResource
implements AuthorizedResource {
    private final ResourceKind kind;
    private final EntitySelector keyspace;
    private final EntitySelector element;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAuthorizedResource(ResourceKind kind) {
        this.kind = Objects.requireNonNull(kind, "kind");
        this.keyspace = this.initShim.keyspace();
        this.element = this.initShim.element();
        this.initShim = null;
    }

    private ImmutableAuthorizedResource(Builder builder) {
        this.kind = builder.kind;
        if (builder.keyspace != null) {
            this.initShim.keyspace(builder.keyspace);
        }
        if (builder.element != null) {
            this.initShim.element(builder.element);
        }
        this.keyspace = this.initShim.keyspace();
        this.element = this.initShim.element();
        this.initShim = null;
    }

    private ImmutableAuthorizedResource(ResourceKind kind, EntitySelector keyspace, EntitySelector element) {
        this.kind = kind;
        this.keyspace = keyspace;
        this.element = element;
        this.initShim = null;
    }

    private EntitySelector keyspaceInitialize() {
        return AuthorizedResource.super.keyspace();
    }

    private EntitySelector elementInitialize() {
        return AuthorizedResource.super.element();
    }

    @Override
    public ResourceKind kind() {
        return this.kind;
    }

    @Override
    public EntitySelector keyspace() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keyspace() : this.keyspace;
    }

    @Override
    public EntitySelector element() {
        InitShim shim = this.initShim;
        return shim != null ? shim.element() : this.element;
    }

    public final ImmutableAuthorizedResource withKind(ResourceKind value) {
        if (this.kind == value) {
            return this;
        }
        ResourceKind newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAuthorizedResource(newValue, this.keyspace, this.element);
    }

    public final ImmutableAuthorizedResource withKeyspace(EntitySelector value) {
        if (this.keyspace == value) {
            return this;
        }
        EntitySelector newValue = Objects.requireNonNull(value, "keyspace");
        return new ImmutableAuthorizedResource(this.kind, newValue, this.element);
    }

    public final ImmutableAuthorizedResource withElement(EntitySelector value) {
        if (this.element == value) {
            return this;
        }
        EntitySelector newValue = Objects.requireNonNull(value, "element");
        return new ImmutableAuthorizedResource(this.kind, this.keyspace, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthorizedResource && this.equalTo((ImmutableAuthorizedResource)another);
    }

    private boolean equalTo(ImmutableAuthorizedResource another) {
        return this.kind.equals((Object)another.kind) && this.keyspace.equals(another.keyspace) && this.element.equals(another.element);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.keyspace.hashCode();
        h += (h << 5) + this.element.hashCode();
        return h;
    }

    public String toString() {
        return "AuthorizedResource{kind=" + (Object)((Object)this.kind) + ", keyspace=" + this.keyspace + ", element=" + this.element + "}";
    }

    public static ImmutableAuthorizedResource of(ResourceKind kind) {
        return new ImmutableAuthorizedResource(kind);
    }

    public static ImmutableAuthorizedResource copyOf(AuthorizedResource instance) {
        if (instance instanceof ImmutableAuthorizedResource) {
            return (ImmutableAuthorizedResource)instance;
        }
        return ImmutableAuthorizedResource.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthorizedResource", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KIND = 1L;
        private long initBits = 1L;
        @Nullable
        private ResourceKind kind;
        @Nullable
        private EntitySelector keyspace;
        @Nullable
        private EntitySelector element;

        private Builder() {
        }

        public final Builder from(AuthorizedResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.kind(instance.kind());
            this.keyspace(instance.keyspace());
            this.element(instance.element());
            return this;
        }

        public final Builder kind(ResourceKind kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder keyspace(EntitySelector keyspace) {
            this.keyspace = Objects.requireNonNull(keyspace, "keyspace");
            return this;
        }

        public final Builder element(EntitySelector element) {
            this.element = Objects.requireNonNull(element, "element");
            return this;
        }

        public ImmutableAuthorizedResource build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthorizedResource(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("kind");
            }
            return "Cannot build AuthorizedResource, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="AuthorizedResource", generator="Immutables")
    private final class InitShim {
        private byte keyspaceBuildStage = 0;
        private EntitySelector keyspace;
        private byte elementBuildStage = 0;
        private EntitySelector element;

        private InitShim() {
        }

        EntitySelector keyspace() {
            if (this.keyspaceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyspaceBuildStage == 0) {
                this.keyspaceBuildStage = (byte)-1;
                this.keyspace = Objects.requireNonNull(ImmutableAuthorizedResource.this.keyspaceInitialize(), "keyspace");
                this.keyspaceBuildStage = 1;
            }
            return this.keyspace;
        }

        void keyspace(EntitySelector keyspace) {
            this.keyspace = keyspace;
            this.keyspaceBuildStage = 1;
        }

        EntitySelector element() {
            if (this.elementBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.elementBuildStage == 0) {
                this.elementBuildStage = (byte)-1;
                this.element = Objects.requireNonNull(ImmutableAuthorizedResource.this.elementInitialize(), "element");
                this.elementBuildStage = 1;
            }
            return this.element;
        }

        void element(EntitySelector element) {
            this.element = element;
            this.elementBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.keyspaceBuildStage == -1) {
                attributes.add("keyspace");
            }
            if (this.elementBuildStage == -1) {
                attributes.add("element");
            }
            return "Cannot build AuthorizedResource, attribute initializers form cycle " + attributes;
        }
    }
}

