/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.config.store.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigWithOverrides {
    private final Map<String, Object> configMap;
    private final String moduleName;

    public ConfigWithOverrides(@Nonnull Map<String, Object> configMap, @Nonnull String moduleName) {
        this.configMap = configMap;
        this.moduleName = moduleName;
    }

    public Map<String, Object> getConfigMap() {
        return this.configMap;
    }

    @Nonnull
    public <T> List<T> getSettingValueList(@Nonnull String settingName, @Nonnull Class<T> expectedType) {
        List settingValue = this.getSettingValue(settingName, List.class);
        return settingValue.stream().map(v -> {
            this.validateType(String.format("%s.list-value", settingName), v, expectedType);
            return v;
        }).collect(Collectors.toList());
    }

    @Nonnull
    public <T> T getSettingValue(@Nonnull String settingName, @Nonnull Class<T> expectedType) {
        Object configValue = this.configMap.get(settingName);
        if (configValue == null) {
            throw new IllegalArgumentException(String.format("The config value for %s is not present", settingName));
        }
        this.validateType(settingName, configValue, expectedType);
        return (T)configValue;
    }

    @Nonnull
    public <T> Optional<T> getOptionalSettingValue(@Nonnull String settingName, @Nonnull Class<T> expectedType) {
        Object configValue = this.configMap.get(settingName);
        if (configValue == null) {
            return Optional.empty();
        }
        this.validateType(settingName, configValue, expectedType);
        return Optional.of(configValue).map(v -> v);
    }

    private <T> void validateType(String settingName, Object configValue, Class<T> expectedType) {
        if (!expectedType.isAssignableFrom(configValue.getClass())) {
            throw new IllegalArgumentException(String.format("The config value for %s has wrong type: %s. It should be of a %s type", settingName, configValue.getClass().getName(), expectedType.getName()));
        }
    }

    @Nullable
    public String getWithOverrides(@Nonnull String settingName, @Nonnull Function<Object, String> objectToStringMapper) {
        String settingNameWithModulePrefix = this.withModulePrefix(settingName);
        String systemProperty = System.getProperty(settingNameWithModulePrefix);
        if (systemProperty != null) {
            return systemProperty;
        }
        String envVariable = System.getenv(settingNameWithModulePrefix);
        if (envVariable != null) {
            return envVariable;
        }
        Object value = this.configMap.get(settingName);
        if (value != null) {
            return objectToStringMapper.apply(value);
        }
        return null;
    }

    @Nullable
    public String getWithOverrides(@Nonnull String settingName) {
        return this.getWithOverrides(settingName, String::valueOf);
    }

    private String withModulePrefix(String settingName) {
        return String.format("%s.%s", this.moduleName, settingName);
    }
}

