/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore.common;

import com.datastax.oss.driver.shaded.guava.common.base.Joiner;
import io.stargate.db.AuthenticatedUser;
import io.stargate.db.ClientInfo;
import io.stargate.db.Persistence;
import io.stargate.db.datastore.common.AbstractCassandraSchemaConverter;
import io.stargate.db.schema.Schema;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraPersistence<Config, K, T, C, U, I, V>
implements Persistence {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCassandraPersistence.class);
    private final String name;
    private final AbstractCassandraSchemaConverter<K, T, C, U, I, V> schemaConverter;
    private volatile Schema schema;

    protected AbstractCassandraPersistence(String name) {
        this.name = name;
        this.schemaConverter = this.newSchemaConverter();
    }

    protected abstract AbstractCassandraSchemaConverter<K, T, C, U, I, V> newSchemaConverter();

    protected abstract Iterable<K> currentInternalSchema();

    protected abstract void registerInternalSchemaListener(Runnable var1);

    protected abstract void unregisterInternalSchemaListener();

    protected abstract void initializePersistence(Config var1);

    protected abstract void destroyPersistence();

    public final String name() {
        return this.name;
    }

    public final Schema schema() {
        if (this.schema == null) {
            throw new IllegalStateException(String.format("The schema cannot be accessed until the %s persistence layer is initialized", this.name));
        }
        return this.schema;
    }

    public final void initialize(Config config) {
        logger.info("Initializing {}", (Object)this.name);
        if (!Boolean.parseBoolean(System.getProperty("stargate.developer_mode"))) {
            System.setProperty("cassandra.join_ring", "false");
        }
        this.initializePersistence(config);
        this.schema = this.computeCurrentSchema();
        this.registerInternalSchemaListener(() -> {
            this.schema = this.computeCurrentSchema();
        });
    }

    private Schema computeCurrentSchema() {
        return this.schemaConverter.convertCassandraSchema(this.currentInternalSchema());
    }

    public final void destroy() {
        this.destroyPersistence();
        this.unregisterInternalSchemaListener();
    }

    public String toString() {
        return this.name();
    }

    protected static abstract class AbstractConnection
    implements Persistence.Connection {
        @Nullable
        private final ClientInfo clientInfo;
        @Nullable
        private volatile AuthenticatedUser loggedUser;

        protected AbstractConnection(@Nullable ClientInfo clientInfo) {
            this.clientInfo = clientInfo;
        }

        public Optional<ClientInfo> clientInfo() {
            return Optional.ofNullable(this.clientInfo);
        }

        protected abstract void loginInternally(AuthenticatedUser var1);

        public void login(AuthenticatedUser user) {
            this.loginInternally(user);
            this.loggedUser = user;
        }

        public Optional<AuthenticatedUser> loggedUser() {
            return Optional.ofNullable(this.loggedUser);
        }

        public String toString() {
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("persistence", this.persistence().toString());
            if (this.clientInfo != null) {
                params.put("client", this.clientInfo.toString());
            }
            if (this.loggedUser != null) {
                params.put("logged", this.loggedUser.name());
            }
            return String.format("Connection[%s]", Joiner.on((String)",").withKeyValueSeparator("=").join(params));
        }
    }
}

