/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore.common;

import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import io.stargate.db.schema.CollectionIndexingType;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableCollectionIndexingType;
import io.stargate.db.schema.ImmutableColumn;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Index;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.MaterializedView;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.SecondaryIndex;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.stargate.utils.Streams;
import org.javatuples.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCassandraSchemaConverter<K, T, C, U, I, V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCassandraSchemaConverter.class);

    protected abstract Set<String> getExcludedIndexOptions();

    protected abstract String keyspaceName(K var1);

    protected abstract Map<String, String> replicationOptions(K var1);

    protected abstract boolean usesDurableWrites(K var1);

    protected abstract Iterable<T> tables(K var1);

    protected abstract Iterable<U> userTypes(K var1);

    protected abstract Iterable<V> views(K var1);

    protected abstract String tableName(T var1);

    protected abstract Iterable<C> columns(T var1);

    protected abstract String columnName(C var1);

    protected abstract Column.ColumnType columnType(C var1);

    protected abstract Column.Order columnClusteringOrder(C var1);

    protected abstract Column.Kind columnKind(C var1);

    protected abstract Iterable<I> secondaryIndexes(T var1);

    protected abstract String comment(T var1);

    protected abstract int ttl(T var1);

    protected abstract String indexName(I var1);

    protected abstract String indexTarget(I var1);

    protected abstract boolean isCustom(I var1);

    protected abstract String indexClass(I var1);

    protected abstract Map<String, String> indexOptions(I var1);

    protected abstract List<Column> userTypeFields(U var1);

    protected abstract String userTypeName(U var1);

    protected abstract T asTable(V var1);

    protected abstract boolean isBaseTableOf(T var1, V var2);

    public Schema convertCassandraSchema(Iterable<K> cassandraKeyspaces) {
        return Schema.create((Iterable)Iterables.transform(cassandraKeyspaces, this::convertKeyspace));
    }

    private Keyspace convertKeyspace(K keyspace) {
        String name = this.keyspaceName(keyspace);
        Stream<Table> tables = this.convertTables(name, this.tables(keyspace), this.views(keyspace));
        Stream<UserDefinedType> userDefinedTypes = this.convertUserTypes(name, this.userTypes(keyspace));
        return Keyspace.create((String)name, (Iterable)tables.collect(Collectors.toList()), (Iterable)userDefinedTypes.collect(Collectors.toList()), this.replicationOptions(keyspace), Optional.of(this.usesDurableWrites(keyspace)));
    }

    private Stream<Table> convertTables(String keyspaceName, Iterable<T> tables, Iterable<V> views) {
        return Streams.of(tables).map(t -> this.convertTable(keyspaceName, t, views));
    }

    private Table convertTable(String keyspaceName, T table, Iterable<V> views) {
        List<Column> columns = this.convertColumns(keyspaceName, table).collect(Collectors.toList());
        Stream<Index> secondaryIndexes = this.convertSecondaryIndexes(keyspaceName, table, columns);
        Stream<Index> materializedViews = this.convertMVIndexes(keyspaceName, table, views);
        String comment = this.comment(table);
        int ttl = this.ttl(table);
        return Table.create((String)keyspaceName, (String)this.tableName(table), columns, (Iterable)Stream.concat(secondaryIndexes, materializedViews).collect(Collectors.toList()), (String)comment, (int)ttl);
    }

    private Stream<Column> convertColumns(String keyspaceName, T table) {
        return this.convertColumns(keyspaceName, this.tableName(table), this.columns(table));
    }

    private Stream<Column> convertColumns(String keyspaceName, String tableName, Iterable<C> columns) {
        return Streams.of(columns).map(c -> this.convertColumn(keyspaceName, tableName, c));
    }

    private Column convertColumn(String keyspaceName, String tableName, C column) {
        return ImmutableColumn.builder().name(this.columnName(column)).keyspace(keyspaceName).table(tableName).type(this.columnType(column)).kind(this.columnKind(column)).order(this.columnClusteringOrder(column)).build();
    }

    private Stream<Index> convertSecondaryIndexes(String keyspaceName, T table, List<Column> columns) {
        return Streams.of(this.secondaryIndexes(table)).map(i -> this.convertSecondaryIndex(keyspaceName, this.tableName(table), i, columns)).filter(Objects::nonNull);
    }

    private SecondaryIndex convertSecondaryIndex(String keyspaceName, String tableName, I index, List<Column> baseTableColumns) {
        String target = this.indexTarget(index);
        if (target == null) {
            logger.error("No 'target' defined for index {} on {}.{}. This should not happen and should be reported for investigation. That index will not be visible in Stargate schema view", new Object[]{this.indexName(index), keyspaceName, tableName});
            return null;
        }
        Pair<String, CollectionIndexingType> result = this.convertTarget(target);
        String targetColumn = (String)result.getValue0();
        Optional<Column> col = baseTableColumns.stream().filter(c -> c.name().equals(targetColumn)).findFirst();
        if (!col.isPresent()) {
            logger.error("Could not find secondary index target column {} in the columns of table {}.{} ({}). This should not happen and should be reported for investigation. That index will not be visible in Stargate schema view.", new Object[]{targetColumn, keyspaceName, tableName, baseTableColumns});
            return null;
        }
        return SecondaryIndex.create((String)keyspaceName, (String)this.indexName(index), (Column)col.get(), (CollectionIndexingType)((CollectionIndexingType)result.getValue1()), (String)this.indexClass(index), this.indexOptions(index));
    }

    private Pair<String, CollectionIndexingType> convertTarget(String targetColumn) {
        if (targetColumn.startsWith("values(")) {
            return new Pair((Object)targetColumn.replace("values(", "").replace(")", "").replace("\"", ""), (Object)ImmutableCollectionIndexingType.builder().indexValues(true).build());
        }
        if (targetColumn.startsWith("keys(")) {
            return new Pair((Object)targetColumn.replace("keys(", "").replace(")", "").replace("\"", ""), (Object)ImmutableCollectionIndexingType.builder().indexKeys(true).build());
        }
        if (targetColumn.startsWith("entries(")) {
            return new Pair((Object)targetColumn.replace("entries(", "").replace(")", "").replace("\"", ""), (Object)ImmutableCollectionIndexingType.builder().indexEntries(true).build());
        }
        if (targetColumn.startsWith("full(")) {
            return new Pair((Object)targetColumn.replace("full(", "").replace(")", "").replace("\"", ""), (Object)ImmutableCollectionIndexingType.builder().indexFull(true).build());
        }
        return new Pair((Object)targetColumn.replaceAll("\"", ""), (Object)ImmutableCollectionIndexingType.builder().build());
    }

    private Stream<Index> convertMVIndexes(String keyspaceName, T table, Iterable<V> views) {
        return Streams.of(views).filter(v -> this.isBaseTableOf(table, v)).map(v -> this.convertMVIndex(keyspaceName, v));
    }

    private Index convertMVIndex(String keyspaceName, V view) {
        T table = this.asTable(view);
        List columns = this.convertColumns(keyspaceName, table).collect(Collectors.toList());
        String comment = this.comment(table);
        int ttl = this.ttl(table);
        return MaterializedView.create((String)keyspaceName, (String)this.tableName(table), columns, (String)comment, (int)ttl);
    }

    private Stream<UserDefinedType> convertUserTypes(String keyspaceName, Iterable<U> userTypes) {
        return Streams.of(userTypes).map(userType -> this.convertUserType(keyspaceName, userType));
    }

    private UserDefinedType convertUserType(String keyspaceName, U userType) {
        return ImmutableUserDefinedType.builder().keyspace(keyspaceName).name(this.userTypeName(userType)).columns(this.userTypeFields(userType)).build();
    }
}

