/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractStargateSeedProvider {
    private final List<InetAddress> seeds;

    public AbstractStargateSeedProvider(Map<String, String> args) {
        if (!args.containsKey("seeds")) {
            throw this.getNoSeedsException();
        }
        this.seeds = Arrays.stream(args.get("seeds").split(",")).map(s -> {
            try {
                return InetAddress.getAllByName(s.trim());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Arrays::stream).collect(Collectors.toList());
    }

    protected abstract RuntimeException getNoSeedsException();

    public List<InetAddress> getSeeds() {
        return this.seeds;
    }
}

