/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore.common.util;

import io.stargate.core.util.TimeSource;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;

public abstract class HealthCheckWithGracePeriod {
    protected final Duration gracePeriod;
    private final AtomicLong failureTimestamp = new AtomicLong(-1L);
    private final TimeSource timeSource;

    protected HealthCheckWithGracePeriod(Duration gracePeriod, TimeSource timeSource) {
        this.gracePeriod = gracePeriod;
        this.timeSource = timeSource;
    }

    protected abstract boolean isHealthy();

    protected void reset() {
        this.failureTimestamp.set(-1L);
    }

    public boolean check() {
        long timestamp = this.timeSource.currentTimeMillis();
        boolean healthy = this.isHealthy();
        if (healthy) {
            this.reset();
            return true;
        }
        if (this.failureTimestamp.compareAndSet(-1L, timestamp)) {
            return true;
        }
        long referenceTimestamp = this.failureTimestamp.get();
        if (referenceTimestamp < 0L) {
            return true;
        }
        long graceMillis = this.gracePeriod.toMillis();
        long deadline = referenceTimestamp + graceMillis;
        return timestamp < deadline;
    }
}

