/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.db.datastore.common.util;

import io.stargate.core.util.TimeSource;
import io.stargate.db.datastore.common.util.HealthCheckWithGracePeriod;
import java.time.Duration;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaAgreementAchievableCheck
extends HealthCheckWithGracePeriod {
    private static final Logger logger = LoggerFactory.getLogger(SchemaAgreementAchievableCheck.class);
    private final Supplier<Boolean> isInSchemaAgreement;
    private final Supplier<Boolean> isStorageInSchemaAgreement;

    public SchemaAgreementAchievableCheck(Supplier<Boolean> isInSchemaAgreement, Supplier<Boolean> isStorageInSchemaAgreement, Duration gracePeriod, TimeSource timeSource) {
        super(gracePeriod, timeSource);
        this.isInSchemaAgreement = isInSchemaAgreement;
        this.isStorageInSchemaAgreement = isStorageInSchemaAgreement;
    }

    @Override
    protected boolean isHealthy() {
        if (this.isInSchemaAgreement.get().booleanValue()) {
            return true;
        }
        if (!this.isStorageInSchemaAgreement.get().booleanValue()) {
            logger.debug("Storage nodes are not in schema agreement");
            return true;
        }
        return false;
    }

    @Override
    public boolean check() {
        boolean result = super.check();
        if (!result) {
            logger.error("Schema agreement is not achievable with grace period {}", (Object)this.gracePeriod);
        }
        return result;
    }
}

