/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.it.exec;

import io.stargate.it.exec.OutputListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessRunner.class);
    private static final int PROCESS_WAIT_MINUTES = Integer.getInteger("stargate.test.process.wait.timeout.minutes", 10);
    protected final int generation;
    protected final int node;
    private final String kind;
    private final ExecuteWatchdog watchDog = new ExecuteWatchdog(-1L);
    private final CompletableFuture<Void> ready = new CompletableFuture();
    private final CountDownLatch exit = new CountDownLatch(1);
    private final Collection<OutputListener> stdoutListeners = new ConcurrentLinkedQueue<OutputListener>();

    public ProcessRunner(String kind, int generation, int node) {
        this.kind = kind;
        this.generation = generation;
        this.node = node;
    }

    public void addStdOutListener(OutputListener listener) {
        this.stdoutListeners.add(listener);
    }

    public void removeStdOutListener(OutputListener listener) {
        this.stdoutListeners.remove(listener);
    }

    protected void start(CommandLine cmd, Map<String, String> env) {
        final String tag = this.kind.toLowerCase();
        LogOutputStream out = new LogOutputStream(){

            protected void processLine(String line, int logLevel) {
                for (OutputListener listener : ProcessRunner.this.stdoutListeners) {
                    listener.processLine(ProcessRunner.this.node, line);
                }
                LOG.info("{}{}-{}> {}", new Object[]{tag, ProcessRunner.this.generation, ProcessRunner.this.node, line});
            }
        };
        LogOutputStream err = new LogOutputStream(){

            protected void processLine(String line, int logLevel) {
                LOG.error("{}{}-{}> {}", new Object[]{tag, ProcessRunner.this.generation, ProcessRunner.this.node, line});
            }
        };
        DefaultExecutor executor = new DefaultExecutor(){

            protected Thread createThread(Runnable runnable, String name) {
                return super.createThread(runnable, "process-runner-" + tag + "-" + ProcessRunner.this.generation + "-" + ProcessRunner.this.node);
            }
        };
        executor.setExitValues(new int[]{0, 143});
        executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)out, (OutputStream)err));
        executor.setWatchdog(this.watchDog);
        try {
            LOG.info("Starting {} {}, node {}: {}", new Object[]{this.kind, this.generation, this.node, cmd});
            HashMap<String, String> fullEnv = new HashMap<String, String>(EnvironmentUtils.getProcEnvironment());
            fullEnv.putAll(env);
            executor.execute(cmd, fullEnv, (ExecuteResultHandler)new ExecutionCallback());
            LOG.info("Started {} {}, node {}: {}", new Object[]{this.kind, this.generation, this.node, cmd});
        }
        catch (IOException e) {
            LOG.info("Unable to start {} {}, node {}: {}", new Object[]{this.kind, this.generation, this.node, e.getMessage(), e});
        }
    }

    protected void ready() {
        LOG.info("{} {}/{} is ready", new Object[]{this.kind, this.generation, this.node});
        this.ready.complete(null);
    }

    public void stop() {
        LOG.info("Stopping {} process {}/{}", new Object[]{this.kind, this.generation, this.node});
        this.watchDog.destroyProcess();
        LOG.info("Signaled {} process {}/{} to stop", new Object[]{this.kind, this.generation, this.node});
    }

    protected void cleanup() {
    }

    public void awaitReady() {
        try {
            this.ready.get(PROCESS_WAIT_MINUTES, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void awaitExit() {
        try {
            if (!this.exit.await(PROCESS_WAIT_MINUTES, TimeUnit.MINUTES)) {
                throw new IllegalStateException(String.format("%s process %s/%s did not exit", this.kind, this.generation, this.node));
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    private class ExecutionCallback
    implements ExecuteResultHandler {
        private ExecutionCallback() {
        }

        public void onProcessComplete(int exitValue) {
            LOG.info("{} process {}/{} exited with return code {}", new Object[]{ProcessRunner.this.kind, ProcessRunner.this.generation, ProcessRunner.this.node, exitValue});
            ProcessRunner.this.cleanup();
            ProcessRunner.this.ready.complete(null);
            ProcessRunner.this.exit.countDown();
        }

        public void onProcessFailed(ExecuteException e) {
            LOG.info("{} process {}/{} failed with exception: {}", new Object[]{ProcessRunner.this.kind, ProcessRunner.this.generation, ProcessRunner.this.node, e});
            ProcessRunner.this.cleanup();
            ProcessRunner.this.ready.completeExceptionally((Throwable)e);
            ProcessRunner.this.exit.countDown();
        }
    }
}

