/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.it.storage;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExternalResource<A extends Annotation, R extends Holder>
implements BeforeAllCallback,
BeforeEachCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalResource.class);
    private final Class<A> annotationClass;
    private final String key;
    private final ExtensionContext.Namespace namespace;

    protected ExternalResource(Class<A> annotationClass, String key, ExtensionContext.Namespace namespace) {
        this.annotationClass = annotationClass;
        this.key = key;
        this.namespace = namespace;
    }

    protected abstract boolean isShared(A var1);

    protected abstract Optional<R> processResource(R var1, A var2, ExtensionContext var3) throws Exception;

    protected Optional<R> getResource(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(this.namespace);
        return Optional.ofNullable((Holder)store.get((Object)this.key));
    }

    private void process(ExtensionContext context, ExtensionContext destination, A spec) throws Exception {
        Holder existing = this.getResource(context).orElse(null);
        Optional<Holder> r = this.processResource(existing, spec, context);
        if (r.isPresent()) {
            ExtensionContext.Store store = destination.getStore(this.namespace);
            Holder h = r.get();
            h.init(store, this.key, this.getClass().getSimpleName(), destination.getUniqueId());
            store.put((Object)this.key, (Object)h);
            LOG.info("Created resource for {} in {} for {}", new Object[]{this.getClass().getSimpleName(), destination.getUniqueId(), context.getUniqueId()});
        }
    }

    private void process(ExtensionContext context) throws Exception {
        Optional element = context.getElement();
        Optional annotation = AnnotationSupport.findAnnotation((Optional)element, this.annotationClass);
        if (annotation.isPresent()) {
            Annotation spec = (Annotation)annotation.get();
            if (this.isShared(spec)) {
                this.process(context, context.getRoot(), spec);
            } else {
                this.process(context, context, spec);
            }
        } else {
            LOG.info("Ignoring null {} spec in {}", (Object)this.getClass().getSimpleName(), (Object)context.getUniqueId());
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.process(context);
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.process(context);
    }

    public static abstract class Holder
    implements ExtensionContext.Store.CloseableResource {
        private String location;
        private String type;
        private ExtensionContext.Store store;
        private String key;

        private void init(ExtensionContext.Store store, String key, String type, String location) {
            this.store = store;
            this.key = key;
            this.type = type;
            this.location = location;
        }

        public void close() {
            LOG.info("Closing {} resource in {}", (Object)this.type, (Object)this.location);
            if (this.store != null) {
                this.store.remove((Object)this.key);
            }
        }
    }
}

