/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.it.storage;

import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook {
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHook.class);
    private static final Deque<AutoCloseable> resources = new ConcurrentLinkedDeque<AutoCloseable>();

    public static void add(AutoCloseable resource) {
        resources.addFirst(resource);
    }

    public static void remove(AutoCloseable resource) {
        resources.remove(resource);
    }

    static {
        Thread hooks = new Thread("storage-shutdown-hook"){

            @Override
            public void run() {
                for (AutoCloseable resource : resources) {
                    try {
                        resource.close();
                    }
                    catch (Exception e) {
                        LOG.error("Unable to close resource on shutdown: {}", (Object)e.getMessage(), (Object)e);
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(hooks);
    }
}

