/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.it;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import io.stargate.db.ComparableKey;
import io.stargate.db.PagingPosition;
import io.stargate.db.Parameters;
import io.stargate.db.Persistence;
import io.stargate.db.Result;
import io.stargate.db.RowDecorator;
import io.stargate.db.SimpleStatement;
import io.stargate.db.Statement;
import io.stargate.db.datastore.DataStore;
import io.stargate.db.datastore.PersistenceDataStoreFactory;
import io.stargate.db.datastore.ResultSet;
import io.stargate.db.datastore.Row;
import io.stargate.db.query.BoundQuery;
import io.stargate.db.query.Predicate;
import io.stargate.db.query.TypedValue;
import io.stargate.db.query.builder.AbstractBound;
import io.stargate.db.query.builder.BuiltQuery;
import io.stargate.db.query.builder.Replication;
import io.stargate.db.schema.AbstractTable;
import io.stargate.db.schema.Column;
import io.stargate.db.schema.ImmutableTupleType;
import io.stargate.db.schema.ImmutableUserDefinedType;
import io.stargate.db.schema.Keyspace;
import io.stargate.db.schema.MaterializedView;
import io.stargate.db.schema.Schema;
import io.stargate.db.schema.Table;
import io.stargate.db.schema.UserDefinedType;
import io.stargate.it.storage.ClusterConnectionInfo;
import io.stargate.it.storage.ClusterSpec;
import io.stargate.it.storage.ExternalStorage;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.jcip.annotations.NotThreadSafe;
import org.apache.cassandra.stargate.utils.FastByteOperations;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.OptionalAssert;
import org.javatuples.Pair;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ExternalStorage.class})
@ClusterSpec(shared=true)
@NotThreadSafe
public abstract class PersistenceTest {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceTest.class);
    protected static final int KEYSPACE_NAME_MAX_LENGTH = 48;
    private DataStore dataStore;
    private String table;
    private String keyspace;
    private ClusterConnectionInfo backend;
    private static final int CUSTOM_PAGE_SIZE = 50;

    protected abstract Persistence persistence();

    @BeforeEach
    public void setup(TestInfo testInfo, ClusterConnectionInfo backend) {
        this.backend = backend;
        this.dataStore = new PersistenceDataStoreFactory(this.persistence()).createInternal();
        logger.info("{}", (Object)this.dataStore);
        Optional<String> name = testInfo.getTestMethod().map(Method::getName);
        Assertions.assertThat(name).isPresent();
        String testName = name.get();
        this.keyspace = "ks_persistence_" + System.currentTimeMillis() + "_" + testName;
        if (this.keyspace.length() > 48) {
            this.keyspace = this.keyspace.substring(0, 48);
        }
        this.table = testName;
    }

    @Test
    public void querySystemTables() throws ExecutionException, InterruptedException {
        CompletableFuture rs = this.dataStore.queryBuilder().select().column("cluster_name").column("data_center").from("system", "local").build().execute(new Object[0]);
        Row row = ((ResultSet)rs.get()).one();
        logger.info(String.valueOf(row));
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((String)((Column)row.columns().get(0)).name()).isEqualTo("cluster_name");
        Assertions.assertThat((String)((Column)row.columns().get(1)).name()).isEqualTo("data_center");
        Assertions.assertThat((String)row.getString("cluster_name")).isEqualTo(this.backend.clusterName());
        Assertions.assertThat((String)row.getString("data_center")).isEqualTo(this.backend.datacenter());
        rs = this.dataStore.queryBuilder().select().column("data_center").from("system", "peers").build().execute(new Object[0]);
        Assertions.assertThat((boolean)((ResultSet)rs.get()).hasNoMoreFetchedRows()).isTrue();
    }

    @Test
    public void testKeyspace() throws ExecutionException, InterruptedException {
        this.createKeyspace();
    }

    @Test
    public void testAlterAndDrop() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("created", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).build().execute(new Object[0]).join();
        Table t = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        Assertions.assertThat((Object)t).isEqualTo((Object)Schema.build().keyspace(this.keyspace).table(this.table).column("created", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).build().keyspace(this.keyspace).table(this.table));
        this.dataStore.queryBuilder().alter().table(this.keyspace, this.table).addColumn("added", (Column.ColumnType)Column.Type.Boolean).build().execute(new Object[0]).join();
        Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table)).isEqualTo((Object)Schema.build().keyspace(this.keyspace).table(this.table).column("created", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("added", (Column.ColumnType)Column.Type.Boolean).build().keyspace(this.keyspace).table(this.table));
        this.dataStore.queryBuilder().drop().table(this.keyspace, this.table).build().execute(new Object[0]).join();
        Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table)).isNull();
    }

    @Test
    public void testColumnKinds() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("PK1", (Column.ColumnType)Column.Type.Text, Column.Kind.PartitionKey).column("PK2", (Column.ColumnType)Column.Type.Text, Column.Kind.PartitionKey).column("CC1", (Column.ColumnType)Column.Type.Text, Column.Kind.Clustering, Column.Order.ASC).column("CC2", (Column.ColumnType)Column.Type.Text, Column.Kind.Clustering, Column.Order.DESC).column("R1", (Column.ColumnType)Column.Type.Text).column("R2", (Column.ColumnType)Column.Type.Text).column("S1", (Column.ColumnType)Column.Type.Text, Column.Kind.Static).column("S2", (Column.ColumnType)Column.Type.Text, Column.Kind.Static).build().execute(new Object[0]).join();
        Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table)).isEqualTo((Object)Schema.build().keyspace(this.keyspace).table(this.table).column("PK1", (Column.ColumnType)Column.Type.Text, Column.Kind.PartitionKey).column("PK2", (Column.ColumnType)Column.Type.Text, Column.Kind.PartitionKey).column("CC1", (Column.ColumnType)Column.Type.Text, Column.Kind.Clustering, Column.Order.ASC).column("CC2", (Column.ColumnType)Column.Type.Text, Column.Kind.Clustering, Column.Order.DESC).column("S1", (Column.ColumnType)Column.Type.Text, Column.Kind.Static).column("S2", (Column.ColumnType)Column.Type.Text, Column.Kind.Static).column("R1", (Column.ColumnType)Column.Type.Text).column("R2", (Column.ColumnType)Column.Type.Text).build().keyspace(this.keyspace).table(this.table));
    }

    @Disabled(value="Disabling for now since it currently just hangs")
    @Test
    public void testInsertingAndReadingDifferentTypes() throws Exception {
        this.createKeyspace();
        Column.ColumnType nestedTuple = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Int, Column.Type.Double});
        Column.ColumnType tupleType = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, nestedTuple});
        Column.ColumnType nestedDuration = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Int, Column.Type.Duration});
        Column.ColumnType tupleTypeWithDuration = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, nestedDuration});
        ImmutableList values = ImmutableList.builder().add((Object)Pair.with((Object)Column.Type.Ascii, (Object)"hi")).add((Object)Pair.with((Object)Column.Type.Bigint, (Object)23L)).add((Object)Pair.with((Object)Column.Type.Blob, (Object)ByteBuffer.wrap(new byte[]{2, 3}))).add((Object)Pair.with((Object)Column.Type.Boolean, (Object)true)).add((Object)Pair.with((Object)Column.Type.Date, (Object)LocalDate.ofEpochDay(34L))).add((Object)Pair.with((Object)Column.Type.Decimal, (Object)BigDecimal.valueOf(2.3))).add((Object)Pair.with((Object)Column.Type.Double, (Object)3.8)).add((Object)Pair.with((Object)Column.Type.Double, (Object)Double.NaN)).add((Object)Pair.with((Object)Column.Type.Double, (Object)Double.NEGATIVE_INFINITY)).add((Object)Pair.with((Object)Column.Type.Double, (Object)Double.POSITIVE_INFINITY)).add((Object)Pair.with((Object)Column.Type.Duration, (Object)CqlDuration.newInstance((int)2, (int)3, (long)5L))).add((Object)Pair.with((Object)Column.Type.Float, (Object)Float.valueOf(4.9f))).add((Object)Pair.with((Object)Column.Type.Float, (Object)Float.valueOf(Float.NaN))).add((Object)Pair.with((Object)Column.Type.Float, (Object)Float.valueOf(Float.NEGATIVE_INFINITY))).add((Object)Pair.with((Object)Column.Type.Float, (Object)Float.valueOf(Float.POSITIVE_INFINITY))).add((Object)Pair.with((Object)Column.Type.Inet, (Object)Inet4Address.getByAddress(new byte[]{2, 3, 4, 5}))).add((Object)Pair.with((Object)Column.Type.Int, (Object)4)).add((Object)Pair.with((Object)Column.Type.List.of(new Column.ColumnType[]{Column.Type.Double}), Arrays.asList(3.0, 4.5))).add((Object)Pair.with((Object)Column.Type.Map.of(new Column.ColumnType[]{Column.Type.Text, Column.Type.Int}), (Object)ImmutableMap.of((Object)"Alice", (Object)3, (Object)"Bob", (Object)4))).add((Object)Pair.with((Object)Column.Type.Set.of(new Column.ColumnType[]{Column.Type.Double}), (Object)ImmutableSet.of((Object)3.4, (Object)5.3))).add((Object)Pair.with((Object)Column.Type.List.of(new Column.ColumnType[]{Column.Type.Duration}), Arrays.asList(CqlDuration.newInstance((int)2, (int)3, (long)5L), CqlDuration.newInstance((int)2, (int)3, (long)6L)))).add((Object)Pair.with((Object)Column.Type.Map.of(new Column.ColumnType[]{Column.Type.Text, Column.Type.Duration}), (Object)ImmutableMap.of((Object)"Alice", (Object)CqlDuration.newInstance((int)2, (int)3, (long)5L), (Object)"Bob", (Object)CqlDuration.newInstance((int)2, (int)3, (long)6L)))).add((Object)Pair.with((Object)Column.Type.Smallint, (Object)7)).add((Object)Pair.with((Object)Column.Type.Time, (Object)LocalTime.ofSecondOfDay(20L))).add((Object)Pair.with((Object)Column.Type.Timestamp, (Object)Instant.ofEpochSecond(3L))).add((Object)Pair.with((Object)Column.Type.Timeuuid, (Object)Uuids.timeBased())).add((Object)Pair.with((Object)Column.Type.Tinyint, (Object)4)).add((Object)Pair.with((Object)tupleType, (Object)tupleType.create(new Object[]{"Test", nestedTuple.create(new Object[]{2, 3.0})}))).add((Object)Pair.with((Object)tupleTypeWithDuration, (Object)tupleTypeWithDuration.create(new Object[]{"Test", nestedDuration.create(new Object[]{2, CqlDuration.newInstance((int)2, (int)3, (long)6L)})}))).add((Object)Pair.with((Object)Column.Type.Uuid, (Object)Uuids.random())).add((Object)Pair.with((Object)Column.Type.Text, (Object)"Hi")).add((Object)Pair.with((Object)Column.Type.Varint, (Object)BigInteger.valueOf(23L))).add((Object)Pair.with((Object)Column.Type.List.of(new Column.ColumnType[]{Column.Type.Double}).frozen(), Arrays.asList(3.0, 4.5))).add((Object)Pair.with((Object)Column.Type.Map.of(new Column.ColumnType[]{Column.Type.Text, Column.Type.Int}).frozen(), (Object)ImmutableMap.of((Object)"Alice", (Object)3, (Object)"Bob", (Object)4))).add((Object)Pair.with((Object)Column.Type.Set.of(new Column.ColumnType[]{Column.Type.Double}).frozen(), (Object)ImmutableSet.of((Object)3.4, (Object)5.3))).build();
        Supplier<Stream> distinctColumnTypesStream = () -> PersistenceTest.lambda$testInsertingAndReadingDifferentTypes$0((List)values);
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("PK", (Column.ColumnType)Column.Type.Text, Column.Kind.PartitionKey).column((Collection)distinctColumnTypesStream.get().map(columnType -> Column.create((String)this.columnName((Column.ColumnType)columnType), (Column.ColumnType)columnType)).collect(Collectors.toList())).build().execute(new Object[0]).join();
        distinctColumnTypesStream.get().forEach(columnType -> {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.dataStore.schema().keyspace(this.keyspace).table(this.table).column(this.columnName((Column.ColumnType)columnType))).withFailMessage("Table did not contain definition for column %s", new Object[]{columnType.cqlDefinition()})).isNotNull();
            Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table).column(this.columnName((Column.ColumnType)columnType)).type()).isEqualToComparingFieldByField(columnType);
        });
        for (int i = 0; i < values.size(); ++i) {
            Pair pair = (Pair)values.get(i);
            this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("PK", (Object)("PK" + i)).value(this.columnName((Column.ColumnType)pair.getValue0()), pair.getValue1()).build().execute(new Object[0]).join();
            Row row = ((ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).where("PK", Predicate.EQ, (Object)("PK" + i)).build().execute(new Object[0]).join()).one();
            Assertions.assertThat((Object)row.getObject(this.columnName((Column.ColumnType)pair.getValue0()))).isEqualTo(pair.getValue1());
        }
    }

    private String columnName(Column.ColumnType type) {
        return "c" + System.identityHashCode(type);
    }

    @Test
    public void testUseTypesInWhere() throws Exception {
        this.createKeyspace();
        ImmutableMap values = ImmutableMap.builder().put((Object)Column.Type.Ascii, (Object)"hi").put((Object)Column.Type.Bigint, (Object)23L).put((Object)Column.Type.Blob, (Object)ByteBuffer.wrap(new byte[]{2, 3})).put((Object)Column.Type.Boolean, (Object)true).put((Object)Column.Type.Date, (Object)LocalDate.ofEpochDay(34L)).put((Object)Column.Type.Decimal, (Object)BigDecimal.valueOf(2.3)).put((Object)Column.Type.Double, (Object)3.8).put((Object)Column.Type.Float, (Object)Float.valueOf(4.9f)).put((Object)Column.Type.Inet, (Object)Inet4Address.getByAddress(new byte[]{2, 3, 4, 5})).put((Object)Column.Type.Int, (Object)4).put((Object)Column.Type.Smallint, (Object)7).put((Object)Column.Type.Text, (Object)"some text").put((Object)Column.Type.Time, (Object)LocalTime.ofSecondOfDay(20L)).put((Object)Column.Type.Timestamp, (Object)Instant.ofEpochSecond(3L)).put((Object)Column.Type.Timeuuid, (Object)Uuids.timeBased()).put((Object)Column.Type.Tinyint, (Object)4).put((Object)Column.Type.Uuid, (Object)Uuids.random()).put((Object)Column.Type.Varint, (Object)BigInteger.valueOf(23L)).build();
        values.forEach((k, v) -> {
            try {
                String tbl = this.table + k.rawType().toString().toLowerCase().replace("'", "");
                Column c = Column.create((String)k.cqlDefinition(), (Column.Kind)Column.Kind.PartitionKey, (Column.ColumnType)k);
                this.dataStore.queryBuilder().create().table(this.keyspace, tbl).column(c).build().execute(new Object[0]).join();
                this.dataStore.queryBuilder().insertInto(this.keyspace, tbl).value(c, v).build().execute(new Object[0]).join();
                Row row = ((ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, tbl).where(c, Predicate.EQ, v).build().execute(new Object[0]).join()).one();
                Assertions.assertThat((Object)row).isNotNull();
                Assertions.assertThat((Object)row.getObject(c.name())).isEqualTo(v);
            }
            catch (Exception e) {
                Fail.fail((String)e.getMessage(), (Throwable)e);
            }
        });
    }

    @Test
    public void testSecondaryIndexes() throws ExecutionException, InterruptedException {
        ((AbstractBooleanAssert)Assumptions.assumeThat((boolean)this.isCassandra4()).as("Disabled because it is currently not possible to enable SAI indexes on a Cassandra 4 backend", new Object[0])).isFalse();
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).column("d", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().create().index("byB").ifNotExists().on(this.keyspace, this.table).column("b").build().execute(new Object[0]).join();
        Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table)).isEqualTo((Object)Schema.build().keyspace(this.keyspace).table(this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).column("d", (Column.ColumnType)Column.Type.Text).secondaryIndex("byB").column("b").build().keyspace(this.keyspace).table(this.table));
        this.dataStore.queryBuilder().create().index("byC").ifNotExists().on(this.keyspace, this.table).column("c").build().execute(new Object[0]).join();
        Assertions.assertThat((String)this.dataStore.schema().keyspace(this.keyspace).table(this.table).toString()).isEqualTo(Schema.build().keyspace(this.keyspace).table(this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).column("d", (Column.ColumnType)Column.Type.Text).secondaryIndex("byB").column("b").secondaryIndex("byC").column("c").build().keyspace(this.keyspace).table(this.table).toString());
        String indexClass = "org.apache.cassandra.index.sasi.SASIIndex";
        HashMap<String, String> indexOptions = new HashMap<String, String>();
        indexOptions.put("mode", "CONTAINS");
        this.dataStore.queryBuilder().create().index("byD").ifNotExists().on(this.keyspace, this.table).column("d").custom(indexClass).options(indexOptions).build().execute(new Object[0]).join();
        Table actualTable = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        Table expectedTable = Schema.build().keyspace(this.keyspace).table(this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).column("d", (Column.ColumnType)Column.Type.Text).secondaryIndex("byB").column("b").secondaryIndex("byC").column("c").secondaryIndex("byD").column("d").indexClass(indexClass).indexOptions(indexOptions).build().keyspace(this.keyspace).table(this.table);
        Assertions.assertThat((int)actualTable.indexes().size()).isEqualTo(expectedTable.indexes().size());
        Assertions.assertThat((String)actualTable.index("byD").toString()).isEqualTo(expectedTable.index("byD").toString());
    }

    @Test
    public void testMaterializedView() {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text, Column.Kind.Clustering).withComment("test-comment1").build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().create().materializedView(this.keyspace, "test_MV").asSelect().column("b", Column.Kind.PartitionKey).column("a", Column.Kind.Clustering).from(this.keyspace, this.table).withComment("test-comment2").build().execute(new Object[0]).join();
        MaterializedView mv = this.dataStore.schema().keyspace(this.keyspace).materializedView("test_MV");
        Assertions.assertThat((Object)mv).isNotNull();
        Assertions.assertThat((String)mv.name()).isEqualTo("test_MV");
        Assertions.assertThat((String)mv.comment()).isEqualTo("test-comment2");
        Assertions.assertThat((List)mv.columns()).hasSize(2);
        Assertions.assertThat((Comparable)mv.column("b").kind()).isEqualTo((Object)Column.Kind.PartitionKey);
        Assertions.assertThat((Object)mv.column("b").type()).isEqualTo((Object)Column.Type.Text);
        Assertions.assertThat((Comparable)mv.column("a").kind()).isEqualTo((Object)Column.Kind.Clustering);
        Assertions.assertThat((Object)mv.column("a").type()).isEqualTo((Object)Column.Type.Int);
    }

    @Disabled(value="Disabling for now since it currently just hangs")
    @Test
    public void testTupleWithAllSimpleTypes() throws UnknownHostException, ExecutionException, InterruptedException {
        ImmutableMap<Column.ColumnType, Object> typeToValue = this.getSimpleTypesWithValues();
        ArrayList columns = new ArrayList(typeToValue.size());
        typeToValue.forEach((type, value) -> columns.add(Column.create((String)type.name().toLowerCase(), (Column.ColumnType)type)));
        Keyspace ks = this.createKeyspace();
        ImmutableTupleType tupleType = ImmutableTupleType.builder().addAllParameters(typeToValue.keySet()).build();
        this.dataStore.queryBuilder().create().table(ks.name(), this.table).ifNotExists().column("x", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("my_tuple", (Column.ColumnType)tupleType).build().execute(new Object[0]).join();
        Object[] actualValues = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            actualValues[i] = typeToValue.get(((Column)columns.get(i)).type());
        }
        this.dataStore.queryBuilder().insertInto(ks.name(), this.table).value("x", (Object)1).value("my_tuple", (Object)tupleType.create(actualValues)).build().execute(new Object[0]).join();
        List rows = ((ResultSet)this.dataStore.queryBuilder().select().star().from(ks.name(), this.table).where("x", Predicate.EQ, (Object)1).build().execute(new Object[0]).join()).rows();
        Assertions.assertThat((List)rows).isNotEmpty();
        Row row = (Row)rows.get(0);
        TupleValue tupleValue = row.getTupleValue("my_tuple");
        Assertions.assertThat((Object)tupleValue).isNotNull();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            Assertions.assertThat((Object)tupleValue.get(i, Objects.requireNonNull(column.type()).codec())).isEqualTo(typeToValue.get(column.type()));
        }
    }

    @Test
    public void testUDTWithAllSimpleTypes() throws UnknownHostException, ExecutionException, InterruptedException {
        ImmutableMap<Column.ColumnType, Object> typeToValue = this.getSimpleTypesWithValues();
        ArrayList columns = new ArrayList(typeToValue.size());
        typeToValue.forEach((type, value) -> columns.add(Column.create((String)type.name().toLowerCase(), (Column.ColumnType)type)));
        Keyspace ks = this.createKeyspace();
        String typeName = "my_type";
        ImmutableUserDefinedType udtType = ImmutableUserDefinedType.builder().name(typeName).keyspace(ks.name()).addAllColumns(columns).build();
        this.dataStore.queryBuilder().create().type(this.keyspace, (UserDefinedType)udtType).build().execute(new Object[0]).join();
        ks = this.dataStore.schema().keyspace(ks.name());
        this.dataStore.queryBuilder().create().table(ks.name(), this.table).ifNotExists().column("x", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("udt", ks.userDefinedType(typeName).frozen()).build().execute(new Object[0]).join();
        Object[] actualValues = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            actualValues[i] = typeToValue.get(((Column)columns.get(i)).type());
        }
        this.dataStore.queryBuilder().insertInto(ks.name(), this.table).value("x", (Object)1).value("udt", (Object)ks.userDefinedType(typeName).create(actualValues)).build().execute(new Object[0]).join();
        List rows = ((ResultSet)this.dataStore.queryBuilder().select().star().from(ks.name(), this.table).where("x", Predicate.EQ, (Object)1).build().execute(new Object[0]).join()).rows();
        Assertions.assertThat((List)rows).isNotEmpty();
        Row row = (Row)rows.get(0);
        UdtValue udtValue = row.getUdtValue("udt");
        Assertions.assertThat((Object)udtValue).isNotNull();
        columns.forEach(c -> Assertions.assertThat((Object)udtValue.get(c.name().toLowerCase(), Objects.requireNonNull(c.type()).codec())).isEqualTo(typeToValue.get(c.type())));
    }

    private ImmutableMap<Column.ColumnType, Object> getSimpleTypesWithValues() throws UnknownHostException {
        return ImmutableMap.builder().put((Object)Column.Type.Ascii, (Object)"hi").put((Object)Column.Type.Bigint, (Object)23L).put((Object)Column.Type.Blob, (Object)ByteBuffer.wrap(new byte[]{2, 3})).put((Object)Column.Type.Boolean, (Object)true).put((Object)Column.Type.Date, (Object)LocalDate.ofEpochDay(34L)).put((Object)Column.Type.Decimal, (Object)BigDecimal.valueOf(2.3)).put((Object)Column.Type.Double, (Object)3.8).put((Object)Column.Type.Duration, (Object)CqlDuration.newInstance((int)2, (int)3, (long)5L)).put((Object)Column.Type.Float, (Object)Float.valueOf(4.9f)).put((Object)Column.Type.Inet, (Object)Inet4Address.getByAddress(new byte[]{2, 3, 4, 5})).put((Object)Column.Type.Int, (Object)4).put((Object)Column.Type.Smallint, (Object)7).put((Object)Column.Type.Text, (Object)"some text").put((Object)Column.Type.Time, (Object)LocalTime.ofSecondOfDay(20L)).put((Object)Column.Type.Timestamp, (Object)Instant.ofEpochSecond(3L)).put((Object)Column.Type.Timeuuid, (Object)Uuids.timeBased()).put((Object)Column.Type.Tinyint, (Object)4).put((Object)Column.Type.Uuid, (Object)Uuids.random()).put((Object)Column.Type.Varint, (Object)BigInteger.valueOf(23L)).build();
    }

    @Disabled(value="Disabling for now since it currently just hangs")
    @Test
    public void testUDT() throws ExecutionException, InterruptedException {
        Keyspace ks = this.createKeyspace();
        String typeName = "my_type";
        ImmutableUserDefinedType udtType = ImmutableUserDefinedType.builder().name(typeName).keyspace(ks.name()).addColumns(new Column[]{Column.create((String)"a", (Column.ColumnType)Column.Type.Int), Column.create((String)"mylist", (Column.ColumnType)Column.Type.List.of(new Column.ColumnType[]{Column.Type.Double})), Column.create((String)"myset", (Column.ColumnType)Column.Type.Set.of(new Column.ColumnType[]{Column.Type.Double})), Column.create((String)"mymap", (Column.ColumnType)Column.Type.Map.of(new Column.ColumnType[]{Column.Type.Text, Column.Type.Int})), Column.create((String)"mytuple", (Column.ColumnType)Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Int, Column.Type.Double})}))}).build();
        this.dataStore.queryBuilder().create().type(this.keyspace, (UserDefinedType)udtType).build().execute(new Object[0]).join();
        ks = this.dataStore.schema().keyspace(ks.name());
        Column.ColumnType nestedTuple = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Int, Column.Type.Double});
        Column.ColumnType tupleType = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, nestedTuple});
        this.dataStore.queryBuilder().create().table(ks.name(), this.table).ifNotExists().column("x", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("udt", ks.userDefinedType(typeName).frozen()).build().execute(new Object[0]).join();
        List<Double> list = Arrays.asList(3.0, 4.5);
        ImmutableMap map = ImmutableMap.of((Object)"Alice", (Object)3, (Object)"Bob", (Object)4);
        ImmutableSet set = ImmutableSet.of((Object)3.4, (Object)5.3);
        Object tuple = tupleType.create(new Object[]{"Test", nestedTuple.create(new Object[]{2, 3.0})});
        this.dataStore.queryBuilder().insertInto(ks.name(), this.table).value("x", (Object)1).value("udt", (Object)ks.userDefinedType(typeName).create(new Object[]{23, list, set, map, tuple})).build().execute(new Object[0]).join();
        List rows = ((ResultSet)this.dataStore.queryBuilder().select().star().from(ks.name(), this.table).where("x", Predicate.EQ, (Object)1).build().execute(new Object[0]).join()).rows();
        Assertions.assertThat((List)rows).isNotEmpty();
    }

    @Disabled(value="Disabling for now since it currently just hangs")
    @Test
    public void testTupleMismatch() throws ExecutionException, InterruptedException {
        Keyspace ks = this.createKeyspace();
        Column.ColumnType nested = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, Column.Type.Double});
        Column.ColumnType tupleType = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, nested});
        Column.ColumnType alternativeNested = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Int, Column.Type.Double});
        Column.ColumnType alternativeType = Column.Type.Tuple.of(new Column.ColumnType[]{Column.Type.Text, alternativeNested});
        this.dataStore.queryBuilder().create().table(ks.name(), this.table).ifNotExists().column("x", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("tuple", tupleType).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        Object tuple = alternativeType.create(new Object[]{"Test", alternativeNested.create(new Object[]{4, 3.0})});
        this.dataStore.waitForSchemaAgreement();
        try {
            this.dataStore.queryBuilder().insertInto(ks.name(), this.table).value("x", (Object)1).value("tuple", tuple).build().execute(new Object[0]).join();
            Fail.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException ex) {
            Assertions.assertThat((Throwable)ex).hasMessage("Wrong value type provided for column 'tuple'. Provided type 'Integer' is not compatible with expected CQL type 'Text' at location 'tuple.frozen<tuple<Text, frozen<tuple<Text, double>>>>[1].frozen<tuple<Text, double>>[0]'.");
        }
    }

    @Test
    public void testOrdinaryTypeMismatch() throws ExecutionException, InterruptedException {
        Keyspace ks = this.createKeyspace();
        this.dataStore.queryBuilder().create().table(ks.name(), this.table).ifNotExists().column("x", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            ResultSet cfr_ignored_0 = (ResultSet)this.dataStore.queryBuilder().insertInto(ks.name(), this.table).value("x", (Object)1).value("name", (Object)42).build().execute(new Object[0]).join();
        }).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Invalid value provided for 'name': Java value 42 of type 'java.lang.Integer' is not a valid value for CQL type text");
    }

    @Disabled(value="Disabling for now since it fails with a strange MV schema generated")
    @Test
    public void testMvIndexes() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().create().materializedView(this.keyspace, "byB").asSelect().column("b", Column.Kind.PartitionKey).column("a", Column.Kind.Clustering, Column.Order.DESC).column("c").from(this.keyspace, this.table).build().execute(new Object[0]).join();
        Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table)).isEqualTo((Object)Schema.build().keyspace(this.keyspace).table(this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).materializedView("byB").column("b", Column.Kind.PartitionKey).column("a", Column.Kind.Clustering, Column.Order.DESC).column("c").build().keyspace(this.keyspace).table(this.table));
        this.dataStore.queryBuilder().create().materializedView(this.keyspace, "byC").asSelect().column("c", Column.Kind.PartitionKey).column("a", Column.Kind.Clustering, Column.Order.ASC).column("b").from(this.keyspace, this.table).build().execute(new Object[0]).join();
        Assertions.assertThat((Object)this.dataStore.schema().keyspace(this.keyspace).table(this.table)).isEqualTo((Object)Schema.build().keyspace(this.keyspace).table(this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Text).column("c", (Column.ColumnType)Column.Type.Uuid).materializedView("byB").column("b", Column.Kind.PartitionKey).column("a", Column.Kind.Clustering, Column.Order.DESC).column("c").materializedView("byC").column("c", Column.Kind.PartitionKey).column("a", Column.Kind.Clustering, Column.Order.ASC).column("b").build().keyspace(this.keyspace).table(this.table));
    }

    @Test
    public void testPagination() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).build().execute(new Object[0]).join();
        HashSet<Integer> knownValues = new HashSet<Integer>();
        int pageSize = 50;
        int totalResultSize = pageSize * 2 + 3;
        for (int i = 1; i <= totalResultSize; ++i) {
            knownValues.add(i);
            this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("a", (Object)i).build().execute(new Object[0]).join();
        }
        ResultSet resultSet = (ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).build().execute(new Object[0]).join();
        Iterator it = resultSet.iterator();
        this.iterateOverResults(it, knownValues, pageSize);
        this.iterateOverResults(it, knownValues, pageSize);
        this.iterateOverResults(it, knownValues, 3);
        Assertions.assertThat((Iterator)it).isExhausted();
        Assertions.assertThat(knownValues).isEmpty();
    }

    private void iterateOverResults(Iterator<Row> it, Set<Integer> knownValues, int pageSize) {
        for (int i = 1; i <= pageSize; ++i) {
            Assertions.assertThat((boolean)knownValues.remove(it.next().getInt("a"))).isTrue();
        }
    }

    @Test
    public void testINClause() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).build().execute(new Object[0]).join();
        for (int i = 0; i < 10; ++i) {
            this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("a", (Object)i).build().execute(new Object[0]).join();
        }
        HashSet<Integer> set = new HashSet<Integer>(Arrays.asList(1, 3, 5, 7));
        ResultSet resultSet = (ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).where("a", Predicate.IN, Arrays.asList(1, 3, 5, 7)).build().execute(new Object[0]).join();
        resultSet.iterator().forEachRemaining(row -> Assertions.assertThat((boolean)set.remove(row.getInt("a"))).isTrue());
        Assertions.assertThat(set).isEmpty();
    }

    @Test
    public void testWithUnsetParameter() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("a", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("b", (Column.ColumnType)Column.Type.Int).build().execute(new Object[0]).join();
        Table tbl = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        this.dataStore.queryBuilder().insertInto(tbl).value("a").value("b").build().execute(new Object[]{23, TypedValue.UNSET}).get();
        ResultSet resultSet = (ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).where("a", Predicate.EQ, (Object)23).build().execute(new Object[0]).join();
        Assertions.assertThat((Iterable)resultSet).isNotEmpty();
    }

    @Test
    public void testDeleteCell() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("graph", (Object)true).value("name", (Object)"Bob").build().execute(new Object[0]).join();
        Row row = ((ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).build().execute(new Object[0]).join()).one();
        Assertions.assertThat((boolean)row.getBoolean("graph")).isTrue();
        Assertions.assertThat((String)row.getString("name")).isEqualTo("Bob");
        this.dataStore.queryBuilder().update(this.keyspace, this.table).value("name", null).where("graph", Predicate.EQ, (Object)true).build().execute(new Object[0]).join();
        row = ((ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).build().execute(new Object[0]).join()).one();
        Assertions.assertThat((boolean)row.getBoolean("graph")).isTrue();
        Assertions.assertThat((boolean)row.isNull("name")).isEqualTo(true);
    }

    @Test
    public void testPrepStmtCacheInvalidation() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("graph", (Object)true).value("name", (Object)"Bob").build().execute(new Object[0]).join();
        Keyspace ks = this.dataStore.schema().keyspace(this.keyspace);
        Table tbl = ks.table(this.table);
        Row row = ((ResultSet)this.dataStore.queryBuilder().select().star().from((AbstractTable)tbl).build().execute(new Object[0]).join()).one();
        Assertions.assertThat((boolean)row.getBoolean("graph")).isTrue();
        Assertions.assertThat((String)row.getString("name")).isEqualTo("Bob");
        this.dataStore.queryBuilder().drop().keyspace(ks.name()).build().execute(new Object[0]).join();
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("graph", (Object)true).value("name", (Object)"Bob").build().execute(new Object[0]).join();
        ks = this.dataStore.schema().keyspace(this.keyspace);
        tbl = ks.table(this.table);
        row = ((ResultSet)this.dataStore.queryBuilder().select().star().from((AbstractTable)tbl).build().execute(new Object[0]).join()).one();
        Assertions.assertThat((boolean)row.getBoolean("graph")).isTrue();
        Assertions.assertThat((String)row.getString("name")).isEqualTo("Bob");
    }

    @Test
    public void testKeyspaceReplicationAndDurableWrites() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        Keyspace ks = this.dataStore.schema().keyspace(this.keyspace);
        Assertions.assertThat((Map)ks.replication()).isEqualTo((Object)ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.locator.SimpleStrategy", (Object)"replication_factor", (Object)"1"));
        ((OptionalAssert)Assertions.assertThat((Optional)ks.durableWrites()).isPresent()).contains((Object)true);
    }

    @Test
    public void testTableCommentSelect() {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).withComment("This is a table").build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        Table theTable = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        Assertions.assertThat((String)theTable.comment()).isEqualTo("This is a table");
        this.dataStore.queryBuilder().alter().table(this.keyspace, this.table).withComment("This is still a table").build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        theTable = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        Assertions.assertThat((String)theTable.comment()).isEqualTo("This is still a table");
    }

    @Test
    public void testTableDefaultTTL() {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("id", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).withDefaultTTL(1234).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        Table theTable = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        Assertions.assertThat((int)theTable.ttl()).isEqualTo(1234);
        this.dataStore.queryBuilder().alter().table(this.keyspace, this.table).withDefaultTTL(5000).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        theTable = this.dataStore.schema().keyspace(this.keyspace).table(this.table);
        Assertions.assertThat((int)theTable.ttl()).isEqualTo(5000);
    }

    @Test
    public void testInsertWithTTL() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("graph", (Object)true).ttl(Integer.valueOf(2)).build().execute(new Object[0]).join();
    }

    @Test
    public void testUpdateWithTTL() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).column("name", (Column.ColumnType)Column.Type.Text).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().update(this.keyspace, this.table).ttl(Integer.valueOf(2)).value("name", (Object)"Bif").where("graph", Predicate.EQ, (Object)true).build().execute(new Object[0]).join();
    }

    @Test
    public void testCqlExecutionInfo() throws ExecutionException, InterruptedException {
        Keyspace ks = this.createKeyspace();
        this.dataStore.queryBuilder().create().table(ks.name(), this.table).ifNotExists().column("x", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).build().execute(new Object[0]).join();
        this.dataStore.queryBuilder().insertInto(ks.name(), this.table).value("x", (Object)1).build().execute(new Object[0]).join();
        ResultSet resultSet = (ResultSet)this.dataStore.queryBuilder().select().star().from(ks.name(), this.table).where("x", Predicate.EQ, (Object)1).build().execute(new Object[0]).join();
        List rows = resultSet.rows();
        Assertions.assertThat((List)rows).isNotEmpty();
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
    }

    @Test
    public void testSimpleSelectStmt() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("graph", (Column.ColumnType)Column.Type.Boolean, Column.Kind.PartitionKey).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        ResultSet insert = (ResultSet)this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("graph", (Object)true).build().execute(new Object[0]).join();
        Assertions.assertThat((boolean)insert.waitedForSchemaAgreement()).isFalse();
        ResultSet select = (ResultSet)this.dataStore.queryBuilder().select().star().from(this.keyspace, this.table).build().execute(new Object[0]).join();
        Assertions.assertThat((boolean)select.waitedForSchemaAgreement()).isFalse();
        Assertions.assertThat((boolean)select.hasNoMoreFetchedRows()).isFalse();
        Assertions.assertThat((boolean)select.one().getBoolean("graph")).isTrue();
    }

    @Test
    public void testLimit() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("pk", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("cc", (Column.ColumnType)Column.Type.Int, Column.Kind.Clustering).column("val", (Column.ColumnType)Column.Type.Int).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        BuiltQuery insert = this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("pk").value("cc").value("val").build();
        ((AbstractBound)insert.bind(new Object[]{10, 1, 1})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{10, 2, 2})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 3, 3})).execute().join();
        BuiltQuery select = this.dataStore.queryBuilder().select().column("val").from(this.keyspace, this.table).limit().build();
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{1})).execute().get()).rows()).hasSize(1);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{2})).execute().get()).rows()).hasSize(2);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{10})).execute().get()).rows()).hasSize(3);
        Assertions.assertThat((List)((ResultSet)this.dataStore.queryBuilder().select().column("val").from(this.keyspace, this.table).limit(Integer.valueOf(2)).build().execute(new Object[0]).get()).rows()).hasSize(2);
    }

    @Test
    public void testPerPartitionLimit() throws ExecutionException, InterruptedException {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("pk", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("cc", (Column.ColumnType)Column.Type.Int, Column.Kind.Clustering).column("val", (Column.ColumnType)Column.Type.Int).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        BuiltQuery insert = this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("pk").value("cc").value("val").build();
        ((AbstractBound)insert.bind(new Object[]{10, 1, 1})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{10, 2, 2})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{10, 3, 3})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 4, 4})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 5, 5})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 6, 6})).execute().join();
        BuiltQuery select = this.dataStore.queryBuilder().select().column("val").from(this.keyspace, this.table).perPartitionLimit().build();
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{1})).execute().get()).rows()).hasSize(2);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{2})).execute().get()).rows()).hasSize(4);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{10})).execute().get()).rows()).hasSize(6);
        Assertions.assertThat((List)((ResultSet)this.dataStore.queryBuilder().select().column("val").from(this.keyspace, this.table).perPartitionLimit(Integer.valueOf(2)).build().execute(new Object[0]).get()).rows()).hasSize(4);
        Assertions.assertThat((List)((ResultSet)this.dataStore.queryBuilder().select().column("val").from(this.keyspace, this.table).perPartitionLimit(Integer.valueOf(3)).limit(Integer.valueOf(2)).build().execute(new Object[0]).get()).rows()).hasSize(2);
        select = this.dataStore.queryBuilder().select().column("val").from(this.keyspace, this.table).perPartitionLimit().limit().build();
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{1, 10})).execute().get()).rows()).hasSize(2);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{1, 1})).execute().get()).rows()).hasSize(1);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{2, 10})).execute().get()).rows()).hasSize(4);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{2, 3})).execute().get()).rows()).hasSize(3);
        Assertions.assertThat((List)((ResultSet)((AbstractBound)select.bind(new Object[]{10, 10})).execute().get()).rows()).hasSize(6);
    }

    private Keyspace createKeyspace() {
        this.dataStore.queryBuilder().create().keyspace(this.keyspace).ifNotExists().withReplication(Replication.simpleStrategy((int)1)).andDurableWrites(true).build().execute(new Object[0]).join();
        Keyspace keyspace = this.dataStore.schema().keyspace(this.keyspace);
        Assertions.assertThat((Object)keyspace).isNotNull();
        Assertions.assertThat((String)keyspace.name()).isEqualTo(this.keyspace);
        Assertions.assertThat((Collection)keyspace.tables()).isEmpty();
        Assertions.assertThat((Map)keyspace.replication()).isEqualTo((Object)ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.locator.SimpleStrategy", (Object)"replication_factor", (Object)"1"));
        ((OptionalAssert)Assertions.assertThat((Optional)keyspace.durableWrites()).isPresent()).contains((Object)true);
        this.dataStore.waitForSchemaAgreement();
        return keyspace;
    }

    private static Result execute(Persistence.Connection connection, String query, ByteBuffer ... values) throws ExecutionException, InterruptedException {
        return (Result)connection.execute((Statement)new SimpleStatement(query, Arrays.asList(values)), Parameters.defaults(), System.nanoTime()).get();
    }

    @Test
    public void testWarnings() throws ExecutionException, InterruptedException {
        Keyspace ks = this.createKeyspace();
        Persistence.Connection conn = this.persistence().newConnection();
        PersistenceTest.execute(conn, "USE " + ks.cqlName(), new ByteBuffer[0]);
        PersistenceTest.execute(conn, "CREATE TABLE t (k int PRIMARY KEY)", new ByteBuffer[0]);
        conn.waitForSchemaAgreement();
        ByteBuffer ttl = Column.Type.Int.codec().encode((Object)630720000, ProtocolVersion.DEFAULT);
        Result result = PersistenceTest.execute(conn, "INSERT INTO t (k) VALUES (0) USING TTL ?", ttl);
        Assertions.assertThat((List)result.getWarnings()).hasSize(1);
        Assertions.assertThat((String)((String)result.getWarnings().get(0))).contains(new CharSequence[]{"exceeds maximum supported expiration"});
    }

    @Test
    public void testSchemaAgreementAchievable() {
        Assertions.assertThat((boolean)this.persistence().isSchemaAgreementAchievable()).isTrue();
    }

    private void setupCustomPagingData() {
        this.createKeyspace();
        this.dataStore.queryBuilder().create().table(this.keyspace, this.table).column("pk", (Column.ColumnType)Column.Type.Int, Column.Kind.PartitionKey).column("cc", (Column.ColumnType)Column.Type.Int, Column.Kind.Clustering).column("val", (Column.ColumnType)Column.Type.Int).build().execute(new Object[0]).join();
        this.dataStore.waitForSchemaAgreement();
        BuiltQuery insert = this.dataStore.queryBuilder().insertInto(this.keyspace, this.table).value("pk").value("cc").value("val").build();
        ((AbstractBound)insert.bind(new Object[]{10, 1, 1})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{10, 2, 2})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{10, 3, 3})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{10, 4, 4})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 5, 5})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 6, 6})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 7, 7})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{20, 8, 8})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{30, 9, 9})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{30, 10, 10})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{30, 11, 11})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{30, 12, 12})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{40, 13, 13})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{40, 14, 14})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{40, 15, 15})).execute().join();
        ((AbstractBound)insert.bind(new Object[]{40, 16, 16})).execute().join();
    }

    @Test
    public void testPagingStateForNextPartition() throws ExecutionException, InterruptedException {
        this.setupCustomPagingData();
        AbstractBound selectAll = (AbstractBound)this.dataStore.queryBuilder().select().column("pk").column("val").from(this.keyspace, this.table).build().bind(new Object[0]);
        List allRows = ((ResultSet)this.dataStore.execute((BoundQuery)selectAll).get()).rows();
        List keys = allRows.stream().map(r -> r.getInt(0)).collect(Collectors.toList());
        List values = allRows.stream().map(r -> r.getInt(1)).collect(Collectors.toList());
        int key2 = (Integer)keys.get(1);
        int val2 = (Integer)values.get(1);
        int key5 = (Integer)keys.get(4);
        int val5 = (Integer)values.get(4);
        int key6 = (Integer)keys.get(5);
        int val6 = (Integer)values.get(5);
        int key10 = (Integer)keys.get(9);
        int val10 = (Integer)values.get(9);
        AbstractBound select = (AbstractBound)this.dataStore.queryBuilder().select().column("pk").column("val").from(this.keyspace, this.table).perPartitionLimit(Integer.valueOf(3)).limit(Integer.valueOf(10)).build().bind(new Object[0]);
        ResultSet rs = (ResultSet)this.dataStore.execute((BoundQuery)select, p -> p.toBuilder().pageSize(5).build()).get();
        List rows = rs.currentPageRows();
        Assertions.assertThat((List)rows).hasSize(5);
        Row row2 = (Row)rows.get(1);
        Assertions.assertThat((int)row2.getInt(0)).isEqualTo(key2);
        Assertions.assertThat((int)row2.getInt(1)).isEqualTo(val2);
        Row row6 = (Row)rows.get(4);
        Assertions.assertThat((int)row6.getInt(0)).isEqualTo(key6);
        Assertions.assertThat((int)row6.getInt(1)).isEqualTo(val6);
        ByteBuffer pagingState = rs.makePagingState((PagingPosition)PagingPosition.ofCurrentRow((Row)row2).resumeFrom(PagingPosition.ResumeMode.NEXT_PARTITION).remainingRows(7).build());
        rs = (ResultSet)this.dataStore.execute((BoundQuery)select, p -> p.toBuilder().pageSize(5).pagingState(pagingState).build()).get();
        rows = rs.currentPageRows();
        Assertions.assertThat((List)rows).hasSize(5);
        Row row5 = (Row)rows.get(0);
        Assertions.assertThat((int)row5.getInt(0)).isEqualTo(key5);
        Assertions.assertThat((int)row5.getInt(1)).isEqualTo(val5);
        Row row10 = (Row)rows.get(4);
        Assertions.assertThat((int)row10.getInt(0)).isEqualTo(key10);
        Assertions.assertThat((int)row10.getInt(1)).isEqualTo(val10);
        Assertions.assertThat((List)rs.rows()).hasSize(2);
    }

    @Test
    public void testPagingStateForNextRow() throws ExecutionException, InterruptedException {
        this.setupCustomPagingData();
        AbstractBound selectAll = (AbstractBound)this.dataStore.queryBuilder().select().column("pk").column("val").from(this.keyspace, this.table).build().bind(new Object[0]);
        List allRows = ((ResultSet)this.dataStore.execute((BoundQuery)selectAll).get()).rows();
        List keys = allRows.stream().map(r -> r.getInt(0)).collect(Collectors.toList());
        List values = allRows.stream().map(r -> r.getInt(1)).collect(Collectors.toList());
        int key2 = (Integer)keys.get(1);
        int val2 = (Integer)values.get(1);
        int key3 = (Integer)keys.get(2);
        int val3 = (Integer)values.get(2);
        int key6 = (Integer)keys.get(5);
        int val6 = (Integer)values.get(5);
        int key8 = (Integer)keys.get(8);
        int val8 = (Integer)values.get(8);
        AbstractBound select = (AbstractBound)this.dataStore.queryBuilder().select().column("pk").column("cc").column("val").from(this.keyspace, this.table).perPartitionLimit(Integer.valueOf(3)).limit(Integer.valueOf(10)).build().bind(new Object[0]);
        ResultSet rs = (ResultSet)this.dataStore.execute((BoundQuery)select, p -> p.toBuilder().pageSize(5).build()).get();
        List rows = rs.currentPageRows();
        Assertions.assertThat((List)rows).hasSize(5);
        Row row2 = (Row)rows.get(1);
        Assertions.assertThat((int)row2.getInt(0)).isEqualTo(key2);
        Assertions.assertThat((int)row2.getInt(1)).isEqualTo(val2);
        Row row6 = (Row)rows.get(4);
        Assertions.assertThat((int)row6.getInt(0)).isEqualTo(key6);
        Assertions.assertThat((int)row6.getInt(1)).isEqualTo(val6);
        ByteBuffer pagingState = rs.makePagingState((PagingPosition)PagingPosition.ofCurrentRow((Row)row2).resumeFrom(PagingPosition.ResumeMode.NEXT_ROW).remainingRows(7).remainingRowsInPartition(1).build());
        rs = (ResultSet)this.dataStore.execute((BoundQuery)select, p -> p.toBuilder().pageSize(5).pagingState(pagingState).build()).get();
        rows = rs.currentPageRows();
        Assertions.assertThat((List)rows).hasSize(5);
        Row row3 = (Row)rows.get(0);
        Assertions.assertThat((int)row3.getInt(0)).isEqualTo(key3);
        Assertions.assertThat((int)row3.getInt(1)).isEqualTo(val3);
        Row row8 = (Row)rows.get(4);
        Assertions.assertThat((int)row8.getInt(0)).isEqualTo(key8);
        Assertions.assertThat((int)row8.getInt(1)).isEqualTo(val8);
        Assertions.assertThat((List)rs.rows()).hasSize(2);
    }

    private void assertEq(Row r1, Row r2, RowDecorator ... decorators) {
        for (RowDecorator dec1 : decorators) {
            for (RowDecorator dec2 : decorators) {
                Assertions.assertThat((Comparable)dec1.decoratePartitionKey(r1)).isEqualTo((Object)dec2.decoratePartitionKey(r2));
                Assertions.assertThat((Comparable)dec1.decoratePartitionKey(r2)).isEqualTo((Object)dec2.decoratePartitionKey(r1));
            }
        }
        this.assertGtEq(r1, r2, decorators);
    }

    private void assertGtEq(Row r1, Row r2, RowDecorator ... decorators) {
        for (RowDecorator dec1 : decorators) {
            ComparableKey k1 = dec1.decoratePartitionKey(r1);
            ComparableKey k2 = dec1.decoratePartitionKey(r1);
            int i = k1.compareTo(k2);
            for (RowDecorator dec2 : decorators) {
                Assertions.assertThat((Comparable)dec1.decoratePartitionKey(r1)).isGreaterThanOrEqualTo((Comparable)dec2.decoratePartitionKey(r2));
                Assertions.assertThat((Comparable)dec1.decoratePartitionKey(r2)).isLessThanOrEqualTo((Comparable)dec2.decoratePartitionKey(r1));
            }
        }
    }

    private void assertGt(Row r1, Row r2, RowDecorator ... decorators) {
        for (RowDecorator dec1 : decorators) {
            for (RowDecorator dec2 : decorators) {
                Assertions.assertThat((Comparable)dec1.decoratePartitionKey(r1)).isGreaterThan((Comparable)dec2.decoratePartitionKey(r2));
                Assertions.assertThat((Comparable)dec1.decoratePartitionKey(r2)).isLessThan((Comparable)dec2.decoratePartitionKey(r1));
            }
        }
    }

    @Test
    public void testRowDecorator() throws ExecutionException, InterruptedException {
        this.setupCustomPagingData();
        AbstractBound selectAll = (AbstractBound)this.dataStore.queryBuilder().select().column("pk").column("val").from(this.keyspace, this.table).build().bind(new Object[0]);
        ResultSet rs1 = (ResultSet)this.dataStore.execute((BoundQuery)selectAll).get();
        Iterator it1 = rs1.iterator();
        RowDecorator dec1 = rs1.makeRowDecorator();
        ResultSet rs2 = (ResultSet)this.dataStore.execute((BoundQuery)selectAll).get();
        RowDecorator dec2 = rs2.makeRowDecorator();
        Iterator it2 = rs2.iterator();
        Row first = null;
        Row last = null;
        Row p1 = null;
        while (it1.hasNext()) {
            Assertions.assertThat((boolean)it2.hasNext()).isTrue();
            Row r1 = (Row)it1.next();
            Row r2 = (Row)it2.next();
            first = first == null ? r1 : first;
            last = r1;
            this.assertEq(r1, r2, dec1, dec2);
            if (p1 == null) {
                p1 = r1;
            }
            this.assertGtEq(r1, p1, dec1, dec2);
        }
        Assertions.assertThat((boolean)it2.hasNext()).isFalse();
        this.assertGt(last, first, dec1, dec2);
    }

    @Test
    public void testRowDecoratorComparableBytes() throws ExecutionException, InterruptedException {
        this.setupCustomPagingData();
        AbstractBound selectAll = (AbstractBound)this.dataStore.queryBuilder().select().column("pk").column("val").from(this.keyspace, this.table).build().bind(new Object[0]);
        ResultSet rs1 = (ResultSet)this.dataStore.execute((BoundQuery)selectAll).get();
        Iterator it1 = rs1.iterator();
        RowDecorator dec1 = rs1.makeRowDecorator();
        ResultSet rs2 = (ResultSet)this.dataStore.execute((BoundQuery)selectAll).get();
        RowDecorator dec2 = rs2.makeRowDecorator();
        Iterator it2 = rs2.iterator();
        Row first = null;
        Row last = null;
        Row p1 = null;
        FastByteOperations.PureJavaOperations ops = new FastByteOperations.PureJavaOperations();
        while (it1.hasNext()) {
            Assertions.assertThat((boolean)it2.hasNext()).isTrue();
            Row rowIterator1 = (Row)it1.next();
            Row rowIterator2 = (Row)it2.next();
            first = first == null ? rowIterator1 : first;
            last = rowIterator1;
            ByteBuffer bytesRow1 = dec1.getComparableBytes(rowIterator1);
            ByteBuffer bytesRow2 = dec2.getComparableBytes(rowIterator2);
            Assertions.assertThat((int)ops.compare(bytesRow1, bytesRow2)).isEqualTo(0);
            if (p1 == null) {
                p1 = rowIterator1;
            }
            Assertions.assertThat((int)ops.compare(bytesRow1, dec2.getComparableBytes(p1))).isGreaterThanOrEqualTo(0);
        }
        Assertions.assertThat((boolean)it2.hasNext()).isFalse();
        ByteBuffer lastBytes = dec1.getComparableBytes(last);
        ByteBuffer firstBytes = dec2.getComparableBytes(first);
        Assertions.assertThat((int)ops.compare(lastBytes, firstBytes)).isGreaterThan(0);
    }

    private boolean isCassandra4() {
        return !this.backend.isDse() && Version.parse((String)this.backend.clusterVersion()).nextStable().compareTo(Version.V4_0_0) >= 0;
    }

    private static /* synthetic */ Stream lambda$testInsertingAndReadingDifferentTypes$0(List values) {
        return values.stream().map(Pair::getValue0).distinct();
    }

    static {
        System.setProperty("cassandra.expiration_date_overflow_policy", "CAP");
    }
}

