/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.it.storage;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.stargate.it.exec.ProcessRunner;
import io.stargate.it.storage.ClusterConnectionInfo;
import io.stargate.it.storage.ClusterSpec;
import io.stargate.it.storage.ExternalResource;
import io.stargate.it.storage.ShutdownHook;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalStorage
extends ExternalResource<ClusterSpec, Cluster>
implements ParameterResolver,
BeforeTestExecutionCallback,
TestExecutionExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalStorage.class);
    public static final String STORE_KEY = "stargate-storage";
    private static final String CCM_VERSION = "ccm.version";
    private static final boolean EXTERNAL_BACKEND = Boolean.getBoolean("stargate.test.backend.use.external");
    private static final String DATACENTER = System.getProperty("stargate.test.backend.dc", "dc1");
    private static final String CLUSTER_NAME = System.getProperty("stargate.test.backend.cluster_name", "Test_Cluster");
    private static final String CLUSTER_IMPL_CLASS_NAME = System.getProperty("stargate.test.backend.cluster.impl.class", CcmCluster.class.getName());

    public ExternalStorage() {
        super(ClusterSpec.class, STORE_KEY, ExtensionContext.Namespace.GLOBAL);
    }

    private Cluster createCluster(ClusterSpec spec, ExtensionContext context) {
        try {
            Class<?> cl = Class.forName(CLUSTER_IMPL_CLASS_NAME);
            Constructor<?> constructor = cl.getConstructor(ClusterSpec.class, ExtensionContext.class);
            return (Cluster)constructor.newInstance(spec, context);
        }
        catch (Throwable e) {
            LOG.error("Unable to create cluster object of type {}", (Object)CLUSTER_IMPL_CLASS_NAME, (Object)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected boolean isShared(ClusterSpec spec) {
        return spec.shared();
    }

    @Override
    protected Optional<Cluster> processResource(Cluster current, ClusterSpec spec, ExtensionContext context) {
        if (current != null) {
            if (current.spec.equals(spec)) {
                LOG.info("Reusing matching storage cluster {} for {}", (Object)spec, (Object)context.getUniqueId());
                return Optional.empty();
            }
            LOG.info("Closing old cluster due to spec mismatch within {}", (Object)context.getUniqueId());
            current.close();
        }
        LOG.info("Creating storage cluster {} for {}", (Object)spec, (Object)context.getUniqueId());
        Cluster c = this.createCluster(spec, context);
        c.start();
        return Optional.of(c);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == ClusterConnectionInfo.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.getResource(extensionContext).orElseThrow(() -> new IllegalStateException("Cluster not available"));
    }

    public void beforeTestExecution(ExtensionContext context) {
        LOG.info("About to run {} with storage cluster {}", (Object)context.getUniqueId(), (Object)this.getResource(context).map(Cluster::infoForTestLog).orElse("[missing]"));
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        if (throwable instanceof TestAbortedException || "AssumptionViolatedException".equals(throwable.getClass().getSimpleName())) {
            LOG.warn("Test skipped due to failed Assume in {}: {}", (Object)context.getUniqueId(), (Object)throwable.getMessage());
            this.getResource(context).ifPresent(rec$ -> ((Cluster)rec$).markSkippedTest());
        } else {
            LOG.warn("Test error in {}", (Object)context.getUniqueId(), (Object)throwable);
            this.getResource(context).ifPresent(rec$ -> ((Cluster)rec$).markErroredTest());
        }
        throw throwable;
    }

    static {
        String version = System.getProperty(CCM_VERSION, "3.11.19");
        System.setProperty(CCM_VERSION, version);
    }

    private static class StorageNode
    extends ProcessRunner {
        private final CcmCluster cluster;
        private final CommandLine cmd;
        private final String readMessage;
        private final File cassandraConf;
        private final File nodeDir;
        private final File logDir;
        private final File binDir;

        private StorageNode(CcmCluster cluster, int nodeIndex) {
            super("Storage", 0, nodeIndex);
            File startScript;
            this.cluster = cluster;
            Path configDir = cluster.configDirectory();
            File clusterDir = new File(configDir.toFile(), "ccm_1");
            this.nodeDir = new File(clusterDir, "node" + (1 + nodeIndex));
            this.cassandraConf = cluster.isDse() ? new File(this.nodeDir, "resources/cassandra/conf") : new File(this.nodeDir, "conf");
            this.logDir = new File(this.nodeDir, "logs");
            this.binDir = new File(this.nodeDir, "bin");
            if (cluster.isDse()) {
                this.readMessage = "DSE startup complete";
                startScript = new File(this.binDir, "dse");
            } else {
                this.readMessage = "Starting listening for CQL clients";
                startScript = new File(this.binDir, "cassandra");
            }
            this.cmd = new CommandLine(startScript.getAbsolutePath());
            if (cluster.isDse()) {
                this.cmd.addArgument("cassandra");
            }
            this.cmd.addArgument("-f");
            this.cmd.addArgument("-Dcassandra.logdir=" + this.logDir.getAbsolutePath());
            this.cmd.addArgument("-Dcassandra.boot_without_jna=true");
            if (cluster.isDse()) {
                this.cmd.addArgument("-Dcassandra.migration_task_wait_in_seconds=4");
            }
            this.addStdOutListener((node, line) -> {
                if (line.contains(this.readMessage)) {
                    this.ready();
                }
            });
        }

        public void start() {
            ImmutableMap.Builder env = ImmutableMap.builder();
            env.put((Object)"CASSANDRA_CONF", (Object)this.cassandraConf.getAbsolutePath());
            env.put((Object)"CASSANDRA_LOG_DIR", (Object)this.logDir.getAbsolutePath());
            if (this.cluster.isDse()) {
                env.put((Object)"DSE_HOME", (Object)this.cluster.installDir().getAbsolutePath());
                env.put((Object)"CASSANDRA_HOME", (Object)(this.cluster.installDir().getAbsolutePath() + "/resources/cassandra"));
                env.put((Object)"TOMCAT_HOME", (Object)new File(this.nodeDir, "resources/tomcat").getAbsolutePath());
                env.put((Object)"DSE_LOG_ROOT", (Object)(this.logDir.getAbsolutePath() + "/dse"));
                env.put((Object)"DSE_CONF", (Object)new File(this.nodeDir, "resources/dse/conf").getAbsolutePath());
            } else {
                env.put((Object)"CASSANDRA_HOME", (Object)this.cluster.installDir().getAbsolutePath());
                env.put((Object)"CASSANDRA_INCLUDE", (Object)new File(this.binDir, "cassandra.in.sh").getAbsolutePath());
            }
            this.start(this.cmd, (Map<String, String>)env.build());
        }
    }

    public static class CcmCluster
    extends Cluster {
        private final String initSite;
        private final CcmBridge ccm;
        private final List<StorageNode> nodes;
        private final AtomicBoolean removed = new AtomicBoolean();

        public CcmCluster(ClusterSpec spec, ExtensionContext context) {
            this(spec, Collections.emptyMap(), Collections.emptyMap(), context);
        }

        public CcmCluster(ClusterSpec spec, Map<String, Object> cassandraConfig, Map<String, Object> dseConfig, ExtensionContext context) {
            super(spec);
            this.initSite = context.getUniqueId();
            int numNodes = spec.nodes();
            CcmBridge.Builder builder = CcmBridge.builder().withCassandraConfiguration("cluster_name", (Object)CLUSTER_NAME).withNodes(new int[]{numNodes});
            if (CcmBridge.DSE_ENABLEMENT.booleanValue()) {
                builder = builder.withCassandraConfiguration("metadata_directory", (Object)"$HOME/.stargate-test/cassandra/metadata");
            }
            for (Map.Entry<String, Object> e : cassandraConfig.entrySet()) {
                builder = builder.withCassandraConfiguration(e.getKey(), e.getValue());
            }
            for (Map.Entry<String, Object> e : dseConfig.entrySet()) {
                builder = builder.withDseConfiguration(e.getKey(), e.getValue());
            }
            this.ccm = builder.build();
            ImmutableList.Builder nodes = ImmutableList.builder();
            for (int i = 0; i < numNodes; ++i) {
                nodes.add((Object)new StorageNode(this, i));
            }
            this.nodes = nodes.build();
        }

        private Path configDirectory() {
            try {
                Field f = this.ccm.getClass().getDeclaredField("configDirectory");
                f.setAccessible(true);
                return (Path)f.get(this.ccm);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private File clusterDir() {
            return new File(this.configDirectory().toFile(), "ccm_1");
        }

        private File installDir() {
            File ccmConfig = new File(this.clusterDir(), "cluster.conf");
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            try {
                Map config = (Map)mapper.readValue(ccmConfig, Map.class);
                String dir = (String)config.get("install_dir");
                return new File(dir);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void start() {
            if (!EXTERNAL_BACKEND) {
                this.ccm.create();
                ShutdownHook.add(this);
                for (StorageNode node : this.nodes) {
                    node.start();
                }
                for (StorageNode node : this.nodes) {
                    node.awaitReady();
                }
                LOG.info("Storage cluster requested by {} has been started with version {}", (Object)this.initSite, (Object)this.clusterVersion());
            }
        }

        @Override
        public void close() {
            super.close();
            this.stop();
        }

        public void stop() {
            if (!EXTERNAL_BACKEND) {
                ShutdownHook.remove(this);
                try {
                    if (this.removed.compareAndSet(false, true)) {
                        this.dumpLogs();
                        for (StorageNode node : this.nodes) {
                            node.stop();
                        }
                        for (StorageNode node : this.nodes) {
                            node.awaitExit();
                        }
                        this.ccm.remove();
                        LOG.info("Storage cluster (version {}) that was requested by {} has been removed.", (Object)this.clusterVersion(), (Object)this.initSite);
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception during CCM cluster shutdown: " + e.getMessage(), (Throwable)e);
                }
            }
        }

        @Override
        public String infoForTestLog() {
            return "" + (this.isDse() ? "DSE " : "Cassandra ") + this.clusterVersion();
        }

        private void dumpLogs() {
            int errors = this.errorsDetected();
            if (errors == 0) {
                LOG.info("Skipping dumping storage cluster ({}) logs: no test failures ({} tests skipped).", (Object)this.infoForTestLog(), (Object)this.testsSkipped());
                return;
            }
            LOG.warn("Dumping storage cluster ({}) logs due to {} test failures ({} tests skipped).", new Object[]{this.infoForTestLog(), errors, this.testsSkipped()});
            Path configDir = this.configDirectory();
            Collection files = FileUtils.listFiles((File)configDir.toFile(), (String[])new String[]{"log"}, (boolean)true);
            int filesProcessed = 0;
            final AtomicInteger printedLines = new AtomicInteger(0);
            final AtomicInteger skippedLines = new AtomicInteger(0);
            for (File file : files) {
                final String relPath = configDir.relativize(file.toPath()).toString();
                if (!relPath.contains(File.separator + "logs" + File.separator)) continue;
                ++filesProcessed;
                try {
                    LogOutputStream dumper = new LogOutputStream(){

                        protected void processLine(String line, int logLevel) {
                            if (line.startsWith("DEBUG ")) {
                                skippedLines.incrementAndGet();
                            } else {
                                printedLines.incrementAndGet();
                                LOG.info("storage log: {}>> {}", (Object)relPath, (Object)line);
                            }
                        }
                    };
                    Throwable throwable = null;
                    try {
                        FileUtils.copyFile((File)file, (OutputStream)dumper);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dumper == null) continue;
                        if (throwable != null) {
                            try {
                                dumper.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dumper.close();
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            LOG.warn("Finished dumping storage logs ({} files): printed {} lines, skipped {} DEBUG lines", new Object[]{filesProcessed, printedLines.get(), skippedLines.get()});
        }

        @Override
        public String seedAddress() {
            return "127.0.0.1";
        }

        @Override
        public int storagePort() {
            return 7000;
        }

        @Override
        public int cqlPort() {
            return 9042;
        }

        @Override
        public String clusterName() {
            return CLUSTER_NAME;
        }

        @Override
        public String clusterVersion() {
            Version version = this.ccm.getDseVersion().orElse(this.ccm.getCassandraVersion());
            return String.format("%d.%d", version.getMajor(), version.getMinor());
        }

        @Override
        public boolean isDse() {
            return this.ccm.getDseVersion().isPresent();
        }

        @Override
        public String datacenter() {
            return DATACENTER;
        }

        @Override
        public String rack() {
            return "rack1";
        }
    }

    public static abstract class Cluster
    extends ExternalResource.Holder
    implements ClusterConnectionInfo,
    AutoCloseable {
        private final UUID id = UUID.randomUUID();
        private final ClusterSpec spec;
        private final AtomicInteger errorsInTest = new AtomicInteger(0);
        private final AtomicInteger skippedTests = new AtomicInteger(0);

        protected Cluster(ClusterSpec spec) {
            this.spec = spec;
        }

        @Override
        public String id() {
            return this.id.toString();
        }

        public abstract void start();

        public abstract String infoForTestLog();

        private void markSkippedTest() {
            this.skippedTests.incrementAndGet();
        }

        private void markErroredTest() {
            this.errorsInTest.incrementAndGet();
        }

        public int testsSkipped() {
            return this.skippedTests.get();
        }

        public int errorsDetected() {
            return this.errorsInTest.get();
        }
    }
}

