package io.stargate.proto;

import static io.stargate.proto.StargateGrpc.getServiceDescriptor;
import static io.grpc.stub.ServerCalls.asyncUnaryCall;
import static io.grpc.stub.ServerCalls.asyncServerStreamingCall;
import static io.grpc.stub.ServerCalls.asyncClientStreamingCall;
import static io.grpc.stub.ServerCalls.asyncBidiStreamingCall;


@javax.annotation.Generated(
value = "by ReactorGrpc generator",
comments = "Source: stargate.proto")
public final class ReactorStargateGrpc {
    private ReactorStargateGrpc() {}

    public static ReactorStargateStub newReactorStub(io.grpc.Channel channel) {
        return new ReactorStargateStub(channel);
    }

    /**
     * <pre>
     *  The gPRC service to interact with a Stargate coordinator.
     * </pre>
     */
    public static final class ReactorStargateStub extends io.grpc.stub.AbstractStub<ReactorStargateStub> {
        private StargateGrpc.StargateStub delegateStub;

        private ReactorStargateStub(io.grpc.Channel channel) {
            super(channel);
            delegateStub = StargateGrpc.newStub(channel);
        }

        private ReactorStargateStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
            delegateStub = StargateGrpc.newStub(channel).build(channel, callOptions);
        }

        @Override
        protected ReactorStargateStub build(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new ReactorStargateStub(channel, callOptions);
        }

        /**
         * <pre>
         *  Executes a single CQL query.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Response> executeQuery(reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Query> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::executeQuery, getCallOptions());
        }

        /**
         * <pre>
         *  Executes a bi-directional streaming for CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.StreamingResponse> executeQueryStream(reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.Query> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.manyToMany(reactorRequest, delegateStub::executeQueryStream, getCallOptions());
        }

        /**
         * <pre>
         *  Executes a batch of CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Response> executeBatch(reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Batch> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactorRequest, delegateStub::executeBatch, getCallOptions());
        }

        /**
         * <pre>
         *  Executes a bi-directional streaming for batches of CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.StreamingResponse> executeBatchStream(reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.Batch> reactorRequest) {
            return com.salesforce.reactorgrpc.stub.ClientCalls.manyToMany(reactorRequest, delegateStub::executeBatchStream, getCallOptions());
        }

        /**
         * <pre>
         *  Executes a single CQL query.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Response> executeQuery(io.stargate.proto.QueryOuterClass.Query reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::executeQuery, getCallOptions());
        }

        /**
         * <pre>
         *  Executes a batch of CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Response> executeBatch(io.stargate.proto.QueryOuterClass.Batch reactorRequest) {
           return com.salesforce.reactorgrpc.stub.ClientCalls.oneToOne(reactor.core.publisher.Mono.just(reactorRequest), delegateStub::executeBatch, getCallOptions());
        }

    }

    /**
     * <pre>
     *  The gPRC service to interact with a Stargate coordinator.
     * </pre>
     */
    public static abstract class StargateImplBase implements io.grpc.BindableService {

        /**
         * <pre>
         *  Executes a single CQL query.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Response> executeQuery(reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Query> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Executes a bi-directional streaming for CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.StreamingResponse> executeQueryStream(reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.Query> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Executes a batch of CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Response> executeBatch(reactor.core.publisher.Mono<io.stargate.proto.QueryOuterClass.Batch> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        /**
         * <pre>
         *  Executes a bi-directional streaming for batches of CQL queries.
         * </pre>
         */
        public reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.StreamingResponse> executeBatchStream(reactor.core.publisher.Flux<io.stargate.proto.QueryOuterClass.Batch> request) {
            throw new io.grpc.StatusRuntimeException(io.grpc.Status.UNIMPLEMENTED);
        }

        @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                    .addMethod(
                            io.stargate.proto.StargateGrpc.getExecuteQueryMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.stargate.proto.QueryOuterClass.Query,
                                            io.stargate.proto.QueryOuterClass.Response>(
                                            this, METHODID_EXECUTE_QUERY)))
                    .addMethod(
                            io.stargate.proto.StargateGrpc.getExecuteQueryStreamMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            io.stargate.proto.QueryOuterClass.Query,
                                            io.stargate.proto.QueryOuterClass.StreamingResponse>(
                                            this, METHODID_EXECUTE_QUERY_STREAM)))
                    .addMethod(
                            io.stargate.proto.StargateGrpc.getExecuteBatchMethod(),
                            asyncUnaryCall(
                                    new MethodHandlers<
                                            io.stargate.proto.QueryOuterClass.Batch,
                                            io.stargate.proto.QueryOuterClass.Response>(
                                            this, METHODID_EXECUTE_BATCH)))
                    .addMethod(
                            io.stargate.proto.StargateGrpc.getExecuteBatchStreamMethod(),
                            asyncBidiStreamingCall(
                                    new MethodHandlers<
                                            io.stargate.proto.QueryOuterClass.Batch,
                                            io.stargate.proto.QueryOuterClass.StreamingResponse>(
                                            this, METHODID_EXECUTE_BATCH_STREAM)))
                    .build();
        }

        protected io.grpc.CallOptions getCallOptions(int methodId) {
            return null;
        }

    }

    public static final int METHODID_EXECUTE_QUERY = 0;
    public static final int METHODID_EXECUTE_QUERY_STREAM = 1;
    public static final int METHODID_EXECUTE_BATCH = 2;
    public static final int METHODID_EXECUTE_BATCH_STREAM = 3;

    private static final class MethodHandlers<Req, Resp> implements
            io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
            io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final StargateImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(StargateImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_EXECUTE_QUERY:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((io.stargate.proto.QueryOuterClass.Query) request,
                            (io.grpc.stub.StreamObserver<io.stargate.proto.QueryOuterClass.Response>) responseObserver,
                            serviceImpl::executeQuery);
                    break;
                case METHODID_EXECUTE_BATCH:
                    com.salesforce.reactorgrpc.stub.ServerCalls.oneToOne((io.stargate.proto.QueryOuterClass.Batch) request,
                            (io.grpc.stub.StreamObserver<io.stargate.proto.QueryOuterClass.Response>) responseObserver,
                            serviceImpl::executeBatch);
                    break;
                default:
                    throw new java.lang.AssertionError();
            }
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_EXECUTE_QUERY_STREAM:
                    return (io.grpc.stub.StreamObserver<Req>) com.salesforce.reactorgrpc.stub.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<io.stargate.proto.QueryOuterClass.StreamingResponse>) responseObserver,
                            serviceImpl::executeQueryStream, serviceImpl.getCallOptions(methodId));
                case METHODID_EXECUTE_BATCH_STREAM:
                    return (io.grpc.stub.StreamObserver<Req>) com.salesforce.reactorgrpc.stub.ServerCalls.manyToMany(
                            (io.grpc.stub.StreamObserver<io.stargate.proto.QueryOuterClass.StreamingResponse>) responseObserver,
                            serviceImpl::executeBatchStream, serviceImpl.getCallOptions(methodId));
                default:
                    throw new java.lang.AssertionError();
            }
        }
    }

}
