/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.testing;

import io.stargate.auth.AuthorizationProcessor;
import io.stargate.core.activator.BaseActivator;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.db.metrics.api.ClientInfoMetricsTagProvider;
import io.stargate.grpc.metrics.api.GrpcMetricsTagProvider;
import io.stargate.grpc.metrics.api.UserAgentTagProvider;
import io.stargate.testing.auth.LoggingAuthorizationProcessorImpl;
import io.stargate.testing.metrics.AuthorityGrpcMetricsTagProvider;
import io.stargate.testing.metrics.FixedClientInfoTagProvider;
import io.stargate.testing.metrics.TagMeHttpMetricsTagProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class TestingServicesActivator
extends BaseActivator {
    public static final String AUTHZ_PROCESSOR_PROPERTY = "stargate.authorization.processor.id";
    public static final String LOGGING_AUTHZ_PROCESSOR_ID = "LoggingAuthzProcessor";
    public static final String HTTP_TAG_PROVIDER_PROPERTY = "stargate.metrics.http_tag_provider.id";
    public static final String TAG_ME_HTTP_TAG_PROVIDER = "TagMeProvider";
    public static final String GRPC_TAG_PROVIDER_PROPERTY = "stargate.metrics.grpc_tag_provider.id";
    public static final String AUTHORITY_GRPC_TAG_PROVIDER = "AuthorityGrpcProvider";
    public static final String USER_AGENT_GRPC_TAG_PROVIDER = "UserAgentGrpcProvider";
    public static final String CLIENT_INFO_TAG_PROVIDER_PROPERTY = "stargate.metrics.client_info_tag_provider.id";
    public static final String FIXED_TAG_PROVIDER = "FixedProvider";

    public TestingServicesActivator() {
        super("testing-services");
    }

    protected List<BaseActivator.ServiceAndProperties> createServices() {
        Object tagProvider;
        String grpcTagProvider;
        Object tagProvider2;
        ArrayList<BaseActivator.ServiceAndProperties> services = new ArrayList<BaseActivator.ServiceAndProperties>();
        if (LOGGING_AUTHZ_PROCESSOR_ID.equals(System.getProperty(AUTHZ_PROCESSOR_PROPERTY))) {
            LoggingAuthorizationProcessorImpl authzProcessor = new LoggingAuthorizationProcessorImpl();
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("AuthProcessorId", LOGGING_AUTHZ_PROCESSOR_ID);
            services.add(new BaseActivator.ServiceAndProperties((Object)authzProcessor, AuthorizationProcessor.class, props));
        }
        if (TAG_ME_HTTP_TAG_PROVIDER.equals(System.getProperty(HTTP_TAG_PROVIDER_PROPERTY))) {
            tagProvider2 = new TagMeHttpMetricsTagProvider();
            services.add(new BaseActivator.ServiceAndProperties(tagProvider2, HttpMetricsTagProvider.class));
        }
        if (FIXED_TAG_PROVIDER.equals(System.getProperty(CLIENT_INFO_TAG_PROVIDER_PROPERTY))) {
            tagProvider2 = new FixedClientInfoTagProvider();
            services.add(new BaseActivator.ServiceAndProperties(tagProvider2, ClientInfoMetricsTagProvider.class));
        }
        if (AUTHORITY_GRPC_TAG_PROVIDER.equals(grpcTagProvider = System.getProperty(GRPC_TAG_PROVIDER_PROPERTY))) {
            tagProvider = new AuthorityGrpcMetricsTagProvider();
            services.add(new BaseActivator.ServiceAndProperties(tagProvider, GrpcMetricsTagProvider.class));
        } else if (USER_AGENT_GRPC_TAG_PROVIDER.equals(grpcTagProvider)) {
            tagProvider = new UserAgentTagProvider(){};
            services.add(new BaseActivator.ServiceAndProperties(tagProvider, GrpcMetricsTagProvider.class));
        }
        return services;
    }

    protected void stopService() {
    }

    protected List<BaseActivator.ServicePointer<?>> dependencies() {
        return Collections.emptyList();
    }
}

