package io.stargate.it.storage;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SslForCqlParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSslForCqlParameters.builder()}.
 */
@Generated(from = "SslForCqlParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSslForCqlParameters implements SslForCqlParameters {
  private final boolean enabled;
  private final boolean optional;
  private final boolean requireClientCertificates;
  private transient final int hashCode;

  private ImmutableSslForCqlParameters(ImmutableSslForCqlParameters.Builder builder) {
    if (builder.enabledIsSet()) {
      initShim.enabled(builder.enabled);
    }
    if (builder.optionalIsSet()) {
      initShim.optional(builder.optional);
    }
    if (builder.requireClientCertificatesIsSet()) {
      initShim.requireClientCertificates(builder.requireClientCertificates);
    }
    this.enabled = initShim.enabled();
    this.optional = initShim.optional();
    this.requireClientCertificates = initShim.requireClientCertificates();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableSslForCqlParameters(boolean enabled, boolean optional, boolean requireClientCertificates) {
    this.enabled = enabled;
    this.optional = optional;
    this.requireClientCertificates = requireClientCertificates;
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "SslForCqlParameters", generator = "Immutables")
  private final class InitShim {
    private byte enabledBuildStage = STAGE_UNINITIALIZED;
    private boolean enabled;

    boolean enabled() {
      if (enabledBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (enabledBuildStage == STAGE_UNINITIALIZED) {
        enabledBuildStage = STAGE_INITIALIZING;
        this.enabled = enabledInitialize();
        enabledBuildStage = STAGE_INITIALIZED;
      }
      return this.enabled;
    }

    void enabled(boolean enabled) {
      this.enabled = enabled;
      enabledBuildStage = STAGE_INITIALIZED;
    }

    private byte optionalBuildStage = STAGE_UNINITIALIZED;
    private boolean optional;

    boolean optional() {
      if (optionalBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (optionalBuildStage == STAGE_UNINITIALIZED) {
        optionalBuildStage = STAGE_INITIALIZING;
        this.optional = optionalInitialize();
        optionalBuildStage = STAGE_INITIALIZED;
      }
      return this.optional;
    }

    void optional(boolean optional) {
      this.optional = optional;
      optionalBuildStage = STAGE_INITIALIZED;
    }

    private byte requireClientCertificatesBuildStage = STAGE_UNINITIALIZED;
    private boolean requireClientCertificates;

    boolean requireClientCertificates() {
      if (requireClientCertificatesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (requireClientCertificatesBuildStage == STAGE_UNINITIALIZED) {
        requireClientCertificatesBuildStage = STAGE_INITIALIZING;
        this.requireClientCertificates = requireClientCertificatesInitialize();
        requireClientCertificatesBuildStage = STAGE_INITIALIZED;
      }
      return this.requireClientCertificates;
    }

    void requireClientCertificates(boolean requireClientCertificates) {
      this.requireClientCertificates = requireClientCertificates;
      requireClientCertificatesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (enabledBuildStage == STAGE_INITIALIZING) attributes.add("enabled");
      if (optionalBuildStage == STAGE_INITIALIZING) attributes.add("optional");
      if (requireClientCertificatesBuildStage == STAGE_INITIALIZING) attributes.add("requireClientCertificates");
      return "Cannot build SslForCqlParameters, attribute initializers form cycle " + attributes;
    }
  }

  private boolean enabledInitialize() {
    return SslForCqlParameters.super.enabled();
  }

  private boolean optionalInitialize() {
    return SslForCqlParameters.super.optional();
  }

  private boolean requireClientCertificatesInitialize() {
    return SslForCqlParameters.super.requireClientCertificates();
  }

  /**
   * @return The value of the {@code enabled} attribute
   */
  @Override
  public boolean enabled() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.enabled()
        : this.enabled;
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @Override
  public boolean optional() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.optional()
        : this.optional;
  }

  /**
   * @return The value of the {@code requireClientCertificates} attribute
   */
  @Override
  public boolean requireClientCertificates() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.requireClientCertificates()
        : this.requireClientCertificates;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SslForCqlParameters#enabled() enabled} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enabled
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSslForCqlParameters withEnabled(boolean value) {
    if (this.enabled == value) return this;
    return new ImmutableSslForCqlParameters(value, this.optional, this.requireClientCertificates);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SslForCqlParameters#optional() optional} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optional
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSslForCqlParameters withOptional(boolean value) {
    if (this.optional == value) return this;
    return new ImmutableSslForCqlParameters(this.enabled, value, this.requireClientCertificates);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SslForCqlParameters#requireClientCertificates() requireClientCertificates} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requireClientCertificates
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSslForCqlParameters withRequireClientCertificates(boolean value) {
    if (this.requireClientCertificates == value) return this;
    return new ImmutableSslForCqlParameters(this.enabled, this.optional, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSslForCqlParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSslForCqlParameters
        && equalTo((ImmutableSslForCqlParameters) another);
  }

  private boolean equalTo(ImmutableSslForCqlParameters another) {
    if (hashCode != another.hashCode) return false;
    return enabled == another.enabled
        && optional == another.optional
        && requireClientCertificates == another.requireClientCertificates;
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code enabled}, {@code optional}, {@code requireClientCertificates}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(enabled);
    h += (h << 5) + Booleans.hashCode(optional);
    h += (h << 5) + Booleans.hashCode(requireClientCertificates);
    return h;
  }

  /**
   * Prints the immutable value {@code SslForCqlParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SslForCqlParameters")
        .omitNullValues()
        .add("enabled", enabled)
        .add("optional", optional)
        .add("requireClientCertificates", requireClientCertificates)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SslForCqlParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SslForCqlParameters instance
   */
  public static ImmutableSslForCqlParameters copyOf(SslForCqlParameters instance) {
    if (instance instanceof ImmutableSslForCqlParameters) {
      return (ImmutableSslForCqlParameters) instance;
    }
    return ImmutableSslForCqlParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSslForCqlParameters ImmutableSslForCqlParameters}.
   * <pre>
   * ImmutableSslForCqlParameters.builder()
   *    .enabled(boolean) // optional {@link SslForCqlParameters#enabled() enabled}
   *    .optional(boolean) // optional {@link SslForCqlParameters#optional() optional}
   *    .requireClientCertificates(boolean) // optional {@link SslForCqlParameters#requireClientCertificates() requireClientCertificates}
   *    .build();
   * </pre>
   * @return A new ImmutableSslForCqlParameters builder
   */
  public static ImmutableSslForCqlParameters.Builder builder() {
    return new ImmutableSslForCqlParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSslForCqlParameters ImmutableSslForCqlParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SslForCqlParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements SslForCqlParameters.Builder {
    private static final long OPT_BIT_ENABLED = 0x1L;
    private static final long OPT_BIT_OPTIONAL = 0x2L;
    private static final long OPT_BIT_REQUIRE_CLIENT_CERTIFICATES = 0x4L;
    private long optBits;

    private boolean enabled;
    private boolean optional;
    private boolean requireClientCertificates;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SslForCqlParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SslForCqlParameters instance) {
      Objects.requireNonNull(instance, "instance");
      enabled(instance.enabled());
      optional(instance.optional());
      requireClientCertificates(instance.requireClientCertificates());
      return this;
    }

    /**
     * Initializes the value for the {@link SslForCqlParameters#enabled() enabled} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SslForCqlParameters#enabled() enabled}.</em>
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      optBits |= OPT_BIT_ENABLED;
      return this;
    }

    /**
     * Initializes the value for the {@link SslForCqlParameters#optional() optional} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SslForCqlParameters#optional() optional}.</em>
     * @param optional The value for optional 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder optional(boolean optional) {
      this.optional = optional;
      optBits |= OPT_BIT_OPTIONAL;
      return this;
    }

    /**
     * Initializes the value for the {@link SslForCqlParameters#requireClientCertificates() requireClientCertificates} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SslForCqlParameters#requireClientCertificates() requireClientCertificates}.</em>
     * @param requireClientCertificates The value for requireClientCertificates 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder requireClientCertificates(boolean requireClientCertificates) {
      this.requireClientCertificates = requireClientCertificates;
      optBits |= OPT_BIT_REQUIRE_CLIENT_CERTIFICATES;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSslForCqlParameters ImmutableSslForCqlParameters}.
     * @return An immutable instance of SslForCqlParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSslForCqlParameters build() {
      return new ImmutableSslForCqlParameters(this);
    }

    private boolean enabledIsSet() {
      return (optBits & OPT_BIT_ENABLED) != 0;
    }

    private boolean optionalIsSet() {
      return (optBits & OPT_BIT_OPTIONAL) != 0;
    }

    private boolean requireClientCertificatesIsSet() {
      return (optBits & OPT_BIT_REQUIRE_CLIENT_CERTIFICATES) != 0;
    }
  }
}
