package io.stargate.it.storage;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link StargateParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStargateParameters.builder()}.
 */
@Generated(from = "StargateParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStargateParameters implements StargateParameters {
  private final boolean enableAuth;
  private final ImmutableMap<String, String> systemProperties;
  private final boolean useProxyProtocol;
  private final String proxyDnsName;
  private final int proxyPort;
  private final SslForCqlParameters sslForCqlParameters;
  private transient final int hashCode;

  private ImmutableStargateParameters(ImmutableStargateParameters.Builder builder) {
    if (builder.enableAuthIsSet()) {
      initShim.enableAuth(builder.enableAuth);
    }
    if (builder.systemPropertiesIsSet()) {
      initShim.systemProperties(builder.systemProperties.build());
    }
    if (builder.useProxyProtocolIsSet()) {
      initShim.useProxyProtocol(builder.useProxyProtocol);
    }
    if (builder.proxyDnsName != null) {
      initShim.proxyDnsName(builder.proxyDnsName);
    }
    if (builder.proxyPortIsSet()) {
      initShim.proxyPort(builder.proxyPort);
    }
    if (builder.sslForCqlParameters != null) {
      initShim.sslForCqlParameters(builder.sslForCqlParameters);
    }
    this.enableAuth = initShim.enableAuth();
    this.systemProperties = initShim.systemProperties();
    this.useProxyProtocol = initShim.useProxyProtocol();
    this.proxyDnsName = initShim.proxyDnsName();
    this.proxyPort = initShim.proxyPort();
    this.sslForCqlParameters = initShim.sslForCqlParameters();
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private ImmutableStargateParameters(
      boolean enableAuth,
      ImmutableMap<String, String> systemProperties,
      boolean useProxyProtocol,
      String proxyDnsName,
      int proxyPort,
      SslForCqlParameters sslForCqlParameters) {
    this.enableAuth = enableAuth;
    this.systemProperties = systemProperties;
    this.useProxyProtocol = useProxyProtocol;
    this.proxyDnsName = proxyDnsName;
    this.proxyPort = proxyPort;
    this.sslForCqlParameters = sslForCqlParameters;
    this.hashCode = computeHashCode();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "StargateParameters", generator = "Immutables")
  private final class InitShim {
    private byte enableAuthBuildStage = STAGE_UNINITIALIZED;
    private boolean enableAuth;

    boolean enableAuth() {
      if (enableAuthBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (enableAuthBuildStage == STAGE_UNINITIALIZED) {
        enableAuthBuildStage = STAGE_INITIALIZING;
        this.enableAuth = enableAuthInitialize();
        enableAuthBuildStage = STAGE_INITIALIZED;
      }
      return this.enableAuth;
    }

    void enableAuth(boolean enableAuth) {
      this.enableAuth = enableAuth;
      enableAuthBuildStage = STAGE_INITIALIZED;
    }

    private byte systemPropertiesBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMap<String, String> systemProperties;

    ImmutableMap<String, String> systemProperties() {
      if (systemPropertiesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (systemPropertiesBuildStage == STAGE_UNINITIALIZED) {
        systemPropertiesBuildStage = STAGE_INITIALIZING;
        this.systemProperties = ImmutableMap.copyOf(systemPropertiesInitialize());
        systemPropertiesBuildStage = STAGE_INITIALIZED;
      }
      return this.systemProperties;
    }

    void systemProperties(ImmutableMap<String, String> systemProperties) {
      this.systemProperties = systemProperties;
      systemPropertiesBuildStage = STAGE_INITIALIZED;
    }

    private byte useProxyProtocolBuildStage = STAGE_UNINITIALIZED;
    private boolean useProxyProtocol;

    boolean useProxyProtocol() {
      if (useProxyProtocolBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (useProxyProtocolBuildStage == STAGE_UNINITIALIZED) {
        useProxyProtocolBuildStage = STAGE_INITIALIZING;
        this.useProxyProtocol = useProxyProtocolInitialize();
        useProxyProtocolBuildStage = STAGE_INITIALIZED;
      }
      return this.useProxyProtocol;
    }

    void useProxyProtocol(boolean useProxyProtocol) {
      this.useProxyProtocol = useProxyProtocol;
      useProxyProtocolBuildStage = STAGE_INITIALIZED;
    }

    private byte proxyDnsNameBuildStage = STAGE_UNINITIALIZED;
    private String proxyDnsName;

    String proxyDnsName() {
      if (proxyDnsNameBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (proxyDnsNameBuildStage == STAGE_UNINITIALIZED) {
        proxyDnsNameBuildStage = STAGE_INITIALIZING;
        this.proxyDnsName = Objects.requireNonNull(proxyDnsNameInitialize(), "proxyDnsName");
        proxyDnsNameBuildStage = STAGE_INITIALIZED;
      }
      return this.proxyDnsName;
    }

    void proxyDnsName(String proxyDnsName) {
      this.proxyDnsName = proxyDnsName;
      proxyDnsNameBuildStage = STAGE_INITIALIZED;
    }

    private byte proxyPortBuildStage = STAGE_UNINITIALIZED;
    private int proxyPort;

    int proxyPort() {
      if (proxyPortBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (proxyPortBuildStage == STAGE_UNINITIALIZED) {
        proxyPortBuildStage = STAGE_INITIALIZING;
        this.proxyPort = proxyPortInitialize();
        proxyPortBuildStage = STAGE_INITIALIZED;
      }
      return this.proxyPort;
    }

    void proxyPort(int proxyPort) {
      this.proxyPort = proxyPort;
      proxyPortBuildStage = STAGE_INITIALIZED;
    }

    private byte sslForCqlParametersBuildStage = STAGE_UNINITIALIZED;
    private SslForCqlParameters sslForCqlParameters;

    SslForCqlParameters sslForCqlParameters() {
      if (sslForCqlParametersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sslForCqlParametersBuildStage == STAGE_UNINITIALIZED) {
        sslForCqlParametersBuildStage = STAGE_INITIALIZING;
        this.sslForCqlParameters = Objects.requireNonNull(sslForCqlParametersInitialize(), "sslForCqlParameters");
        sslForCqlParametersBuildStage = STAGE_INITIALIZED;
      }
      return this.sslForCqlParameters;
    }

    void sslForCqlParameters(SslForCqlParameters sslForCqlParameters) {
      this.sslForCqlParameters = sslForCqlParameters;
      sslForCqlParametersBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (enableAuthBuildStage == STAGE_INITIALIZING) attributes.add("enableAuth");
      if (systemPropertiesBuildStage == STAGE_INITIALIZING) attributes.add("systemProperties");
      if (useProxyProtocolBuildStage == STAGE_INITIALIZING) attributes.add("useProxyProtocol");
      if (proxyDnsNameBuildStage == STAGE_INITIALIZING) attributes.add("proxyDnsName");
      if (proxyPortBuildStage == STAGE_INITIALIZING) attributes.add("proxyPort");
      if (sslForCqlParametersBuildStage == STAGE_INITIALIZING) attributes.add("sslForCqlParameters");
      return "Cannot build StargateParameters, attribute initializers form cycle " + attributes;
    }
  }

  private boolean enableAuthInitialize() {
    return StargateParameters.super.enableAuth();
  }

  private Map<String, String> systemPropertiesInitialize() {
    return StargateParameters.super.systemProperties();
  }

  private boolean useProxyProtocolInitialize() {
    return StargateParameters.super.useProxyProtocol();
  }

  private String proxyDnsNameInitialize() {
    return StargateParameters.super.proxyDnsName();
  }

  private int proxyPortInitialize() {
    return StargateParameters.super.proxyPort();
  }

  private SslForCqlParameters sslForCqlParametersInitialize() {
    return StargateParameters.super.sslForCqlParameters();
  }

  /**
   * @return The value of the {@code enableAuth} attribute
   */
  @Override
  public boolean enableAuth() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.enableAuth()
        : this.enableAuth;
  }

  /**
   * @return The value of the {@code systemProperties} attribute
   */
  @Override
  public ImmutableMap<String, String> systemProperties() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.systemProperties()
        : this.systemProperties;
  }

  /**
   * @return The value of the {@code useProxyProtocol} attribute
   */
  @Override
  public boolean useProxyProtocol() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.useProxyProtocol()
        : this.useProxyProtocol;
  }

  /**
   * @return The value of the {@code proxyDnsName} attribute
   */
  @Override
  public String proxyDnsName() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.proxyDnsName()
        : this.proxyDnsName;
  }

  /**
   * @return The value of the {@code proxyPort} attribute
   */
  @Override
  public int proxyPort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.proxyPort()
        : this.proxyPort;
  }

  /**
   * @return The value of the {@code sslForCqlParameters} attribute
   */
  @Override
  public SslForCqlParameters sslForCqlParameters() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sslForCqlParameters()
        : this.sslForCqlParameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StargateParameters#enableAuth() enableAuth} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enableAuth
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStargateParameters withEnableAuth(boolean value) {
    if (this.enableAuth == value) return this;
    return new ImmutableStargateParameters(
        value,
        this.systemProperties,
        this.useProxyProtocol,
        this.proxyDnsName,
        this.proxyPort,
        this.sslForCqlParameters);
  }

  /**
   * Copy the current immutable object by replacing the {@link StargateParameters#systemProperties() systemProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the systemProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStargateParameters withSystemProperties(Map<String, ? extends String> entries) {
    if (this.systemProperties == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableStargateParameters(
        this.enableAuth,
        newValue,
        this.useProxyProtocol,
        this.proxyDnsName,
        this.proxyPort,
        this.sslForCqlParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StargateParameters#useProxyProtocol() useProxyProtocol} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for useProxyProtocol
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStargateParameters withUseProxyProtocol(boolean value) {
    if (this.useProxyProtocol == value) return this;
    return new ImmutableStargateParameters(
        this.enableAuth,
        this.systemProperties,
        value,
        this.proxyDnsName,
        this.proxyPort,
        this.sslForCqlParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StargateParameters#proxyDnsName() proxyDnsName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for proxyDnsName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStargateParameters withProxyDnsName(String value) {
    String newValue = Objects.requireNonNull(value, "proxyDnsName");
    if (this.proxyDnsName.equals(newValue)) return this;
    return new ImmutableStargateParameters(
        this.enableAuth,
        this.systemProperties,
        this.useProxyProtocol,
        newValue,
        this.proxyPort,
        this.sslForCqlParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StargateParameters#proxyPort() proxyPort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for proxyPort
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStargateParameters withProxyPort(int value) {
    if (this.proxyPort == value) return this;
    return new ImmutableStargateParameters(
        this.enableAuth,
        this.systemProperties,
        this.useProxyProtocol,
        this.proxyDnsName,
        value,
        this.sslForCqlParameters);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StargateParameters#sslForCqlParameters() sslForCqlParameters} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sslForCqlParameters
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStargateParameters withSslForCqlParameters(SslForCqlParameters value) {
    if (this.sslForCqlParameters == value) return this;
    SslForCqlParameters newValue = Objects.requireNonNull(value, "sslForCqlParameters");
    return new ImmutableStargateParameters(
        this.enableAuth,
        this.systemProperties,
        this.useProxyProtocol,
        this.proxyDnsName,
        this.proxyPort,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStargateParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStargateParameters
        && equalTo((ImmutableStargateParameters) another);
  }

  private boolean equalTo(ImmutableStargateParameters another) {
    if (hashCode != another.hashCode) return false;
    return enableAuth == another.enableAuth
        && systemProperties.equals(another.systemProperties)
        && useProxyProtocol == another.useProxyProtocol
        && proxyDnsName.equals(another.proxyDnsName)
        && proxyPort == another.proxyPort
        && sslForCqlParameters.equals(another.sslForCqlParameters);
  }

  /**
   * Returns a precomputed-on-construction hash code from attributes: {@code enableAuth}, {@code systemProperties}, {@code useProxyProtocol}, {@code proxyDnsName}, {@code proxyPort}, {@code sslForCqlParameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return hashCode;
  }

  private int computeHashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(enableAuth);
    h += (h << 5) + systemProperties.hashCode();
    h += (h << 5) + Booleans.hashCode(useProxyProtocol);
    h += (h << 5) + proxyDnsName.hashCode();
    h += (h << 5) + proxyPort;
    h += (h << 5) + sslForCqlParameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code StargateParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StargateParameters")
        .omitNullValues()
        .add("enableAuth", enableAuth)
        .add("systemProperties", systemProperties)
        .add("useProxyProtocol", useProxyProtocol)
        .add("proxyDnsName", proxyDnsName)
        .add("proxyPort", proxyPort)
        .add("sslForCqlParameters", sslForCqlParameters)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link StargateParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StargateParameters instance
   */
  public static ImmutableStargateParameters copyOf(StargateParameters instance) {
    if (instance instanceof ImmutableStargateParameters) {
      return (ImmutableStargateParameters) instance;
    }
    return ImmutableStargateParameters.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStargateParameters ImmutableStargateParameters}.
   * <pre>
   * ImmutableStargateParameters.builder()
   *    .enableAuth(boolean) // optional {@link StargateParameters#enableAuth() enableAuth}
   *    .putSystemProperties|putAllSystemProperties(String =&gt; String) // {@link StargateParameters#systemProperties() systemProperties} mappings
   *    .useProxyProtocol(boolean) // optional {@link StargateParameters#useProxyProtocol() useProxyProtocol}
   *    .proxyDnsName(String) // optional {@link StargateParameters#proxyDnsName() proxyDnsName}
   *    .proxyPort(int) // optional {@link StargateParameters#proxyPort() proxyPort}
   *    .sslForCqlParameters(io.stargate.it.storage.SslForCqlParameters) // optional {@link StargateParameters#sslForCqlParameters() sslForCqlParameters}
   *    .build();
   * </pre>
   * @return A new ImmutableStargateParameters builder
   */
  public static ImmutableStargateParameters.Builder builder() {
    return new ImmutableStargateParameters.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStargateParameters ImmutableStargateParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "StargateParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder implements StargateParameters.Builder {
    private static final long OPT_BIT_ENABLE_AUTH = 0x1L;
    private static final long OPT_BIT_SYSTEM_PROPERTIES = 0x2L;
    private static final long OPT_BIT_USE_PROXY_PROTOCOL = 0x4L;
    private static final long OPT_BIT_PROXY_PORT = 0x8L;
    private long optBits;

    private boolean enableAuth;
    private ImmutableMap.Builder<String, String> systemProperties = ImmutableMap.builder();
    private boolean useProxyProtocol;
    private @Nullable String proxyDnsName;
    private int proxyPort;
    private @Nullable SslForCqlParameters sslForCqlParameters;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StargateParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(StargateParameters instance) {
      Objects.requireNonNull(instance, "instance");
      enableAuth(instance.enableAuth());
      putAllSystemProperties(instance.systemProperties());
      useProxyProtocol(instance.useProxyProtocol());
      proxyDnsName(instance.proxyDnsName());
      proxyPort(instance.proxyPort());
      sslForCqlParameters(instance.sslForCqlParameters());
      return this;
    }

    /**
     * Initializes the value for the {@link StargateParameters#enableAuth() enableAuth} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StargateParameters#enableAuth() enableAuth}.</em>
     * @param enableAuth The value for enableAuth 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enableAuth(boolean enableAuth) {
      this.enableAuth = enableAuth;
      optBits |= OPT_BIT_ENABLE_AUTH;
      return this;
    }

    /**
     * Put one entry to the {@link StargateParameters#systemProperties() systemProperties} map.
     * @param key The key in the systemProperties map
     * @param value The associated value in the systemProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSystemProperties(String key, String value) {
      this.systemProperties.put(key, value);
      optBits |= OPT_BIT_SYSTEM_PROPERTIES;
      return this;
    }

    /**
     * Put one entry to the {@link StargateParameters#systemProperties() systemProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putSystemProperties(Map.Entry<String, ? extends String> entry) {
      this.systemProperties.put(entry);
      optBits |= OPT_BIT_SYSTEM_PROPERTIES;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link StargateParameters#systemProperties() systemProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the systemProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder systemProperties(Map<String, ? extends String> entries) {
      this.systemProperties = ImmutableMap.builder();
      optBits |= OPT_BIT_SYSTEM_PROPERTIES;
      return putAllSystemProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link StargateParameters#systemProperties() systemProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the systemProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllSystemProperties(Map<String, ? extends String> entries) {
      this.systemProperties.putAll(entries);
      optBits |= OPT_BIT_SYSTEM_PROPERTIES;
      return this;
    }

    /**
     * Initializes the value for the {@link StargateParameters#useProxyProtocol() useProxyProtocol} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StargateParameters#useProxyProtocol() useProxyProtocol}.</em>
     * @param useProxyProtocol The value for useProxyProtocol 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder useProxyProtocol(boolean useProxyProtocol) {
      this.useProxyProtocol = useProxyProtocol;
      optBits |= OPT_BIT_USE_PROXY_PROTOCOL;
      return this;
    }

    /**
     * Initializes the value for the {@link StargateParameters#proxyDnsName() proxyDnsName} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StargateParameters#proxyDnsName() proxyDnsName}.</em>
     * @param proxyDnsName The value for proxyDnsName 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder proxyDnsName(String proxyDnsName) {
      this.proxyDnsName = Objects.requireNonNull(proxyDnsName, "proxyDnsName");
      return this;
    }

    /**
     * Initializes the value for the {@link StargateParameters#proxyPort() proxyPort} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StargateParameters#proxyPort() proxyPort}.</em>
     * @param proxyPort The value for proxyPort 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder proxyPort(int proxyPort) {
      this.proxyPort = proxyPort;
      optBits |= OPT_BIT_PROXY_PORT;
      return this;
    }

    /**
     * Initializes the value for the {@link StargateParameters#sslForCqlParameters() sslForCqlParameters} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link StargateParameters#sslForCqlParameters() sslForCqlParameters}.</em>
     * @param sslForCqlParameters The value for sslForCqlParameters 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sslForCqlParameters(SslForCqlParameters sslForCqlParameters) {
      this.sslForCqlParameters = Objects.requireNonNull(sslForCqlParameters, "sslForCqlParameters");
      return this;
    }

    /**
     * Builds a new {@link ImmutableStargateParameters ImmutableStargateParameters}.
     * @return An immutable instance of StargateParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStargateParameters build() {
      return new ImmutableStargateParameters(this);
    }

    private boolean enableAuthIsSet() {
      return (optBits & OPT_BIT_ENABLE_AUTH) != 0;
    }

    private boolean systemPropertiesIsSet() {
      return (optBits & OPT_BIT_SYSTEM_PROPERTIES) != 0;
    }

    private boolean useProxyProtocolIsSet() {
      return (optBits & OPT_BIT_USE_PROXY_PROTOCOL) != 0;
    }

    private boolean proxyPortIsSet() {
      return (optBits & OPT_BIT_PROXY_PORT) != 0;
    }
  }
}
