/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.metrics.jersey;

import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.micrometer.core.instrument.Tag;
import io.micrometer.jersey2.server.JerseyTagsProvider;
import io.micrometer.jersey2.server.MetricsApplicationEventListener;
import io.stargate.core.metrics.api.HttpMetricsTagProvider;
import io.stargate.core.metrics.api.Metrics;
import io.stargate.metrics.jersey.config.MetricsListenerConfig;
import io.stargate.metrics.jersey.config.SystemPropsMetricsListenerConfig;
import io.stargate.metrics.jersey.listener.CounterApplicationEventListener;
import io.stargate.metrics.jersey.tags.CompositeJerseyTagsProvider;
import io.stargate.metrics.jersey.tags.ConstantTagsProvider;
import io.stargate.metrics.jersey.tags.DocsApiModuleTagsProvider;
import io.stargate.metrics.jersey.tags.HeadersTagProvider;
import io.stargate.metrics.jersey.tags.HttpCounterTagsProvider;
import io.stargate.metrics.jersey.tags.HttpMeterTagsProvider;
import io.stargate.metrics.jersey.tags.NonApiModuleTagsProvider;
import io.stargate.metrics.jersey.tags.PathParametersTagsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MetricsBinder {
    private final Metrics metrics;
    private final HttpMetricsTagProvider httpMetricsTagProvider;
    private final String module;
    private final Collection<String> nonApiUriRegexes;
    private final MetricsListenerConfig meterListenerConfig;
    private final MetricsListenerConfig counterListenerConfig;

    public MetricsBinder(Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module) {
        this(metrics, httpMetricsTagProvider, module, Collections.emptyList());
    }

    public MetricsBinder(Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module, Collection<String> nonApiUriRegexes) {
        this(metrics, httpMetricsTagProvider, module, nonApiUriRegexes, new SystemPropsMetricsListenerConfig("stargate.metrics.http_meter_listener"), new SystemPropsMetricsListenerConfig("stargate.metrics.http_counter_listener"));
    }

    public MetricsBinder(Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module, Collection<String> nonApiUriRegexes, MetricsListenerConfig meterListenerConfig, MetricsListenerConfig counterListenerConfig) {
        this.metrics = metrics;
        this.httpMetricsTagProvider = httpMetricsTagProvider;
        this.module = module;
        this.nonApiUriRegexes = nonApiUriRegexes;
        this.meterListenerConfig = meterListenerConfig;
        this.counterListenerConfig = counterListenerConfig;
    }

    public void register(JerseyEnvironment jersey) {
        Object listener;
        if (this.meterListenerConfig.isEnabled()) {
            JerseyTagsProvider meterTagsProvider = this.getMeterTagsProvider(this.meterListenerConfig, this.metrics, this.httpMetricsTagProvider, this.module, this.nonApiUriRegexes);
            listener = new MetricsApplicationEventListener(this.metrics.getMeterRegistry(), meterTagsProvider, "http.server.requests", true);
            jersey.register(listener);
        }
        if (this.counterListenerConfig.isEnabled()) {
            JerseyTagsProvider counterTagsProvider = this.getCounterTagsProvider(this.counterListenerConfig, this.metrics, this.httpMetricsTagProvider, this.module, this.nonApiUriRegexes);
            listener = new CounterApplicationEventListener(this.metrics.getMeterRegistry(), counterTagsProvider, "http.server.requests.counter");
            jersey.register(listener);
        }
    }

    private JerseyTagsProvider getMeterTagsProvider(MetricsListenerConfig config, Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module, Collection<String> nonApiUriRegexes) {
        List<JerseyTagsProvider> allProviders = this.getMeterTagsProviders(config, metrics, httpMetricsTagProvider, module, nonApiUriRegexes);
        return new CompositeJerseyTagsProvider(allProviders);
    }

    protected List<JerseyTagsProvider> getMeterTagsProviders(MetricsListenerConfig config, Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module, Collection<String> nonApiUriRegexes) {
        HttpMeterTagsProvider resourceProvider = config.isIgnoreHttpMetricProvider() ? new HttpMeterTagsProvider() : new HttpMeterTagsProvider(httpMetricsTagProvider);
        ArrayList<JerseyTagsProvider> allProviders = new ArrayList<JerseyTagsProvider>(this.getDefaultTagsProvider(metrics, module, nonApiUriRegexes));
        allProviders.add(resourceProvider);
        return allProviders;
    }

    private JerseyTagsProvider getCounterTagsProvider(MetricsListenerConfig config, Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module, Collection<String> nonApiUriRegexes) {
        List<JerseyTagsProvider> allProviders = this.getCounterTagsProviders(config, metrics, httpMetricsTagProvider, module, nonApiUriRegexes);
        return new CompositeJerseyTagsProvider(allProviders);
    }

    protected List<JerseyTagsProvider> getCounterTagsProviders(MetricsListenerConfig config, Metrics metrics, HttpMetricsTagProvider httpMetricsTagProvider, String module, Collection<String> nonApiUriRegexes) {
        HttpCounterTagsProvider resourceProvider = config.isIgnoreHttpMetricProvider() ? new HttpCounterTagsProvider() : new HttpCounterTagsProvider(httpMetricsTagProvider);
        ArrayList<JerseyTagsProvider> allProviders = new ArrayList<JerseyTagsProvider>(this.getDefaultTagsProvider(metrics, module, nonApiUriRegexes));
        allProviders.add(resourceProvider);
        return allProviders;
    }

    protected List<JerseyTagsProvider> getDefaultTagsProvider(Metrics metrics, String module, Collection<String> nonApiUriRegexes) {
        ConstantTagsProvider defaultProvider = new ConstantTagsProvider((Iterable<Tag>)metrics.tagsForModule(module));
        PathParametersTagsProvider pathParametersProvider = new PathParametersTagsProvider();
        HeadersTagProvider headersTagProvider = new HeadersTagProvider();
        NonApiModuleTagsProvider nonApiModuleTagsProvider = new NonApiModuleTagsProvider(metrics, module, nonApiUriRegexes);
        DocsApiModuleTagsProvider docsApiProvider = new DocsApiModuleTagsProvider(metrics);
        return Arrays.asList(defaultProvider, pathParametersProvider, headersTagProvider, nonApiModuleTagsProvider, docsApiProvider);
    }
}

